/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.timeseries;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.log4j.Logger;

@Description(name="moving_stdev", value=" return the moving average of a time series for a given timewindow")
public class MovingStdevUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(MovingStdevUDF.class);
    private ListObjectInspector listInspector;
    private IntObjectInspector dayWindowInspector;

    private List<Double> parseDoubleList(List<Object> objList) {
        ArrayList<Double> arrList = new ArrayList<Double>();
        for (Object obj : objList) {
            Object dblObj = ((PrimitiveObjectInspector)this.listInspector.getListElementObjectInspector()).getPrimitiveJavaObject(obj);
            if (dblObj instanceof Number) {
                Number dblNum = (Number)dblObj;
                arrList.add(dblNum.doubleValue());
                continue;
            }
            String dblStr = dblObj.toString();
            try {
                Double dblCoerce = Double.parseDouble(dblStr);
                arrList.add(dblCoerce);
            }
            catch (NumberFormatException formatExc) {
                LOG.info((Object)(" Unable to interpret " + dblStr + " as a number"));
            }
        }
        return arrList;
    }

    public List<Double> evaluate(List<Object> timeSeriesObj, int dayWindow) {
        List<Double> timeSeries = this.parseDoubleList(timeSeriesObj);
        ArrayList<Double> mvnStdevTimeSeries = new ArrayList<Double>(timeSeries.size());
        double mvnTotal = 0.0;
        double mvnSqTotal = 0.0;
        for (int i = 0; i < timeSeries.size(); ++i) {
            double mvnStdev;
            mvnTotal += timeSeries.get(i).doubleValue();
            mvnSqTotal += Math.pow(timeSeries.get(i), 2.0);
            if (i >= dayWindow) {
                mvnStdev = Math.sqrt((mvnSqTotal -= Math.pow(timeSeries.get(i - dayWindow), 2.0)) / (double)dayWindow - Math.pow((mvnTotal -= timeSeries.get(i - dayWindow).doubleValue()) / (double)dayWindow, 2.0));
                mvnStdevTimeSeries.add(mvnStdev);
                continue;
            }
            if (i > 0) {
                mvnStdev = Math.sqrt(mvnSqTotal / ((double)i + 1.0) - Math.pow(mvnTotal / ((double)i + 1.0), 2.0));
                mvnStdevTimeSeries.add(mvnStdev);
                continue;
            }
            mvnStdevTimeSeries.add(0.0);
        }
        return mvnStdevTimeSeries;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        List argList = this.listInspector.getList(arg0[0].get());
        int dayWindow = this.dayWindowInspector.get(arg0[1].get());
        if (argList != null) {
            return this.evaluate(argList, dayWindow);
        }
        return null;
    }

    public String getDisplayString(String[] arg0) {
        return "moving_stdev(" + arg0[0] + ")";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length != 1 && arg0.length != 2) {
            throw new UDFArgumentException(" MovingStdevUDF takes 2 arguments, array<string>, string");
        }
        this.listInspector = (ListObjectInspector)arg0[0];
        if (this.listInspector.getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException(" MovingStdevUDF takes an array as first argument");
        }
        this.dayWindowInspector = (IntObjectInspector)arg0[1];
        if (this.dayWindowInspector.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException(" MovingStdevUDF takes a numeric string as second argument");
        }
        LOG.info((Object)("Moving Standard Deviation Object input type is " + this.listInspector + " element = " + this.listInspector.getListElementObjectInspector()));
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector);
    }
}

