/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.timeseries;

import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;

public final class NumericUtil {
    public static boolean isNumericCategory(PrimitiveObjectInspector.PrimitiveCategory cat) {
        switch (cat) {
            case DOUBLE: 
            case FLOAT: 
            case LONG: 
            case INT: 
            case SHORT: 
            case BYTE: {
                return true;
            }
        }
        return false;
    }

    public static double getNumericValue(PrimitiveObjectInspector objInsp, Object val) {
        switch (objInsp.getPrimitiveCategory()) {
            case DOUBLE: {
                return ((DoubleObjectInspector)objInsp).get(val);
            }
            case FLOAT: 
            case LONG: 
            case INT: 
            case SHORT: 
            case BYTE: {
                Number num = (Number)objInsp.getPrimitiveJavaObject(val);
                return num.doubleValue();
            }
        }
        return 0.0;
    }

    public static Object castToPrimitiveNumeric(double val, PrimitiveObjectInspector.PrimitiveCategory cat) {
        switch (cat) {
            case DOUBLE: {
                return new Double(val);
            }
            case FLOAT: {
                return new Float((float)val);
            }
            case LONG: {
                return new Long((long)val);
            }
            case INT: {
                return new Integer((int)val);
            }
            case SHORT: {
                return new Short((short)val);
            }
            case BYTE: {
                return new Byte((byte)val);
            }
        }
        return null;
    }
}

