/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.timeseries;

import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.log4j.Logger;

@Description(name="sum_array", value=" sum an array of doubles")
public class SumArrayUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(SumArrayUDF.class);
    private ListObjectInspector listInspector;

    public Double evaluate(List<Object> strArray) {
        double total = 0.0;
        for (Object obj : strArray) {
            Object dblObj = ((PrimitiveObjectInspector)this.listInspector.getListElementObjectInspector()).getPrimitiveJavaObject(obj);
            if (dblObj instanceof Number) {
                Number dblNum = (Number)dblObj;
                total += dblNum.doubleValue();
                continue;
            }
            String dblStr = dblObj.toString();
            try {
                Double dblCoerce = Double.parseDouble(dblStr);
                total += dblCoerce.doubleValue();
            }
            catch (NumberFormatException formatExc) {
                LOG.info((Object)(" Unable to interpret " + dblStr + " as a number"));
            }
        }
        return total;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        List argList = this.listInspector.getList(arg0[0].get());
        if (argList != null) {
            return this.evaluate(argList);
        }
        return null;
    }

    public String getDisplayString(String[] arg0) {
        return "sum_array()";
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        this.listInspector = (ListObjectInspector)arg0[0];
        LOG.info((Object)(" Sum Array input type is " + this.listInspector + " element = " + this.listInspector.getListElementObjectInspector()));
        JavaDoubleObjectInspector returnType = PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        return returnType;
    }
}

