/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.timeseries;

import brickhouse.udf.timeseries.NumericUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.log4j.Logger;

@Description(name="vector_cross_product", value=" Multiply a vector times another vector")
public class VectorCrossProductUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(VectorCrossProductUDF.class);
    private ListObjectInspector list1Inspector;
    private ListObjectInspector list2Inspector;
    private MapObjectInspector map1Inspector;
    private MapObjectInspector map2Inspector;
    private PrimitiveObjectInspector key1Inspector;
    private PrimitiveObjectInspector key2Inspector;
    private PrimitiveObjectInspector value1Inspector;
    private PrimitiveObjectInspector value2Inspector;
    private StandardListObjectInspector retListInspector;
    private StandardMapObjectInspector retMapInspector;

    public Object evaluateList(Object list1Obj, Object list2Obj) {
        int len2;
        int len1 = this.list1Inspector.getListLength(list1Obj);
        if (len1 != (len2 = this.list2Inspector.getListLength(list2Obj))) {
            LOG.warn((Object)("vector lengths do not match " + list1Obj + " :: " + list2Obj));
            return null;
        }
        Object retList = this.retListInspector.create(0);
        for (int i = 0; i < len1; ++i) {
            Object list1Val = this.list1Inspector.getListElement(list1Obj, i);
            double list1Dbl = NumericUtil.getNumericValue(this.value1Inspector, list1Val);
            Object list2Val = this.list2Inspector.getListElement(list2Obj, i);
            double list2Dbl = NumericUtil.getNumericValue(this.value2Inspector, list2Val);
            double newVal = list1Dbl * list2Dbl;
            this.retListInspector.set(retList, i, NumericUtil.castToPrimitiveNumeric(newVal, ((PrimitiveObjectInspector)this.retListInspector.getListElementObjectInspector()).getPrimitiveCategory()));
        }
        return retList;
    }

    public Object evaluateMap(Object uninspMapObj1, Object uninspMapObj2) {
        Object retMap = this.retMapInspector.create();
        Map map1 = this.map1Inspector.getMap(uninspMapObj1);
        Map map2 = this.map2Inspector.getMap(uninspMapObj2);
        boolean simpleLookup = this.map1Inspector.getMapKeyObjectInspector().getClass().equals(this.map2Inspector.getMapKeyObjectInspector());
        HashMap stdKeyMap = new HashMap();
        if (!simpleLookup) {
            for (Object mapKey2 : map2.keySet()) {
                Object stdKey2 = ObjectInspectorUtils.copyToStandardJavaObject(mapKey2, (ObjectInspector)this.map2Inspector.getMapKeyObjectInspector());
                stdKeyMap.put(stdKey2, mapKey2);
            }
        }
        for (Object mapKey1 : map1.keySet()) {
            Object mapVal1Obj = map1.get(mapKey1);
            double mapVal1Dbl = NumericUtil.getNumericValue(this.value1Inspector, mapVal1Obj);
            Object stdKey1 = ObjectInspectorUtils.copyToStandardJavaObject(mapKey1, (ObjectInspector)this.map1Inspector.getMapKeyObjectInspector());
            Object mapVal2Obj = null;
            mapVal2Obj = simpleLookup ? map2.get(mapKey1) : map2.get(stdKeyMap.get(stdKey1));
            if (mapVal2Obj == null) continue;
            double mapVal2Dbl = NumericUtil.getNumericValue(this.value2Inspector, mapVal2Obj);
            double newVal = mapVal1Dbl * mapVal2Dbl;
            Object stdVal = NumericUtil.castToPrimitiveNumeric(newVal, ((PrimitiveObjectInspector)this.retMapInspector.getMapValueObjectInspector()).getPrimitiveCategory());
            this.retMapInspector.put(retMap, stdKey1, stdVal);
        }
        return retMap;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        if (this.list1Inspector != null) {
            return this.evaluateList(arg0[0].get(), arg0[1].get());
        }
        return this.evaluateMap(arg0[0].get(), arg0[1].get());
    }

    public String getDisplayString(String[] arg0) {
        return "vector_cross_product";
    }

    private void usage(String message) throws UDFArgumentException {
        LOG.error((Object)("vector_cross_product: Multiply a vector times another vector : " + message));
        throw new UDFArgumentException("vector_scalar_mult: Multiply a vector times another vector : " + message);
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length != 2) {
            this.usage("Must have two arguments.");
        }
        if (arg0[0].getCategory() == ObjectInspector.Category.MAP) {
            if (arg0[1].getCategory() != ObjectInspector.Category.MAP) {
                this.usage("Vectors need to be both maps");
            }
            this.map1Inspector = (MapObjectInspector)arg0[0];
            this.map2Inspector = (MapObjectInspector)arg0[1];
            if (this.map1Inspector.getMapKeyObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                this.usage("First Vector map key must be a primitive");
            }
            this.key1Inspector = (PrimitiveObjectInspector)this.map1Inspector.getMapKeyObjectInspector();
            if (this.map2Inspector.getMapKeyObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                this.usage("Second Vector map key must be a primitive");
            }
            this.key2Inspector = (PrimitiveObjectInspector)this.map2Inspector.getMapKeyObjectInspector();
            if (this.key2Inspector.getPrimitiveCategory() != this.key1Inspector.getPrimitiveCategory()) {
                this.usage(" Map key types must match");
            }
            if (this.map1Inspector.getMapValueObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                this.usage("First Vector map value must be a primitive");
            }
            this.value1Inspector = (PrimitiveObjectInspector)this.map1Inspector.getMapValueObjectInspector();
            if (this.map2Inspector.getMapValueObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                this.usage("Second Vector map value must be a primitive");
            }
            this.value2Inspector = (PrimitiveObjectInspector)this.map2Inspector.getMapValueObjectInspector();
        } else if (arg0[0].getCategory() == ObjectInspector.Category.LIST) {
            if (arg0[1].getCategory() != ObjectInspector.Category.LIST) {
                this.usage("Vectors need to be both arrays");
            }
            this.list1Inspector = (ListObjectInspector)arg0[0];
            this.list2Inspector = (ListObjectInspector)arg0[1];
            if (this.list1Inspector.getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                this.usage("First Vector array value must be a primitive");
            }
            this.value1Inspector = (PrimitiveObjectInspector)this.list1Inspector.getListElementObjectInspector();
            if (this.list2Inspector.getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                this.usage("Second Vector array value must be a primitive");
            }
            this.value2Inspector = (PrimitiveObjectInspector)this.list2Inspector.getListElementObjectInspector();
        } else {
            this.usage("Arguments must be arrays or maps");
        }
        if (this.list1Inspector != null) {
            this.retListInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.value1Inspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA));
            return this.retListInspector;
        }
        this.retMapInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.map1Inspector.getMapKeyObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.value1Inspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA));
        return this.retMapInspector;
    }
}

