/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.timeseries;

import brickhouse.udf.timeseries.NumericUtil;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.log4j.Logger;

@Description(name="vector_normalize", value=" Normalize a Vector")
public class VectorNormalizeUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(VectorNormalizeUDF.class);
    private ListObjectInspector listInspector;
    private MapObjectInspector mapInspector;
    private PrimitiveObjectInspector valueInspector;
    private StandardListObjectInspector retListInspector;
    private StandardMapObjectInspector retMapInspector;

    public Object evaluateList(Object listObj) {
        double listDbl;
        Object listVal;
        int i;
        Object retList = this.retListInspector.create(0);
        double tot = 0.0;
        for (i = 0; i < this.listInspector.getListLength(listObj); ++i) {
            listVal = this.listInspector.getListElement(listObj, i);
            listDbl = NumericUtil.getNumericValue(this.valueInspector, listVal);
            tot += listDbl;
        }
        for (i = 0; i < this.listInspector.getListLength(listObj); ++i) {
            listVal = this.listInspector.getListElement(listObj, i);
            listDbl = NumericUtil.getNumericValue(this.valueInspector, listVal);
            this.retListInspector.set(retList, i, NumericUtil.castToPrimitiveNumeric(listDbl / tot, ((PrimitiveObjectInspector)this.retListInspector.getListElementObjectInspector()).getPrimitiveCategory()));
        }
        return retList;
    }

    public Object evaluateMap(Object uninspMapObj) {
        double mapValDbl;
        Object mapValObj;
        Object retMap = this.retMapInspector.create();
        Map map = this.mapInspector.getMap(uninspMapObj);
        double tot = 0.0;
        for (Object mapKey : map.keySet()) {
            mapValObj = map.get(mapKey);
            mapValDbl = NumericUtil.getNumericValue(this.valueInspector, mapValObj);
            tot += mapValDbl;
        }
        for (Object mapKey : map.keySet()) {
            mapValObj = map.get(mapKey);
            mapValDbl = NumericUtil.getNumericValue(this.valueInspector, mapValObj);
            double newVal = mapValDbl / tot;
            Object stdKey = ObjectInspectorUtils.copyToStandardJavaObject(mapKey, (ObjectInspector)this.mapInspector.getMapKeyObjectInspector());
            Object stdVal = NumericUtil.castToPrimitiveNumeric(newVal, ((PrimitiveObjectInspector)this.retMapInspector.getMapValueObjectInspector()).getPrimitiveCategory());
            this.retMapInspector.put(retMap, stdKey, stdVal);
        }
        return retMap;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        if (this.listInspector != null) {
            return this.evaluateList(arg0[0].get());
        }
        return this.evaluateMap(arg0[0].get());
    }

    public String getDisplayString(String[] arg0) {
        return "vector_normalize";
    }

    private void usage(String message) throws UDFArgumentException {
        LOG.error((Object)("vector_normalize: Normalize a vector : " + message));
        throw new UDFArgumentException("vector_normalize: Normalize a vector : " + message);
    }

    public ObjectInspector initialize(ObjectInspector[] arg0) throws UDFArgumentException {
        if (arg0.length != 1) {
            this.usage("Must have one argument.");
        }
        if (arg0[0].getCategory() == ObjectInspector.Category.MAP) {
            this.mapInspector = (MapObjectInspector)arg0[0];
            if (this.mapInspector.getMapKeyObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                this.usage("Vector map key must be a primitive");
            }
            if (this.mapInspector.getMapValueObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                this.usage("Vector map value must be a primitive");
            }
            this.valueInspector = (PrimitiveObjectInspector)this.mapInspector.getMapValueObjectInspector();
        } else if (arg0[0].getCategory() == ObjectInspector.Category.LIST) {
            this.listInspector = (ListObjectInspector)arg0[0];
            if (this.listInspector.getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                this.usage("Vector array value must be a primitive");
            }
            this.valueInspector = (PrimitiveObjectInspector)this.listInspector.getListElementObjectInspector();
        } else {
            this.usage("First argument must be an array or map");
        }
        if (!NumericUtil.isNumericCategory(this.valueInspector.getPrimitiveCategory())) {
            this.usage(" Vector values must be numeric");
        }
        if (this.listInspector != null) {
            this.retListInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.valueInspector));
            return this.retListInspector;
        }
        this.retMapInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.mapInspector.getMapKeyObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA), (ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.valueInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA));
        return this.retMapInspector;
    }
}

