/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.udf.timeseries;

import brickhouse.udf.timeseries.NumericUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="union_vector_sum", value="_FUNC_(x) - Aggregate adding vectors together ")
public class VectorUnionSumUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Vector sum takes one argument");
        }
        if (parameters[0].getCategory() == ObjectInspector.Category.LIST) {
            return new VectorArraySumUDAFEvaluator();
        }
        if (parameters[0].getCategory() == ObjectInspector.Category.MAP) {
            return new VectorMapSumUDAFEvaluator();
        }
        throw new UDFArgumentTypeException(0, " vector_union_sum aggregates either arrays or maps");
    }

    public static class VectorMapSumUDAFEvaluator
    extends GenericUDAFEvaluator {
        private MapObjectInspector inputOI;
        private StandardMapObjectInspector stdMapOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            this.inputOI = (MapObjectInspector)parameters[0];
            if (this.inputOI.getMapKeyObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new HiveException("Vector map keys must be a primitive.");
            }
            if (this.inputOI.getMapValueObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE || !NumericUtil.isNumericCategory(((PrimitiveObjectInspector)this.inputOI.getMapValueObjectInspector()).getPrimitiveCategory())) {
                throw new HiveException("Vector values must be numeric.");
            }
            this.stdMapOI = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputOI.getMapKeyObjectInspector(), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA), (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector);
            return this.stdMapOI;
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            VectorMapAggBuffer buff = new VectorMapAggBuffer();
            this.reset(buff);
            return buff;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object p = parameters[0];
            if (p != null) {
                VectorMapAggBuffer myagg = (VectorMapAggBuffer)agg;
                this.addVectorMap(p, myagg, this.inputOI);
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            VectorMapAggBuffer myagg = (VectorMapAggBuffer)agg;
            this.addVectorMap(partial, myagg, this.inputOI);
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            VectorMapAggBuffer arrayBuff = (VectorMapAggBuffer)buff;
            arrayBuff.sumMap = new HashMap<Object, Double>();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            VectorMapAggBuffer myagg = (VectorMapAggBuffer)agg;
            return myagg.sumMap;
        }

        private void addVectorMap(Object mapObj, VectorMapAggBuffer myagg, MapObjectInspector inputOI) {
            Map uninspMap = inputOI.getMap(mapObj);
            for (Object uninspKey : uninspMap.keySet()) {
                Object stdKey = ObjectInspectorUtils.copyToStandardJavaObject(uninspKey, (ObjectInspector)inputOI.getMapKeyObjectInspector());
                double stdVal = NumericUtil.getNumericValue((PrimitiveObjectInspector)inputOI.getMapValueObjectInspector(), uninspMap.get(uninspKey));
                if (myagg.sumMap.containsKey(stdKey)) {
                    double prevVal = myagg.sumMap.get(stdKey);
                    myagg.sumMap.put(stdKey, prevVal + stdVal);
                    continue;
                }
                myagg.sumMap.put(stdKey, stdVal);
            }
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            VectorMapAggBuffer myagg = (VectorMapAggBuffer)agg;
            return myagg.sumMap;
        }

        static class VectorMapAggBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            Map<Object, Double> sumMap = new HashMap<Object, Double>();

            VectorMapAggBuffer() {
            }
        }
    }

    public static class VectorArraySumUDAFEvaluator
    extends GenericUDAFEvaluator {
        private ListObjectInspector inputOI;
        private StandardListObjectInspector stdListOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            this.inputOI = (ListObjectInspector)parameters[0];
            if (this.inputOI.getListElementObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE || !NumericUtil.isNumericCategory(((PrimitiveObjectInspector)this.inputOI.getListElementObjectInspector()).getPrimitiveCategory())) {
                throw new HiveException("Vector values must be numeric.");
            }
            this.stdListOI = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector);
            return this.stdListOI;
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            VectorArrayAggBuffer buff = new VectorArrayAggBuffer();
            this.reset(buff);
            return buff;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object p = parameters[0];
            if (p != null) {
                VectorArrayAggBuffer myagg = (VectorArrayAggBuffer)agg;
                this.addVector(p, myagg, this.inputOI);
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            VectorArrayAggBuffer myagg = (VectorArrayAggBuffer)agg;
            this.addVector(partial, myagg, this.inputOI);
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            VectorArrayAggBuffer arrayBuff = (VectorArrayAggBuffer)buff;
            arrayBuff.sumArray = new ArrayList();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            VectorArrayAggBuffer myagg = (VectorArrayAggBuffer)agg;
            return myagg.sumArray;
        }

        private void addVector(Object listObj, VectorArrayAggBuffer myagg, ListObjectInspector inputOI) {
            int listLen = inputOI.getListLength(listObj);
            if (listLen > myagg.sumArray.size()) {
                myagg.sumArray.ensureCapacity(listLen);
            }
            for (int i = 0; i < listLen; ++i) {
                Object listElem = inputOI.getListElement(listObj, i);
                double listElemDbl = NumericUtil.getNumericValue((PrimitiveObjectInspector)inputOI.getListElementObjectInspector(), listElem);
                Double oldVal = myagg.sumArray.get(i);
                if (oldVal != null) {
                    myagg.sumArray.set(i, oldVal + listElemDbl);
                    continue;
                }
                myagg.sumArray.set(i, listElemDbl);
            }
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            VectorArrayAggBuffer myagg = (VectorArrayAggBuffer)agg;
            return myagg.sumArray;
        }

        static class VectorArrayAggBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            ArrayList<Double> sumArray = new ArrayList();

            VectorArrayAggBuffer() {
            }
        }
    }
}

