/*
 * Decompiled with CFR 0.152.
 */
package com.kmpalette.palette.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.ImageBitmap;
import com.kmpalette.palette.graphics.Target;
import com.kmpalette.palette.internal.Bitmap_androidKt;
import com.kmpalette.palette.internal.ColorCutQuantizer;
import com.kmpalette.palette.internal.annotation.ColorInt;
import com.kmpalette.palette.internal.utils.ColorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0014\b\u0007\u0018\u0000 42\u00020\u0001:\u00043456B#\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0006H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u0006H\u0002J\u001a\u0010'\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u00062\b\b\u0001\u0010(\u001a\u00020\u001bH\u0007J\u0012\u0010)\u001a\u00020\u001b2\b\b\u0001\u0010(\u001a\u00020\u001bH\u0007J\u0012\u0010*\u001a\u00020\u001b2\b\b\u0001\u0010(\u001a\u00020\u001bH\u0007J\u0012\u0010+\u001a\u00020\u001b2\b\b\u0001\u0010(\u001a\u00020\u001bH\u0007J\u0012\u0010,\u001a\u00020\u001b2\b\b\u0001\u0010(\u001a\u00020\u001bH\u0007J\u0012\u0010-\u001a\u00020\u001b2\b\b\u0001\u0010(\u001a\u00020\u001bH\u0007J\u0012\u0010.\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u0006H\u0002J\u0012\u0010/\u001a\u00020\u001b2\b\b\u0001\u0010(\u001a\u00020\u001bH\u0007J\u0010\u00100\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u0006J\u0012\u00101\u001a\u00020\u001b2\b\b\u0001\u0010(\u001a\u00020\u001bH\u0007J\u0018\u00102\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0006H\u0002R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR.\u0010\u0015\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0016j\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0004`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u0016j\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\n\u00a8\u00067"}, d2={"Lcom/kmpalette/palette/graphics/Palette;", "", "swatches", "", "Lcom/kmpalette/palette/graphics/Palette$Swatch;", "targets", "Lcom/kmpalette/palette/graphics/Target;", "(Ljava/util/List;Ljava/util/List;)V", "darkMutedSwatch", "getDarkMutedSwatch", "()Lcom/kmpalette/palette/graphics/Palette$Swatch;", "darkVibrantSwatch", "getDarkVibrantSwatch", "dominantSwatch", "getDominantSwatch", "lightMutedSwatch", "getLightMutedSwatch", "lightVibrantSwatch", "getLightVibrantSwatch", "mutedSwatch", "getMutedSwatch", "selectedSwatches", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getSwatches", "()Ljava/util/List;", "usedColors", "", "", "vibrantSwatch", "getVibrantSwatch", "findDominantSwatch", "generate", "", "generateScore", "", "swatch", "target", "generateScoredTarget", "getColorForTarget", "defaultColor", "getDarkMutedColor", "getDarkVibrantColor", "getDominantColor", "getLightMutedColor", "getLightVibrantColor", "getMaxScoredSwatchForTarget", "getMutedColor", "getSwatchForTarget", "getVibrantColor", "shouldBeScoredForTarget", "Builder", "Companion", "Filter", "Swatch", "androidx-palette_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPalette.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Palette.kt\ncom/kmpalette/palette/graphics/Palette\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,740:1\n1855#2,2:741\n1963#2,14:743\n*S KotlinDebug\n*F\n+ 1 Palette.kt\ncom/kmpalette/palette/graphics/Palette\n*L\n229#1:741,2\n299#1:743,14\n*E\n"})
public final class Palette {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Swatch> swatches;
    @NotNull
    private final List<Target> targets;
    @NotNull
    private final HashMap<Target, Swatch> selectedSwatches;
    @NotNull
    private final HashMap<Integer, Boolean> usedColors;
    @Nullable
    private final Swatch dominantSwatch;
    public static final int $stable = 8;
    public static final int DEFAULT_RESIZE_BITMAP_AREA = 12544;
    public static final int DEFAULT_CALCULATE_NUMBER_COLORS = 16;
    public static final float MIN_CONTRAST_TITLE_TEXT = 3.0f;
    public static final float MIN_CONTRAST_BODY_TEXT = 4.5f;
    @NotNull
    private static final Filter DEFAULT_FILTER = new Filter(){
        private final float BLACK_MAX_LIGHTNESS;
        private final float WHITE_MIN_LIGHTNESS;
        {
            this.BLACK_MAX_LIGHTNESS = 0.05f;
            this.WHITE_MIN_LIGHTNESS = 0.95f;
        }

        public boolean isAllowed(int rgb, @NotNull float[] hsl) {
            Intrinsics.checkNotNullParameter((Object)hsl, (String)"hsl");
            return !this.isWhite(hsl) && !this.isBlack(hsl) && !this.isNearRedILine(hsl);
        }

        private final boolean isBlack(float[] hslColor) {
            return hslColor[2] <= this.BLACK_MAX_LIGHTNESS;
        }

        private final boolean isWhite(float[] hslColor) {
            return hslColor[2] >= this.WHITE_MIN_LIGHTNESS;
        }

        private final boolean isNearRedILine(float[] hslColor) {
            float f = hslColor[0];
            return (10.0f <= f ? f <= 37.0f : false) && hslColor[1] <= 0.82f;
        }
    };

    public Palette(@NotNull List<Swatch> swatches, @NotNull List<Target> targets) {
        Intrinsics.checkNotNullParameter(swatches, (String)"swatches");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        this.swatches = swatches;
        this.targets = targets;
        this.selectedSwatches = new HashMap();
        this.usedColors = new HashMap();
        this.dominantSwatch = this.findDominantSwatch();
    }

    @NotNull
    public final List<Swatch> getSwatches() {
        return this.swatches;
    }

    @Nullable
    public final Swatch getDominantSwatch() {
        return this.dominantSwatch;
    }

    @Nullable
    public final Swatch getVibrantSwatch() {
        return this.getSwatchForTarget(Target.Companion.getVIBRANT());
    }

    @Nullable
    public final Swatch getLightVibrantSwatch() {
        return this.getSwatchForTarget(Target.Companion.getLIGHT_VIBRANT());
    }

    @Nullable
    public final Swatch getDarkVibrantSwatch() {
        return this.getSwatchForTarget(Target.Companion.getDARK_VIBRANT());
    }

    @Nullable
    public final Swatch getMutedSwatch() {
        return this.getSwatchForTarget(Target.Companion.getMUTED());
    }

    @Nullable
    public final Swatch getLightMutedSwatch() {
        return this.getSwatchForTarget(Target.Companion.getLIGHT_MUTED());
    }

    @Nullable
    public final Swatch getDarkMutedSwatch() {
        return this.getSwatchForTarget(Target.Companion.getDARK_MUTED());
    }

    @ColorInt
    public final int getVibrantColor(@ColorInt int defaultColor) {
        return this.getColorForTarget(Target.Companion.getVIBRANT(), defaultColor);
    }

    @ColorInt
    public final int getLightVibrantColor(@ColorInt int defaultColor) {
        return this.getColorForTarget(Target.Companion.getLIGHT_VIBRANT(), defaultColor);
    }

    @ColorInt
    public final int getDarkVibrantColor(@ColorInt int defaultColor) {
        return this.getColorForTarget(Target.Companion.getDARK_VIBRANT(), defaultColor);
    }

    @ColorInt
    public final int getMutedColor(@ColorInt int defaultColor) {
        return this.getColorForTarget(Target.Companion.getMUTED(), defaultColor);
    }

    @ColorInt
    public final int getLightMutedColor(@ColorInt int defaultColor) {
        return this.getColorForTarget(Target.Companion.getLIGHT_MUTED(), defaultColor);
    }

    @ColorInt
    public final int getDarkMutedColor(@ColorInt int defaultColor) {
        return this.getColorForTarget(Target.Companion.getDARK_MUTED(), defaultColor);
    }

    @Nullable
    public final Swatch getSwatchForTarget(@NotNull Target target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.selectedSwatches.get(target);
    }

    @ColorInt
    public final int getColorForTarget(@NotNull Target target, @ColorInt int defaultColor) {
        Swatch swatch;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Swatch swatch2 = swatch = this.getSwatchForTarget(target);
        return swatch2 != null ? swatch2.getRgb() : defaultColor;
    }

    @ColorInt
    public final int getDominantColor(@ColorInt int defaultColor) {
        Swatch swatch = this.dominantSwatch;
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    public final void generate() {
        Iterable $this$forEach$iv = this.targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Target target = (Target)element$iv;
            boolean bl = false;
            target.normalizeWeights();
            ((Map)this.selectedSwatches).put(target, this.generateScoredTarget(target));
        }
        this.usedColors.clear();
    }

    private final Swatch generateScoredTarget(Target target) {
        Swatch maxScoreSwatch = this.getMaxScoredSwatchForTarget(target);
        if (maxScoreSwatch != null && target.isExclusive()) {
            ((Map)this.usedColors).put(maxScoreSwatch.getRgb(), true);
        }
        return maxScoreSwatch;
    }

    private final Swatch getMaxScoredSwatchForTarget(Target target) {
        float maxScore = 0.0f;
        Swatch maxScoreSwatch = null;
        int count = this.swatches.size();
        for (int i = 0; i < count; ++i) {
            Swatch swatch = this.swatches.get(i);
            if (!this.shouldBeScoredForTarget(swatch, target)) continue;
            float score = this.generateScore(swatch, target);
            if (maxScoreSwatch != null && !(score > maxScore)) continue;
            maxScoreSwatch = swatch;
            maxScore = score;
        }
        return maxScoreSwatch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldBeScoredForTarget(Swatch swatch, Target target) {
        float[] hsl = swatch.getHsl();
        if (!(hsl[1] >= target.getMinimumSaturation())) return false;
        if (!(hsl[1] <= target.getMaximumSaturation())) return false;
        if (!(hsl[2] >= target.getMinimumLightness())) return false;
        if (!(hsl[2] <= target.getMaximumLightness())) return false;
        Boolean bl = this.usedColors.get(swatch.getRgb());
        if (bl == null) return true;
        if (bl != false) return false;
        return true;
    }

    private final float generateScore(Swatch swatch, Target target) {
        int maxPopulation;
        float[] hsl = swatch.getHsl();
        float saturationScore = 0.0f;
        float luminanceScore = 0.0f;
        float populationScore = 0.0f;
        Swatch swatch2 = this.dominantSwatch;
        int n = maxPopulation = swatch2 != null ? swatch2.getPopulation() : 1;
        if (target.getSaturationWeight() > 0.0f) {
            saturationScore = target.getSaturationWeight() * (1.0f - Math.abs(hsl[1] - target.getTargetSaturation()));
        }
        if (target.getLightnessWeight() > 0.0f) {
            luminanceScore = target.getLightnessWeight() * (1.0f - Math.abs(hsl[2] - target.getTargetLightness()));
        }
        if (target.getPopulationWeight() > 0.0f) {
            populationScore = target.getPopulationWeight() * ((float)swatch.getPopulation() / (float)maxPopulation);
        }
        return saturationScore + luminanceScore + populationScore;
    }

    private final Swatch findDominantSwatch() {
        Object v0;
        Iterable $this$maxByOrNull$iv = this.swatches;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Swatch it = (Swatch)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getPopulation();
                do {
                    Object e$iv = iterator$iv.next();
                    Swatch it2 = (Swatch)e$iv;
                    $i$a$-maxByOrNull-Palette$findDominantSwatch$1 = false;
                    int v$iv = it2.getPopulation();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0014J\u0006\u0010\u0019\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0000J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u000eJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u000eJ\u0010\u0010$\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J&\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000eR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/kmpalette/palette/graphics/Palette$Builder;", "", "bitmap", "Landroidx/compose/ui/graphics/ImageBitmap;", "(Landroidx/compose/ui/graphics/ImageBitmap;)V", "swatches", "", "Lcom/kmpalette/palette/graphics/Palette$Swatch;", "(Ljava/util/List;)V", "filters", "", "Lcom/kmpalette/palette/graphics/Palette$Filter;", "imageBitmap", "maxColors", "", "region", "Landroidx/compose/ui/geometry/Rect;", "resizeArea", "resizeMaxDimension", "targets", "Lcom/kmpalette/palette/graphics/Target;", "addFilter", "filter", "addTarget", "target", "clearFilters", "clearRegion", "clearTargets", "generate", "Lcom/kmpalette/palette/graphics/Palette;", "getPixelsFromBitmap", "", "maximumColorCount", "colors", "resizeBitmapArea", "area", "scaleBitmapDown", "setRegion", "left", "top", "right", "bottom", "androidx-palette_release"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nPalette.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Palette.kt\ncom/kmpalette/palette/graphics/Palette$Builder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,740:1\n37#2,2:741\n*S KotlinDebug\n*F\n+ 1 Palette.kt\ncom/kmpalette/palette/graphics/Palette$Builder\n*L\n585#1:741,2\n*E\n"})
    public static final class Builder {
        @Nullable
        private final List<Swatch> swatches;
        @Nullable
        private final ImageBitmap imageBitmap;
        @NotNull
        private final List<Target> targets;
        private int maxColors;
        private int resizeArea;
        private int resizeMaxDimension;
        @NotNull
        private final List<Filter> filters;
        @Nullable
        private Rect region;
        public static final int $stable = 8;

        public Builder(@NotNull ImageBitmap bitmap) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            this.targets = new ArrayList();
            this.maxColors = 16;
            this.resizeArea = 12544;
            this.resizeMaxDimension = -1;
            this.filters = new ArrayList();
            this.filters.add(Companion.getDEFAULT_FILTER());
            this.imageBitmap = bitmap;
            this.swatches = null;
            this.targets.add(Target.Companion.getLIGHT_VIBRANT());
            this.targets.add(Target.Companion.getVIBRANT());
            this.targets.add(Target.Companion.getDARK_VIBRANT());
            this.targets.add(Target.Companion.getLIGHT_MUTED());
            this.targets.add(Target.Companion.getMUTED());
            this.targets.add(Target.Companion.getDARK_MUTED());
        }

        public Builder(@NotNull List<Swatch> swatches) {
            Intrinsics.checkNotNullParameter(swatches, (String)"swatches");
            this.targets = new ArrayList();
            this.maxColors = 16;
            this.resizeArea = 12544;
            this.resizeMaxDimension = -1;
            this.filters = new ArrayList();
            if (swatches.isEmpty()) {
                throw new IllegalArgumentException("List of Swatches is not valid");
            }
            this.filters.add(Companion.getDEFAULT_FILTER());
            this.swatches = swatches;
            this.imageBitmap = null;
        }

        @NotNull
        public final Builder maximumColorCount(int colors) {
            this.maxColors = colors;
            return this;
        }

        @NotNull
        public final Builder resizeBitmapArea(int area) {
            this.resizeArea = area;
            this.resizeMaxDimension = -1;
            return this;
        }

        @NotNull
        public final Builder clearFilters() {
            this.filters.clear();
            return this;
        }

        @NotNull
        public final Builder addFilter(@NotNull Filter filter) {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            this.filters.add(filter);
            return this;
        }

        @NotNull
        public final Builder setRegion(int left, int top, int right, int bottom) {
            ImageBitmap bitmap = this.imageBitmap;
            if (bitmap != null) {
                if (this.region == null) {
                    this.region = new Rect(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
                }
                Rect other = new Rect((float)left, (float)top, (float)right, (float)bottom);
                Rect rect = this.region;
                Intrinsics.checkNotNull((Object)rect);
                if (!rect.overlaps(other)) {
                    throw new IllegalArgumentException("The given region must intersect with the Bitmap's dimensions.");
                }
            }
            return this;
        }

        @NotNull
        public final Builder clearRegion() {
            this.region = null;
            return this;
        }

        @NotNull
        public final Builder addTarget(@NotNull Target target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (!this.targets.contains(target)) {
                this.targets.add(target);
            }
            return this;
        }

        @NotNull
        public final Builder clearTargets() {
            this.targets.clear();
            return this;
        }

        @NotNull
        public final Palette generate() {
            List<Swatch> swatches = null;
            if (this.imageBitmap != null) {
                Filter[] filterArray;
                ImageBitmap bitmap = this.scaleBitmapDown(this.imageBitmap);
                Rect region = this.region;
                if (!Intrinsics.areEqual((Object)bitmap, (Object)this.imageBitmap) && region != null) {
                    float scale = (float)bitmap.getWidth() / (float)this.imageBitmap.getWidth();
                    this.region = region.copy((float)Math.floor(region.getLeft() * scale), (float)Math.floor(region.getTop() * scale), Math.min((float)Math.ceil(region.getRight() * scale), (float)bitmap.getWidth()), Math.min((float)Math.ceil(region.getBottom() * scale), (float)bitmap.getHeight()));
                }
                int[] nArray = this.getPixelsFromBitmap(bitmap);
                if (this.filters.isEmpty()) {
                    filterArray = null;
                } else {
                    Collection $this$toTypedArray$iv = this.filters;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    filterArray = thisCollection$iv.toArray(new Filter[0]);
                }
                ColorCutQuantizer quantizer = new ColorCutQuantizer(nArray, this.maxColors, filterArray);
                swatches = quantizer.getQuantizedColors();
            } else if (this.swatches != null) {
                swatches = this.swatches;
            } else {
                throw new AssertionError();
            }
            Palette p = new Palette(swatches, this.targets);
            p.generate();
            return p;
        }

        private final int[] getPixelsFromBitmap(ImageBitmap bitmap) {
            int[] nArray;
            int bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            int[] pixels = new int[bitmapWidth * bitmapHeight];
            ImageBitmap.readPixels$default((ImageBitmap)bitmap, (int[])pixels, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)120, null);
            Rect region = this.region;
            if (region == null) {
                nArray = pixels;
            } else {
                float regionWidth = region.getWidth();
                float regionHeight = region.getHeight();
                int[] subsetPixels = new int[(int)(regionWidth * regionHeight)];
                int n = (int)regionHeight;
                for (int row = 0; row < n; ++row) {
                    ArraysKt.copyInto((int[])pixels, (int[])subsetPixels, (int)((int)((float)row * regionWidth)), (int)((int)(((float)row + region.getTop()) * (float)bitmapWidth + region.getLeft())), (int)((int)(((float)row + region.getTop()) * (float)bitmapWidth + region.getLeft() + regionWidth)));
                }
                nArray = subsetPixels;
            }
            return nArray;
        }

        private final ImageBitmap scaleBitmapDown(ImageBitmap bitmap) {
            int maxDimension;
            double scaleRatio = -1.0;
            if (this.resizeArea > 0) {
                int bitmapArea = bitmap.getWidth() * bitmap.getHeight();
                if (bitmapArea > this.resizeArea) {
                    scaleRatio = Math.sqrt((double)this.resizeArea / (double)bitmapArea);
                }
            } else if (this.resizeMaxDimension > 0 && (maxDimension = Math.max(bitmap.getWidth(), bitmap.getHeight())) > this.resizeMaxDimension) {
                scaleRatio = (double)this.resizeMaxDimension / (double)maxDimension;
            }
            return scaleRatio <= 0.0 ? bitmap : Bitmap_androidKt.scale(bitmap, (int)Math.ceil((double)bitmap.getWidth() * scaleRatio), (int)Math.ceil((double)bitmap.getHeight() * scaleRatio));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\r\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/kmpalette/palette/graphics/Palette$Companion;", "", "()V", "DEFAULT_CALCULATE_NUMBER_COLORS", "", "DEFAULT_FILTER", "Lcom/kmpalette/palette/graphics/Palette$Filter;", "getDEFAULT_FILTER", "()Lcom/kmpalette/palette/graphics/Palette$Filter;", "DEFAULT_RESIZE_BITMAP_AREA", "MIN_CONTRAST_BODY_TEXT", "", "MIN_CONTRAST_TITLE_TEXT", "from", "Lcom/kmpalette/palette/graphics/Palette$Builder;", "bitmap", "Landroidx/compose/ui/graphics/ImageBitmap;", "Lcom/kmpalette/palette/graphics/Palette;", "swatches", "", "Lcom/kmpalette/palette/graphics/Palette$Swatch;", "androidx-palette_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Builder from(@NotNull ImageBitmap bitmap) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            return new Builder(bitmap);
        }

        @NotNull
        public final Palette from(@NotNull List<Swatch> swatches) {
            Intrinsics.checkNotNullParameter(swatches, (String)"swatches");
            return new Builder(swatches).generate();
        }

        @NotNull
        public final Filter getDEFAULT_FILTER() {
            return DEFAULT_FILTER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/kmpalette/palette/graphics/Palette$Filter;", "", "isAllowed", "", "rgb", "", "hsl", "", "androidx-palette_release"})
    public static interface Filter {
        public boolean isAllowed(int var1, @NotNull float[] var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bR\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0017\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/kmpalette/palette/graphics/Palette$Swatch;", "", "rgb", "", "population", "(II)V", "_bodyTextColor", "_titleTextColor", "blue", "bodyTextColor", "getBodyTextColor", "()I", "generatedTextColors", "", "green", "<set-?>", "", "hsl", "getHsl", "()[F", "getPopulation", "red", "getRgb", "titleTextColor", "getTitleTextColor", "ensureTextColorsGenerated", "", "androidx-palette_release"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nPalette.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Palette.kt\ncom/kmpalette/palette/graphics/Palette$Swatch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,740:1\n1#2:741\n*E\n"})
    public static final class Swatch {
        private final int rgb;
        private final int population;
        private final int red;
        private final int green;
        private final int blue;
        private boolean generatedTextColors;
        private int _titleTextColor;
        private int _bodyTextColor;
        @NotNull
        private float[] hsl;
        public static final int $stable = 8;

        /*
         * WARNING - void declaration
         */
        public Swatch(int rgb, int population) {
            void $this$hsl_u24lambda_u240;
            float[] fArray;
            this.rgb = rgb;
            this.population = population;
            this.red = ColorUtils.INSTANCE.red(this.rgb);
            this.green = ColorUtils.INSTANCE.green(this.rgb);
            this.blue = ColorUtils.INSTANCE.blue(this.rgb);
            float[] fArray2 = fArray = new float[3];
            Swatch swatch = this;
            boolean bl = false;
            ColorUtils.INSTANCE.convertRGBToHSL(this.red, this.green, this.blue, (float[])$this$hsl_u24lambda_u240);
            swatch.hsl = fArray;
        }

        @ColorInt
        public final int getRgb() {
            return this.rgb;
        }

        public final int getPopulation() {
            return this.population;
        }

        @NotNull
        public final float[] getHsl() {
            return this.hsl;
        }

        @ColorInt
        public final int getTitleTextColor() {
            this.ensureTextColorsGenerated();
            return this._titleTextColor;
        }

        @ColorInt
        public final int getBodyTextColor() {
            this.ensureTextColorsGenerated();
            return this._bodyTextColor;
        }

        private final void ensureTextColorsGenerated() {
            if (!this.generatedTextColors) {
                int lightBodyAlpha = ColorUtils.INSTANCE.calculateMinimumAlpha(ColorUtils.INSTANCE.getWHITE(), this.rgb, 4.5f);
                int lightTitleAlpha = ColorUtils.INSTANCE.calculateMinimumAlpha(ColorUtils.INSTANCE.getWHITE(), this.rgb, 3.0f);
                if (lightBodyAlpha != -1 && lightTitleAlpha != -1) {
                    this._bodyTextColor = ColorUtils.INSTANCE.setAlpha(ColorUtils.INSTANCE.getWHITE(), lightBodyAlpha);
                    this._titleTextColor = ColorUtils.INSTANCE.setAlpha(ColorUtils.INSTANCE.getWHITE(), lightTitleAlpha);
                    this.generatedTextColors = true;
                    return;
                }
                int darkBodyAlpha = ColorUtils.INSTANCE.calculateMinimumAlpha(ColorUtils.INSTANCE.getBLACK(), this.rgb, 4.5f);
                int darkTitleAlpha = ColorUtils.INSTANCE.calculateMinimumAlpha(ColorUtils.INSTANCE.getBLACK(), this.rgb, 3.0f);
                if (darkBodyAlpha != -1 && darkTitleAlpha != -1) {
                    this._bodyTextColor = ColorUtils.INSTANCE.setAlpha(ColorUtils.INSTANCE.getBLACK(), darkBodyAlpha);
                    this._titleTextColor = ColorUtils.INSTANCE.setAlpha(ColorUtils.INSTANCE.getBLACK(), darkTitleAlpha);
                    this.generatedTextColors = true;
                    return;
                }
                this._bodyTextColor = lightBodyAlpha != -1 ? ColorUtils.INSTANCE.setAlpha(ColorUtils.INSTANCE.getWHITE(), lightBodyAlpha) : ColorUtils.INSTANCE.setAlpha(ColorUtils.INSTANCE.getBLACK(), darkBodyAlpha);
                this._titleTextColor = lightTitleAlpha != -1 ? ColorUtils.INSTANCE.setAlpha(ColorUtils.INSTANCE.getWHITE(), lightTitleAlpha) : ColorUtils.INSTANCE.setAlpha(ColorUtils.INSTANCE.getBLACK(), darkTitleAlpha);
                this.generatedTextColors = true;
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Swatch)) {
                return false;
            }
            Swatch swatch = (Swatch)other;
            if (this.rgb != swatch.rgb) {
                return false;
            }
            return this.population == swatch.population;
        }

        public int hashCode() {
            int result = this.rgb;
            result = result * 31 + this.population;
            return result;
        }

        @NotNull
        public String toString() {
            return "Swatch(rgb=" + this.rgb + ", population=" + this.population + ")";
        }
    }
}

