/*
 * Decompiled with CFR 0.152.
 */
package com.kmpalette.palette.internal.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import com.kmpalette.palette.internal.annotation.ColorInt;
import com.kmpalette.palette.internal.annotation.FloatRange;
import com.kmpalette.palette.internal.annotation.IntRange;
import com.kmpalette.palette.internal.utils.ColorUtilsKt;
import com.kmpalette.palette.internal.utils.PowKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.HexExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0012\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u0004J(\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u0004J\u001c\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00042\b\b\u0001\u0010\u0014\u001a\u00020\u0004H\u0002J\u0012\u0010\u0015\u001a\u00020\u00122\b\b\u0001\u0010\f\u001a\u00020\u0004H\u0007J\"\u0010\u0016\u001a\u00020\u00042\b\b\u0001\u0010\u0013\u001a\u00020\u00042\b\b\u0001\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\f\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010\u001d\u001a\u00020\u001a2\b\b\u0001\u0010\f\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u001c\u0010#\u001a\u00020\u00042\b\b\u0001\u0010\u0013\u001a\u00020\u00042\b\b\u0001\u0010\u0014\u001a\u00020\u0004H\u0002J0\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0002J&\u0010*\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ.\u0010+\u001a\u00020\u001a2\b\b\u0001\u0010,\u001a\u00020\u00042\b\b\u0001\u0010-\u001a\u00020\u00042\b\b\u0001\u0010.\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u0004J\u0010\u0010\u000e\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u0004J \u0010/\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u001c\u00100\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\u0004H\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u00061"}, d2={"Lcom/kmpalette/palette/internal/utils/ColorUtils;", "", "()V", "BLACK", "", "getBLACK", "()I", "MIN_ALPHA_SEARCH_MAX_ITERATIONS", "MIN_ALPHA_SEARCH_PRECISION", "WHITE", "getWHITE", "alpha", "color", "argb", "red", "green", "blue", "calculateContrast", "", "foreground", "background", "calculateLuminance", "calculateMinimumAlpha", "minContrastRatio", "", "colorToHSL", "", "outHsl", "", "colorToXYZ", "outXyz", "", "compositeAlpha", "foregroundAlpha", "backgroundAlpha", "compositeColors", "compositeComponent", "fgC", "fgA", "bgC", "bgA", "a", "convertRGBToHSL", "convertRGBToXYZ", "r", "g", "b", "rgb", "setAlpha", "androidx-palette_release"})
@StabilityInferred(parameters=1)
public final class ColorUtils {
    @NotNull
    public static final ColorUtils INSTANCE = new ColorUtils();
    private static final int MIN_ALPHA_SEARCH_MAX_ITERATIONS = 10;
    private static final int MIN_ALPHA_SEARCH_PRECISION = 1;
    @ColorInt
    private static final int BLACK = -16777216;
    @ColorInt
    private static final int WHITE = -1;
    public static final int $stable;

    private ColorUtils() {
    }

    public final int getBLACK() {
        return BLACK;
    }

    public final int getWHITE() {
        return WHITE;
    }

    public final void convertRGBToHSL(int red, int green, int blue, @NotNull float[] outHsl) {
        Intrinsics.checkNotNullParameter((Object)outHsl, (String)"outHsl");
        float rf = (float)red / 255.0f;
        float gf = (float)green / 255.0f;
        float bf = (float)blue / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float deltaMaxMin = max - min;
        float hue = 0.0f;
        float saturation = 0.0f;
        float lightness = (max + min) / 2.0f;
        if (max == min) {
            hue = saturation = 0.0f;
        } else {
            float f = max;
            hue = f == rf ? (gf - bf) / deltaMaxMin % 6.0f : (f == gf ? (bf - rf) / deltaMaxMin + 2.0f : (rf - gf) / deltaMaxMin + 4.0f);
            saturation = deltaMaxMin / (1.0f - Math.abs(2.0f * lightness - 1.0f));
        }
        hue = hue * 60.0f % 360.0f;
        if (hue < 0.0f) {
            hue += 360.0f;
        }
        outHsl[0] = RangesKt.coerceIn((float)hue, (float)0.0f, (float)360.0f);
        outHsl[1] = RangesKt.coerceIn((float)saturation, (float)0.0f, (float)1.0f);
        outHsl[2] = RangesKt.coerceIn((float)lightness, (float)0.0f, (float)1.0f);
    }

    @ColorInt
    public final int setAlpha(@ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("alpha must be between 0 and 255.");
        }
        return color & 0xFFFFFF | alpha << 24;
    }

    @FloatRange(from=0.0, to=1.0)
    public final double calculateLuminance(@ColorInt int color) {
        double[] result = ColorUtilsKt.access$getTEMP_ARRAY$p();
        this.colorToXYZ(color, result);
        return result[1] / (double)100;
    }

    private final int compositeColors(@ColorInt int foreground, @ColorInt int background) {
        int bgAlpha = this.alpha(background);
        int fgAlpha = this.alpha(foreground);
        int a = this.compositeAlpha(fgAlpha, bgAlpha);
        int r = this.compositeComponent(this.red(foreground), fgAlpha, this.red(background), bgAlpha, a);
        int g = this.compositeComponent(this.green(foreground), fgAlpha, this.green(background), bgAlpha, a);
        int b = this.compositeComponent(this.blue(foreground), fgAlpha, this.blue(background), bgAlpha, a);
        return this.argb(a, r, g, b);
    }

    private final int compositeAlpha(int foregroundAlpha, int backgroundAlpha) {
        return 255 - (255 - backgroundAlpha) * (255 - foregroundAlpha) / 255;
    }

    private final int compositeComponent(int fgC, int fgA, int bgC, int bgA, int a) {
        return a == 0 ? 0 : (255 * fgC * fgA + bgC * bgA * (255 - fgA)) / (a * 255);
    }

    private final void convertRGBToXYZ(@IntRange(from=0L, to=255L) int r, @IntRange(from=0L, to=255L) int g, @IntRange(from=0L, to=255L) int b, double[] outXyz) {
        if (outXyz.length != 3) {
            throw new IllegalArgumentException("outXyz must have a length of 3.");
        }
        double sr = (double)r / 255.0;
        sr = sr < 0.04045 ? sr / 12.92 : PowKt.pow((sr + 0.055) / 1.055, 2.4);
        double sg = (double)g / 255.0;
        sg = sg < 0.04045 ? sg / 12.92 : PowKt.pow((sg + 0.055) / 1.055, 2.4);
        double sb = (double)b / 255.0;
        sb = sb < 0.04045 ? sb / 12.92 : PowKt.pow((sb + 0.055) / 1.055, 2.4);
        outXyz[0] = (double)100 * (sr * 0.4124 + sg * 0.3576 + sb * 0.1805);
        outXyz[1] = (double)100 * (sr * 0.2126 + sg * 0.7152 + sb * 0.0722);
        outXyz[2] = (double)100 * (sr * 0.0193 + sg * 0.1192 + sb * 0.9505);
    }

    private final void colorToXYZ(@ColorInt int color, double[] outXyz) {
        this.convertRGBToXYZ(this.red(color), this.green(color), this.blue(color), outXyz);
    }

    private final double calculateContrast(@ColorInt int foreground, @ColorInt int background) {
        int modifiedForeground = this.alpha(foreground) >= 255 ? foreground : this.compositeColors(foreground, background);
        double luminance1 = this.calculateLuminance(modifiedForeground) + 0.05;
        double luminance2 = this.calculateLuminance(background) + 0.05;
        return Math.max(luminance1, luminance2) / Math.min(luminance1, luminance2);
    }

    public final int calculateMinimumAlpha(@ColorInt int foreground, @ColorInt int background, float minContrastRatio) {
        if (this.alpha(background) != 255) {
            throw new IllegalArgumentException("background can not be translucent: #" + HexExtensionsKt.toHexString$default((int)background, null, (int)1, null));
        }
        int testForeground = this.setAlpha(foreground, 255);
        double testRatio = this.calculateContrast(testForeground, background);
        if (testRatio < (double)minContrastRatio) {
            return -1;
        }
        int minAlpha = 0;
        int maxAlpha = 255;
        for (int numIterations = 0; numIterations <= 10 && maxAlpha - minAlpha > 1; ++numIterations) {
            int testAlpha = (minAlpha + maxAlpha) / 2;
            testForeground = this.setAlpha(foreground, testAlpha);
            testRatio = this.calculateContrast(testForeground, background);
            if (testRatio < (double)minContrastRatio) {
                minAlpha = testAlpha;
                continue;
            }
            maxAlpha = testAlpha;
        }
        return maxAlpha;
    }

    public final void colorToHSL(@ColorInt int color, @NotNull float[] outHsl) {
        Intrinsics.checkNotNullParameter((Object)outHsl, (String)"outHsl");
        this.convertRGBToHSL(this.red(color), this.green(color), this.blue(color), outHsl);
    }

    public final int alpha(@ColorInt int color) {
        return color >>> 24;
    }

    public final int red(@ColorInt int color) {
        return color >> 16 & 0xFF;
    }

    public final int green(@ColorInt int color) {
        return color >> 8 & 0xFF;
    }

    public final int blue(@ColorInt int color) {
        return color & 0xFF;
    }

    @ColorInt
    public final int argb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    @ColorInt
    public final int rgb(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }
}

