/*
 * Decompiled with CFR 0.152.
 */
package com.kmpalette.palette.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 *2\u00020\u0001:\u0002)*B\u0007\b\u0010\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020'H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u001a\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u001c\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\rR\u0011\u0010\u001e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011R\u0011\u0010 \u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0011R\u0011\u0010\"\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0011R\u0011\u0010$\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\r\u00a8\u0006+"}, d2={"Lcom/kmpalette/palette/graphics/Target;", "", "()V", "from", "(Lcom/kmpalette/palette/graphics/Target;)V", "isExclusive", "", "()Z", "setExclusive", "(Z)V", "lightnessTargets", "", "getLightnessTargets", "()[F", "lightnessWeight", "", "getLightnessWeight", "()F", "maximumLightness", "getMaximumLightness", "maximumSaturation", "getMaximumSaturation", "minimumLightness", "getMinimumLightness", "minimumSaturation", "getMinimumSaturation", "populationWeight", "getPopulationWeight", "saturationTargets", "getSaturationTargets", "saturationWeight", "getSaturationWeight", "targetLightness", "getTargetLightness", "targetSaturation", "getTargetSaturation", "weights", "getWeights", "normalizeWeights", "", "setDefaultWeights", "Builder", "Companion", "androidx-palette"})
@StabilityInferred(parameters=0)
public final class Target {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final float[] saturationTargets;
    @NotNull
    private final float[] lightnessTargets;
    @NotNull
    private final float[] weights;
    private boolean isExclusive;
    public static final int $stable;
    private static final float TARGET_DARK_LUMA = 0.26f;
    private static final float MAX_DARK_LUMA = 0.45f;
    private static final float MIN_LIGHT_LUMA = 0.55f;
    private static final float TARGET_LIGHT_LUMA = 0.74f;
    private static final float MIN_NORMAL_LUMA = 0.3f;
    private static final float TARGET_NORMAL_LUMA = 0.5f;
    private static final float MAX_NORMAL_LUMA = 0.7f;
    private static final float TARGET_MUTED_SATURATION = 0.3f;
    private static final float MAX_MUTED_SATURATION = 0.4f;
    private static final float TARGET_VIBRANT_SATURATION = 1.0f;
    private static final float MIN_VIBRANT_SATURATION = 0.35f;
    private static final float WEIGHT_SATURATION = 0.24f;
    private static final float WEIGHT_LUMA = 0.52f;
    private static final float WEIGHT_POPULATION = 0.24f;
    public static final int INDEX_MIN = 0;
    public static final int INDEX_TARGET = 1;
    public static final int INDEX_MAX = 2;
    public static final int INDEX_WEIGHT_SAT = 0;
    public static final int INDEX_WEIGHT_LUMA = 1;
    public static final int INDEX_WEIGHT_POP = 2;
    @NotNull
    private static final Target LIGHT_VIBRANT;
    @NotNull
    private static final Target VIBRANT;
    @NotNull
    private static final Target DARK_VIBRANT;
    @NotNull
    private static final Target LIGHT_MUTED;
    @NotNull
    private static final Target MUTED;
    @NotNull
    private static final Target DARK_MUTED;

    @NotNull
    public final float[] getSaturationTargets() {
        return this.saturationTargets;
    }

    @NotNull
    public final float[] getLightnessTargets() {
        return this.lightnessTargets;
    }

    @NotNull
    public final float[] getWeights() {
        return this.weights;
    }

    public final boolean isExclusive() {
        return this.isExclusive;
    }

    public final void setExclusive(boolean bl) {
        this.isExclusive = bl;
    }

    public Target() {
        this.saturationTargets = new float[3];
        this.lightnessTargets = new float[3];
        this.weights = new float[3];
        this.isExclusive = true;
        Target.Companion.setTargetDefaultValues(this.saturationTargets);
        Target.Companion.setTargetDefaultValues(this.lightnessTargets);
        this.setDefaultWeights();
    }

    public Target(@NotNull Target from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        this.saturationTargets = new float[3];
        this.lightnessTargets = new float[3];
        this.weights = new float[3];
        this.isExclusive = true;
        ArraysKt.copyInto$default((float[])from.saturationTargets, (float[])this.saturationTargets, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.copyInto$default((float[])from.lightnessTargets, (float[])this.lightnessTargets, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.copyInto$default((float[])from.weights, (float[])this.weights, (int)0, (int)0, (int)0, (int)14, null);
    }

    public final float getMinimumSaturation() {
        return this.saturationTargets[0];
    }

    public final float getTargetSaturation() {
        return this.saturationTargets[1];
    }

    public final float getMaximumSaturation() {
        return this.saturationTargets[2];
    }

    public final float getMinimumLightness() {
        return this.lightnessTargets[0];
    }

    public final float getTargetLightness() {
        return this.lightnessTargets[1];
    }

    public final float getMaximumLightness() {
        return this.lightnessTargets[2];
    }

    public final float getSaturationWeight() {
        return this.weights[0];
    }

    public final float getLightnessWeight() {
        return this.weights[1];
    }

    public final float getPopulationWeight() {
        return this.weights[2];
    }

    private final void setDefaultWeights() {
        this.weights[0] = 0.24f;
        this.weights[1] = 0.52f;
        this.weights[2] = 0.24f;
    }

    public final void normalizeWeights() {
        int index;
        float sum = 0.0f;
        int z = this.weights.length;
        for (index = 0; index < z; ++index) {
            float weight = this.weights[index];
            if (!(weight > 0.0f)) continue;
            sum += weight;
        }
        if (!(sum == 0.0f)) {
            for (index = 0; index < z; ++index) {
                if (!(this.weights[index] > 0.0f)) continue;
                float[] fArray = this.weights;
                int n = index;
                fArray[n] = fArray[n] / sum;
            }
        }
    }

    static {
        Target target;
        Companion = new Companion(null);
        $stable = 8;
        Target $this$LIGHT_VIBRANT_u24lambda_u240 = target = new Target();
        boolean bl = false;
        Target.Companion.setDefaultLightLightnessValues($this$LIGHT_VIBRANT_u24lambda_u240);
        Target.Companion.setDefaultVibrantSaturationValues($this$LIGHT_VIBRANT_u24lambda_u240);
        LIGHT_VIBRANT = target;
        Target $this$VIBRANT_u24lambda_u241 = target = new Target();
        boolean bl2 = false;
        Target.Companion.setDefaultNormalLightnessValues($this$VIBRANT_u24lambda_u241);
        Target.Companion.setDefaultVibrantSaturationValues($this$VIBRANT_u24lambda_u241);
        VIBRANT = target;
        Target $this$DARK_VIBRANT_u24lambda_u242 = target = new Target();
        boolean bl3 = false;
        Target.Companion.setDefaultDarkLightnessValues($this$DARK_VIBRANT_u24lambda_u242);
        Target.Companion.setDefaultVibrantSaturationValues($this$DARK_VIBRANT_u24lambda_u242);
        DARK_VIBRANT = target;
        Target $this$LIGHT_MUTED_u24lambda_u243 = target = new Target();
        boolean bl4 = false;
        Target.Companion.setDefaultLightLightnessValues($this$LIGHT_MUTED_u24lambda_u243);
        Target.Companion.setDefaultMutedSaturationValues($this$LIGHT_MUTED_u24lambda_u243);
        LIGHT_MUTED = target;
        Target $this$MUTED_u24lambda_u244 = target = new Target();
        boolean bl5 = false;
        Target.Companion.setDefaultNormalLightnessValues($this$MUTED_u24lambda_u244);
        Target.Companion.setDefaultMutedSaturationValues($this$MUTED_u24lambda_u244);
        MUTED = target;
        Target $this$DARK_MUTED_u24lambda_u245 = target = new Target();
        boolean bl6 = false;
        Target.Companion.setDefaultDarkLightnessValues($this$DARK_MUTED_u24lambda_u245);
        Target.Companion.setDefaultMutedSaturationValues($this$DARK_MUTED_u24lambda_u245);
        DARK_MUTED = target;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0003J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/kmpalette/palette/graphics/Target$Builder;", "", "target", "Lcom/kmpalette/palette/graphics/Target;", "(Lcom/kmpalette/palette/graphics/Target;)V", "build", "setExclusive", "exclusive", "", "setLightnessWeight", "weight", "", "setMaximumLightness", "value", "setMaximumSaturation", "setMinimumLightness", "setMinimumSaturation", "setPopulationWeight", "setSaturationWeight", "setTargetLightness", "setTargetSaturation", "androidx-palette"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Target.kt\ncom/kmpalette/palette/graphics/Target$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,408:1\n1#2:409\n*E\n"})
    public static final class Builder {
        @NotNull
        private final Target target;
        public static final int $stable = 8;

        public Builder(@NotNull Target target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.target = target;
        }

        public /* synthetic */ Builder(Target target, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                target = new Target();
            }
            this(target);
        }

        @NotNull
        public final Builder setMinimumSaturation(float value) {
            Builder builder;
            Builder $this$setMinimumSaturation_u24lambda_u241 = builder = this;
            boolean bl = false;
            double d = value;
            if (!(0.0 <= d ? d <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "Minimum saturation value must be between 0..1";
                throw new IllegalArgumentException(string.toString());
            }
            $this$setMinimumSaturation_u24lambda_u241.target.getSaturationTargets()[0] = value;
            return builder;
        }

        @NotNull
        public final Builder setTargetSaturation(float value) {
            Builder builder;
            Builder $this$setTargetSaturation_u24lambda_u243 = builder = this;
            boolean bl = false;
            double d = value;
            if (!(0.0 <= d ? d <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "Maximum saturation value must be between 0..1";
                throw new IllegalArgumentException(string.toString());
            }
            $this$setTargetSaturation_u24lambda_u243.target.getSaturationTargets()[1] = value;
            return builder;
        }

        @NotNull
        public final Builder setMaximumSaturation(float value) {
            Builder builder;
            Builder $this$setMaximumSaturation_u24lambda_u245 = builder = this;
            boolean bl = false;
            double d = value;
            if (!(0.0 <= d ? d <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "Saturation value must be between 0..1";
                throw new IllegalArgumentException(string.toString());
            }
            $this$setMaximumSaturation_u24lambda_u245.target.getSaturationTargets()[2] = value;
            return builder;
        }

        @NotNull
        public final Builder setMinimumLightness(float value) {
            Builder builder;
            Builder $this$setMinimumLightness_u24lambda_u247 = builder = this;
            boolean bl = false;
            double d = value;
            if (!(0.0 <= d ? d <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "Min lightness value must be in the range 0..1";
                throw new IllegalArgumentException(string.toString());
            }
            $this$setMinimumLightness_u24lambda_u247.target.getLightnessTargets()[0] = value;
            return builder;
        }

        @NotNull
        public final Builder setTargetLightness(float value) {
            Builder builder;
            Builder $this$setTargetLightness_u24lambda_u249 = builder = this;
            boolean bl = false;
            double d = value;
            if (!(0.0 <= d ? d <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "Target lightness value must be in the range 0..1";
                throw new IllegalArgumentException(string.toString());
            }
            $this$setTargetLightness_u24lambda_u249.target.getLightnessTargets()[1] = value;
            return builder;
        }

        @NotNull
        public final Builder setMaximumLightness(float value) {
            Builder builder;
            Builder $this$setMaximumLightness_u24lambda_u2411 = builder = this;
            boolean bl = false;
            double d = value;
            if (!(0.0 <= d ? d <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "Max lightness value must be in the range 0..1";
                throw new IllegalArgumentException(string.toString());
            }
            $this$setMaximumLightness_u24lambda_u2411.target.getLightnessTargets()[2] = value;
            return builder;
        }

        @NotNull
        public final Builder setSaturationWeight(float weight) {
            Builder builder;
            Builder $this$setSaturationWeight_u24lambda_u2413 = builder = this;
            boolean bl = false;
            if (!(weight >= 0.0f)) {
                boolean bl2 = false;
                String string = "Saturation weight must be non negative";
                throw new IllegalArgumentException(string.toString());
            }
            $this$setSaturationWeight_u24lambda_u2413.target.getWeights()[0] = weight;
            return builder;
        }

        @NotNull
        public final Builder setLightnessWeight(float weight) {
            Builder builder;
            Builder $this$setLightnessWeight_u24lambda_u2415 = builder = this;
            boolean bl = false;
            if (!(weight >= 0.0f)) {
                boolean bl2 = false;
                String string = "Lightness weight must be non negative";
                throw new IllegalArgumentException(string.toString());
            }
            $this$setLightnessWeight_u24lambda_u2415.target.getWeights()[1] = weight;
            return builder;
        }

        @NotNull
        public final Builder setPopulationWeight(float weight) {
            Builder builder;
            Builder $this$setPopulationWeight_u24lambda_u2417 = builder = this;
            boolean bl = false;
            if (!(weight >= 0.0f)) {
                boolean bl2 = false;
                String string = "Population weight must be non negative";
                throw new IllegalArgumentException(string.toString());
            }
            $this$setPopulationWeight_u24lambda_u2417.target.getWeights()[2] = weight;
            return builder;
        }

        @NotNull
        public final Builder setExclusive(boolean exclusive) {
            Builder builder;
            Builder $this$setExclusive_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$setExclusive_u24lambda_u2418.target.setExclusive(exclusive);
            return builder;
        }

        @NotNull
        public final Target build() {
            return this.target;
        }

        public Builder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\f\u0010+\u001a\u00020(*\u00020\u0004H\u0002J\f\u0010,\u001a\u00020(*\u00020\u0004H\u0002J\f\u0010-\u001a\u00020(*\u00020\u0004H\u0002J\f\u0010.\u001a\u00020(*\u00020\u0004H\u0002J\f\u0010/\u001a\u00020(*\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u0011\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0006R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u000e\u0010\u001d\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0006R\u000e\u0010$\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/kmpalette/palette/graphics/Target$Companion;", "", "()V", "DARK_MUTED", "Lcom/kmpalette/palette/graphics/Target;", "getDARK_MUTED", "()Lcom/kmpalette/palette/graphics/Target;", "DARK_VIBRANT", "getDARK_VIBRANT", "INDEX_MAX", "", "INDEX_MIN", "INDEX_TARGET", "INDEX_WEIGHT_LUMA", "INDEX_WEIGHT_POP", "INDEX_WEIGHT_SAT", "LIGHT_MUTED", "getLIGHT_MUTED", "LIGHT_VIBRANT", "getLIGHT_VIBRANT", "MAX_DARK_LUMA", "", "MAX_MUTED_SATURATION", "MAX_NORMAL_LUMA", "MIN_LIGHT_LUMA", "MIN_NORMAL_LUMA", "MIN_VIBRANT_SATURATION", "MUTED", "getMUTED", "TARGET_DARK_LUMA", "TARGET_LIGHT_LUMA", "TARGET_MUTED_SATURATION", "TARGET_NORMAL_LUMA", "TARGET_VIBRANT_SATURATION", "VIBRANT", "getVIBRANT", "WEIGHT_LUMA", "WEIGHT_POPULATION", "WEIGHT_SATURATION", "setTargetDefaultValues", "", "values", "", "setDefaultDarkLightnessValues", "setDefaultLightLightnessValues", "setDefaultMutedSaturationValues", "setDefaultNormalLightnessValues", "setDefaultVibrantSaturationValues", "androidx-palette"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Target getLIGHT_VIBRANT() {
            return LIGHT_VIBRANT;
        }

        @NotNull
        public final Target getVIBRANT() {
            return VIBRANT;
        }

        @NotNull
        public final Target getDARK_VIBRANT() {
            return DARK_VIBRANT;
        }

        @NotNull
        public final Target getLIGHT_MUTED() {
            return LIGHT_MUTED;
        }

        @NotNull
        public final Target getMUTED() {
            return MUTED;
        }

        @NotNull
        public final Target getDARK_MUTED() {
            return DARK_MUTED;
        }

        private final void setTargetDefaultValues(float[] values) {
            values[0] = 0.0f;
            values[1] = 0.5f;
            values[2] = 1.0f;
        }

        private final void setDefaultDarkLightnessValues(Target $this$setDefaultDarkLightnessValues) {
            $this$setDefaultDarkLightnessValues.getLightnessTargets()[1] = 0.26f;
            $this$setDefaultDarkLightnessValues.getLightnessTargets()[2] = 0.45f;
        }

        private final void setDefaultNormalLightnessValues(Target $this$setDefaultNormalLightnessValues) {
            $this$setDefaultNormalLightnessValues.getLightnessTargets()[0] = 0.3f;
            $this$setDefaultNormalLightnessValues.getLightnessTargets()[1] = 0.5f;
            $this$setDefaultNormalLightnessValues.getLightnessTargets()[2] = 0.7f;
        }

        private final void setDefaultLightLightnessValues(Target $this$setDefaultLightLightnessValues) {
            $this$setDefaultLightLightnessValues.getLightnessTargets()[0] = 0.55f;
            $this$setDefaultLightLightnessValues.getLightnessTargets()[1] = 0.74f;
        }

        private final void setDefaultVibrantSaturationValues(Target $this$setDefaultVibrantSaturationValues) {
            $this$setDefaultVibrantSaturationValues.getSaturationTargets()[0] = 0.35f;
            $this$setDefaultVibrantSaturationValues.getSaturationTargets()[1] = 1.0f;
        }

        private final void setDefaultMutedSaturationValues(Target $this$setDefaultMutedSaturationValues) {
            $this$setDefaultMutedSaturationValues.getSaturationTargets()[1] = 0.3f;
            $this$setDefaultMutedSaturationValues.getSaturationTargets()[2] = 0.4f;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

