/*
 * Decompiled with CFR 0.152.
 */
package com.kmpalette.palette.internal;

import androidx.compose.runtime.internal.StabilityInferred;
import com.kmpalette.palette.graphics.Palette;
import com.kmpalette.palette.internal.utils.ColorUtils;
import com.kmpalette.palette.internal.utils.PriorityQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 )2\u00020\u0001:\u0002)*B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u001cR\u00020\u00000\u001bH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0018H\u0002J\"\u0010$\u001a\u00020%2\u0010\u0010&\u001a\f\u0012\b\u0012\u00060\u001cR\u00020\u00000'2\u0006\u0010(\u001a\u00020\u0005H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/kmpalette/palette/internal/ColorCutQuantizer;", "", "pixels", "", "maxColors", "", "filters", "", "Lcom/kmpalette/palette/graphics/Palette$Filter;", "([II[Lcom/kmpalette/palette/graphics/Palette$Filter;)V", "_quantizedColors", "", "Lcom/kmpalette/palette/graphics/Palette$Swatch;", "colors", "getColors", "()[I", "[Lcom/kmpalette/palette/graphics/Palette$Filter;", "histogram", "getHistogram", "quantizedColors", "", "getQuantizedColors", "()Ljava/util/List;", "tempHsl", "", "generateAverageColors", "vboxes", "", "Lcom/kmpalette/palette/internal/ColorCutQuantizer$Vbox;", "quantizePixels", "shouldIgnoreColor", "", "color", "color565", "rgb", "hsl", "splitBoxes", "", "queue", "Lcom/kmpalette/palette/internal/utils/PriorityQueue;", "maxSize", "Companion", "Vbox", "androidx-palette"})
@StabilityInferred(parameters=0)
public final class ColorCutQuantizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] colors;
    @NotNull
    private final int[] histogram;
    @Nullable
    private final Palette.Filter[] filters;
    @NotNull
    private final float[] tempHsl;
    @NotNull
    private List<Palette.Swatch> _quantizedColors;
    public static final int $stable = 8;
    public static final int COMPONENT_RED = -3;
    public static final int COMPONENT_GREEN = -2;
    public static final int COMPONENT_BLUE = -1;
    private static final int QUANTIZE_WORD_WIDTH = 5;
    private static final int QUANTIZE_WORD_MASK = 31;
    @NotNull
    private static final Comparator<Vbox> VBOX_COMPARATOR_VOLUME = ColorCutQuantizer::VBOX_COMPARATOR_VOLUME$lambda$0;

    public ColorCutQuantizer(@NotNull int[] pixels, int maxColors, @Nullable Palette.Filter[] filters) {
        int quantizedColor;
        Intrinsics.checkNotNullParameter((Object)pixels, (String)"pixels");
        this.tempHsl = new float[3];
        this._quantizedColors = new ArrayList();
        this.filters = filters;
        int[] hist = this.histogram = new int[32768];
        int n = pixels.length;
        for (int i = 0; i < n; ++i) {
            pixels[i] = quantizedColor = ColorCutQuantizer.Companion.quantizeFromRgb888(pixels[i]);
            int n2 = hist[quantizedColor];
            hist[quantizedColor] = n2 + 1;
        }
        int distinctColorCount = 0;
        quantizedColor = hist.length;
        for (int color = 0; color < quantizedColor; ++color) {
            if (hist[color] > 0 && this.shouldIgnoreColor(color)) {
                hist[color] = 0;
            }
            if (hist[color] <= 0) continue;
            ++distinctColorCount;
        }
        int[] colors = this.colors = new int[distinctColorCount];
        int distinctColorIndex = 0;
        int n3 = hist.length;
        for (int color = 0; color < n3; ++color) {
            if (hist[color] <= 0) continue;
            colors[distinctColorIndex++] = color;
        }
        if (distinctColorCount <= maxColors) {
            this._quantizedColors = new ArrayList();
            for (int color : colors) {
                this._quantizedColors.add(new Palette.Swatch(ColorCutQuantizer.Companion.approximateToRgb888(color), hist[color]));
            }
        } else {
            this._quantizedColors = this.quantizePixels(maxColors);
        }
    }

    @NotNull
    public final int[] getColors() {
        return this.colors;
    }

    @NotNull
    public final int[] getHistogram() {
        return this.histogram;
    }

    @NotNull
    public final List<Palette.Swatch> getQuantizedColors() {
        return this._quantizedColors;
    }

    private final List<Palette.Swatch> quantizePixels(int maxColors) {
        PriorityQueue<Vbox> pq = new PriorityQueue<Vbox>(VBOX_COMPARATOR_VOLUME);
        pq.offer(new Vbox(0, this.colors.length - 1));
        this.splitBoxes(pq, maxColors);
        return this.generateAverageColors((Collection<Vbox>)pq);
    }

    private final void splitBoxes(PriorityQueue<Vbox> queue, int maxSize) {
        while (queue.size() < maxSize) {
            Vbox vbox = queue.poll();
            if (vbox != null && vbox.canSplit()) {
                queue.offer(vbox.splitBox());
                queue.offer(vbox);
                continue;
            }
            return;
        }
    }

    private final List<Palette.Swatch> generateAverageColors(Collection<Vbox> vboxes) {
        List colors = new ArrayList();
        for (Vbox vbox : vboxes) {
            Palette.Swatch swatch = vbox.getAverageColor();
            if (this.shouldIgnoreColor(swatch)) continue;
            colors.add(swatch);
        }
        return colors;
    }

    private final boolean shouldIgnoreColor(int color565) {
        int rgb = ColorCutQuantizer.Companion.approximateToRgb888(color565);
        ColorUtils.INSTANCE.colorToHSL(rgb, this.tempHsl);
        return this.shouldIgnoreColor(rgb, this.tempHsl);
    }

    private final boolean shouldIgnoreColor(Palette.Swatch color) {
        return this.shouldIgnoreColor(color.getRgb(), color.getHsl());
    }

    private final boolean shouldIgnoreColor(int rgb, float[] hsl) {
        Palette.Filter[] filterArray = this.filters;
        if (!(filterArray == null || filterArray.length == 0)) {
            int count = this.filters.length;
            for (int i = 0; i < count; ++i) {
                if (this.filters[i].isAllowed(rgb, hsl)) continue;
                return true;
            }
        }
        return false;
    }

    private static final int VBOX_COMPARATOR_VOLUME$lambda$0(Vbox a, Vbox b) {
        return b.getVolume() - a.getVolume();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004J \u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010 \u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\b\u0012\u00060\u000bR\u00020\f0\nj\f\u0012\b\u0012\u00060\u000bR\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/kmpalette/palette/internal/ColorCutQuantizer$Companion;", "", "()V", "COMPONENT_BLUE", "", "COMPONENT_GREEN", "COMPONENT_RED", "QUANTIZE_WORD_MASK", "QUANTIZE_WORD_WIDTH", "VBOX_COMPARATOR_VOLUME", "Ljava/util/Comparator;", "Lcom/kmpalette/palette/internal/ColorCutQuantizer$Vbox;", "Lcom/kmpalette/palette/internal/ColorCutQuantizer;", "Lkotlin/Comparator;", "approximateToRgb888", "color", "r", "g", "b", "modifySignificantOctet", "", "a", "", "dimension", "lower", "upper", "modifyWordWidth", "value", "currentWidth", "targetWidth", "quantizeFromRgb888", "quantizedBlue", "quantizedGreen", "quantizedRed", "androidx-palette"})
    public static final class Companion {
        private Companion() {
        }

        public final void modifySignificantOctet(@NotNull int[] a, int dimension, int lower, int upper) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            switch (dimension) {
                case -3: {
                    break;
                }
                case -2: {
                    for (int i = lower; i <= upper; ++i) {
                        int values;
                        int color = a[i];
                        a[i] = values = this.quantizedGreen(color) << 10 | this.quantizedRed(color) << 5 | this.quantizedBlue(color);
                    }
                    break;
                }
                case -1: {
                    for (int i = lower; i <= upper; ++i) {
                        int color = a[i];
                        a[i] = this.quantizedBlue(color) << 10 | this.quantizedGreen(color) << 5 | this.quantizedRed(color);
                    }
                    break;
                }
            }
        }

        private final int quantizeFromRgb888(int color) {
            int r = this.modifyWordWidth(ColorUtils.INSTANCE.red(color), 8, 5);
            int g = this.modifyWordWidth(ColorUtils.INSTANCE.green(color), 8, 5);
            int b = this.modifyWordWidth(ColorUtils.INSTANCE.blue(color), 8, 5);
            return r << 10 | g << 5 | b;
        }

        public final int approximateToRgb888(int r, int g, int b) {
            return ColorUtils.INSTANCE.rgb(this.modifyWordWidth(r, 5, 8), this.modifyWordWidth(g, 5, 8), this.modifyWordWidth(b, 5, 8));
        }

        private final int approximateToRgb888(int color) {
            return this.approximateToRgb888(this.quantizedRed(color), this.quantizedGreen(color), this.quantizedBlue(color));
        }

        public final int quantizedRed(int color) {
            return color >> 10 & 0x1F;
        }

        public final int quantizedGreen(int color) {
            return color >> 5 & 0x1F;
        }

        public final int quantizedBlue(int color) {
            return color & 0x1F;
        }

        private final int modifyWordWidth(int value, int currentWidth, int targetWidth) {
            int newValue = targetWidth > currentWidth ? value << targetWidth - currentWidth : value >> currentWidth - targetWidth;
            return newValue & (1 << targetWidth) - 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u001cJ\n\u0010\u001d\u001a\u00060\u0000R\u00020\u001eR\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/kmpalette/palette/internal/ColorCutQuantizer$Vbox;", "", "lowerIndex", "", "upperIndex", "(Lcom/kmpalette/palette/internal/ColorCutQuantizer;II)V", "averageColor", "Lcom/kmpalette/palette/graphics/Palette$Swatch;", "getAverageColor", "()Lcom/kmpalette/palette/graphics/Palette$Swatch;", "colorCount", "getColorCount", "()I", "longestColorDimension", "getLongestColorDimension", "maxBlue", "maxGreen", "maxRed", "minBlue", "minGreen", "minRed", "population", "volume", "getVolume", "canSplit", "", "findSplitPoint", "fitBox", "", "splitBox", "Lcom/kmpalette/palette/internal/ColorCutQuantizer;", "androidx-palette"})
    private final class Vbox {
        private final int lowerIndex;
        private int upperIndex;
        private int population;
        private int minRed;
        private int maxRed;
        private int minGreen;
        private int maxGreen;
        private int minBlue;
        private int maxBlue;

        public Vbox(int lowerIndex, int upperIndex) {
            this.lowerIndex = lowerIndex;
            this.upperIndex = upperIndex;
            this.fitBox();
        }

        public final int getVolume() {
            return (this.maxRed - this.minRed + 1) * (this.maxGreen - this.minGreen + 1) * (this.maxBlue - this.minBlue + 1);
        }

        public final boolean canSplit() {
            return this.getColorCount() > 1;
        }

        public final int getColorCount() {
            return 1 + this.upperIndex - this.lowerIndex;
        }

        public final void fitBox() {
            int[] colors = ColorCutQuantizer.this.getColors();
            int[] hist = ColorCutQuantizer.this.getHistogram();
            int minRed = 0;
            int minGreen = 0;
            int minBlue = 0;
            minRed = minGreen = (minBlue = Integer.MAX_VALUE);
            int maxRed = 0;
            int maxGreen = 0;
            int maxBlue = 0;
            maxRed = maxGreen = (maxBlue = Integer.MIN_VALUE);
            int count = 0;
            int i = this.lowerIndex;
            int n = this.upperIndex;
            if (i <= n) {
                while (true) {
                    int color = colors[i];
                    count += hist[color];
                    int r = Companion.quantizedRed(color);
                    int g = Companion.quantizedGreen(color);
                    int b = Companion.quantizedBlue(color);
                    if (r > maxRed) {
                        maxRed = r;
                    }
                    if (r < minRed) {
                        minRed = r;
                    }
                    if (g > maxGreen) {
                        maxGreen = g;
                    }
                    if (g < minGreen) {
                        minGreen = g;
                    }
                    if (b > maxBlue) {
                        maxBlue = b;
                    }
                    if (b < minBlue) {
                        minBlue = b;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            this.minRed = minRed;
            this.maxRed = maxRed;
            this.minGreen = minGreen;
            this.maxGreen = maxGreen;
            this.minBlue = minBlue;
            this.maxBlue = maxBlue;
            this.population = count;
        }

        @NotNull
        public final Vbox splitBox() {
            if (!this.canSplit()) {
                throw new IllegalStateException("Can not split a box with only 1 color");
            }
            int splitPoint = this.findSplitPoint();
            Vbox newBox = new Vbox(splitPoint + 1, this.upperIndex);
            this.upperIndex = splitPoint;
            this.fitBox();
            return newBox;
        }

        public final int getLongestColorDimension() {
            int redLength = this.maxRed - this.minRed;
            int greenLength = this.maxGreen - this.minGreen;
            int blueLength = this.maxBlue - this.minBlue;
            return redLength >= greenLength && redLength >= blueLength ? -3 : (greenLength >= redLength && greenLength >= blueLength ? -2 : -1);
        }

        public final int findSplitPoint() {
            int longestDimension = this.getLongestColorDimension();
            int[] colors = ColorCutQuantizer.this.getColors();
            int[] hist = ColorCutQuantizer.this.getHistogram();
            Companion.modifySignificantOctet(colors, longestDimension, this.lowerIndex, this.upperIndex);
            ArraysKt.sort((int[])colors, (int)this.lowerIndex, (int)(this.upperIndex + 1));
            Companion.modifySignificantOctet(colors, longestDimension, this.lowerIndex, this.upperIndex);
            int midPoint = this.population / 2;
            int count = 0;
            for (int i = this.lowerIndex; i <= this.upperIndex; ++i) {
                if ((count += hist[colors[i]]) < midPoint) continue;
                return Math.min(this.upperIndex - 1, i);
            }
            return this.lowerIndex;
        }

        @NotNull
        public final Palette.Swatch getAverageColor() {
            int[] colors = ColorCutQuantizer.this.getColors();
            int[] hist = ColorCutQuantizer.this.getHistogram();
            int redSum = 0;
            int greenSum = 0;
            int blueSum = 0;
            int totalPopulation = 0;
            int i = this.lowerIndex;
            int n = this.upperIndex;
            if (i <= n) {
                while (true) {
                    int color = colors[i];
                    int colorPopulation = hist[color];
                    totalPopulation += colorPopulation;
                    redSum += colorPopulation * Companion.quantizedRed(color);
                    greenSum += colorPopulation * Companion.quantizedGreen(color);
                    blueSum += colorPopulation * Companion.quantizedBlue(color);
                    if (i == n) break;
                    ++i;
                }
            }
            int redMean = (int)Math.rint((float)redSum / (float)totalPopulation);
            int greenMean = (int)Math.rint((float)greenSum / (float)totalPopulation);
            int blueMean = (int)Math.rint((float)blueSum / (float)totalPopulation);
            return new Palette.Swatch(Companion.approximateToRgb888(redMean, greenMean, blueMean), totalPopulation);
        }
    }
}

