/*
 * Decompiled with CFR 0.152.
 */
package com.kochava.base.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import androidx.annotation.AnyThread;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import org.jetbrains.annotations.Contract;
import org.json.JSONObject;

@Keep
public final class DataPointsNetwork {
    @Keep
    @Nullable
    @WorkerThread
    @VisibleForTesting
    public static Object getNew(@NonNull String string, @NonNull Context context, @Nullable JSONObject jSONObject, @Nullable Object object) {
        switch (string) {
            case "network_conn_type": {
                return DataPointsNetwork.a(context);
            }
            case "network_metered": {
                return DataPointsNetwork.b(context);
            }
            case "ssid": {
                return DataPointsNetwork.c(context);
            }
            case "bssid": {
                return DataPointsNetwork.d(context);
            }
        }
        return null;
    }

    @AnyThread
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @Contract(pure=true)
    @Nullable
    private static String a(@NonNull Context context) {
        if (!DataPointsNetwork.a(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return null;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return null;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            int n = networkInfo.getType();
            if (n == 0 || n == 4 || n == 5 || n == 2 || n == 3) {
                return "cellular";
            }
            if (n == 9) {
                return "wired";
            }
            return "wifi";
        }
        return "none";
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @AnyThread
    @Contract(pure=true)
    private static boolean b(@NonNull Context context) {
        if (Build.VERSION.SDK_INT < 16) {
            return false;
        }
        if (!DataPointsNetwork.a(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        return connectivityManager.isActiveNetworkMetered();
    }

    @AnyThread
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    @Contract(pure=true)
    @Nullable
    private static String c(@NonNull Context context) {
        if (!DataPointsNetwork.a(context, "android.permission.ACCESS_WIFI_STATE")) {
            return null;
        }
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (wifiManager == null) {
            return null;
        }
        return wifiManager.getConnectionInfo().getSSID();
    }

    @AnyThread
    @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
    @Contract(pure=true)
    @Nullable
    private static String d(@NonNull Context context) {
        if (!DataPointsNetwork.a(context, "android.permission.ACCESS_WIFI_STATE")) {
            return null;
        }
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (wifiManager == null) {
            return null;
        }
        return wifiManager.getConnectionInfo().getBSSID();
    }

    @AnyThread
    @Contract(pure=true)
    private static boolean a(@NonNull Context context, @NonNull String string) {
        return context.getPackageManager().checkPermission(string, context.getPackageName()) == 0;
    }
}

