/*
 * Decompiled with CFR 0.152.
 */
package com.kodeblox;

import com.google.common.math.BigIntegerMath;
import com.kodeblox.NumericalMethodsFunctions;
import java.math.BigDecimal;
import java.math.MathContext;

public final class BigDecimalFunctions {
    public static final BigDecimal PI = new BigDecimal("3.141592653589793238462643383279503");

    public static BigDecimal exp(BigDecimal exponent, MathContext mc) {
        MathContext newMc = new MathContext(mc.getPrecision() + 3);
        if (exponent.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ONE.divide(BigDecimalFunctions.exp(exponent.negate(), newMc), newMc);
        }
        if (exponent.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ONE;
        }
        BigDecimal wholePart = BigDecimalFunctions.getWhole(exponent);
        if (wholePart.compareTo(BigDecimal.ZERO) == 0 || wholePart.compareTo(BigDecimal.ONE) == 0) {
            return NumericalMethodsFunctions.expTaylorSeries(exponent, newMc).round(mc);
        }
        BigDecimal fractionPart = BigDecimalFunctions.getFraction(exponent);
        BigDecimal newExponent = BigDecimal.ONE.add(fractionPart.divide(wholePart, newMc), newMc);
        BigDecimal power = wholePart;
        BigDecimal taylor = NumericalMethodsFunctions.expTaylorSeries(newExponent, newMc);
        BigDecimal longMaxValue = BigDecimal.valueOf(Long.MAX_VALUE);
        BigDecimal result = BigDecimal.ONE;
        if (wholePart.compareTo(longMaxValue) > 0) {
            while (power.compareTo(longMaxValue) > 0) {
                result = result.multiply(BigDecimalFunctions.pow(taylor, Long.MAX_VALUE, newMc), newMc);
                power = power.subtract(longMaxValue, newMc);
            }
        }
        return result.multiply(BigDecimalFunctions.pow(taylor, power.longValue(), newMc)).round(mc);
    }

    public static BigDecimal pow(BigDecimal base, long exponent, MathContext mc) {
        if (exponent < 0L) {
            return BigDecimal.ONE.divide(BigDecimalFunctions.pow(base, -exponent, mc), mc);
        }
        BigDecimal result = BigDecimal.ONE;
        while (exponent > 0L) {
            if ((exponent & 1L) == 1L) {
                result = result.multiply(base, mc);
            }
            base = base.multiply(base, mc);
            exponent >>= 1;
        }
        return result;
    }

    public static BigDecimal getWhole(BigDecimal number) {
        return number.setScale(0, 1);
    }

    public static BigDecimal getFraction(BigDecimal number) {
        return number.subtract(BigDecimalFunctions.getWhole(number));
    }

    public static BigDecimal ln(BigDecimal value, MathContext mc) {
        if (value.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("Log requires values greater than 0");
        }
        MathContext newMc = new MathContext(mc.getPrecision() + 3);
        long wholeDigits = value.precision() - value.scale();
        int THRESHOLD = 3;
        if (wholeDigits < 3L) {
            return NumericalMethodsFunctions.lnNewtonRaphson(value, newMc).round(mc);
        }
        return BigDecimal.valueOf(wholeDigits).multiply(NumericalMethodsFunctions.lnNewtonRaphson(BigDecimalFunctions.root(value, wholeDigits, newMc), newMc), newMc).round(mc);
    }

    public static BigDecimal pow(BigDecimal base, BigDecimal exponent, MathContext mc) {
        if (BigDecimalFunctions.getFraction(exponent).compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimalFunctions.pow(base, exponent.longValue(), mc);
        }
        MathContext newMc = new MathContext(mc.getPrecision() + 3);
        BigDecimal ln = BigDecimalFunctions.ln(base, newMc);
        BigDecimal exp = exponent.multiply(ln, newMc);
        return BigDecimalFunctions.exp(exp, newMc).round(mc);
    }

    public static BigDecimal sqrt(BigDecimal value, MathContext mc) {
        MathContext newMc = new MathContext(mc.getPrecision() + 3);
        return NumericalMethodsFunctions.sqrtNewtonRaphson(value, newMc).round(mc);
    }

    public static BigDecimal root(BigDecimal base, long exponent, MathContext mc) {
        MathContext newMc = new MathContext(mc.getPrecision() + 3);
        return NumericalMethodsFunctions.rootNewtonRaphson(base, exponent, newMc).round(mc);
    }

    public static BigDecimal sin(BigDecimal angle, MathContext mc) {
        MathContext newMc = new MathContext(mc.getPrecision() + 3);
        if (angle.compareTo(PI.multiply(BigDecimal.valueOf(2L), newMc)) >= 0) {
            long n = angle.divide(PI.multiply(BigDecimal.valueOf(2L), newMc), newMc).longValue();
            angle = angle.subtract(PI.multiply(BigDecimal.valueOf(n * 2L), newMc), newMc);
        }
        if (angle.compareTo(PI) >= 0) {
            angle = angle.subtract(PI, newMc).negate();
        }
        if (angle.compareTo(PI.divide(BigDecimal.valueOf(2L), newMc)) > 0) {
            angle = angle.subtract(PI, newMc).negate();
        }
        if (angle.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimalFunctions.sin(angle.negate(), newMc).negate().round(mc);
        }
        if (angle.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return NumericalMethodsFunctions.sinTaylorSeries(angle, newMc).round(mc);
    }

    public static BigDecimal cos(BigDecimal angle, MathContext mc) {
        MathContext newMc = new MathContext(mc.getPrecision() + 3);
        if (angle.compareTo(PI.multiply(BigDecimal.valueOf(2L), newMc)) >= 0) {
            long n = angle.divide(PI.multiply(BigDecimal.valueOf(2L), newMc), newMc).longValue();
            angle = angle.subtract(PI.multiply(BigDecimal.valueOf(n * 2L), newMc), newMc);
        }
        if (angle.compareTo(PI) >= 0) {
            angle = angle.subtract(PI.multiply(BigDecimal.valueOf(2L), newMc), newMc).negate();
        }
        if (angle.compareTo(PI.divide(BigDecimal.valueOf(2L), newMc)) > 0) {
            angle = angle.subtract(PI, newMc).negate();
            return NumericalMethodsFunctions.cosTaylorSeries(angle, newMc).negate().round(mc);
        }
        if (angle.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimalFunctions.cos(angle.negate(), newMc).round(mc);
        }
        if (angle.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ONE;
        }
        return NumericalMethodsFunctions.cosTaylorSeries(angle, newMc).round(mc);
    }

    public static BigDecimal tan(BigDecimal angle, MathContext mc) {
        MathContext newMc = new MathContext(mc.getPrecision() + 3);
        if (angle.compareTo(PI.multiply(BigDecimal.valueOf(2L), newMc)) >= 0) {
            long n = angle.divide(PI.multiply(BigDecimal.valueOf(2L), newMc), newMc).longValue();
            angle = angle.subtract(PI.multiply(BigDecimal.valueOf(n * 2L), newMc), newMc);
        }
        if (angle.compareTo(PI) >= 0) {
            angle = angle.subtract(PI, newMc);
        }
        if (angle.compareTo(PI.divide(BigDecimal.valueOf(2L), newMc)) > 0) {
            angle = angle.subtract(PI, newMc).negate();
            return NumericalMethodsFunctions.tanCompute(angle, newMc).negate().round(mc);
        }
        if (angle.compareTo(PI.divide(BigDecimal.valueOf(2L), newMc)) == 0) {
            throw new ArithmeticException("The Angle is an odd multiple of PI / 2");
        }
        if (angle.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimalFunctions.tan(angle.negate(), newMc).negate().round(mc);
        }
        if (angle.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return NumericalMethodsFunctions.tanCompute(angle, newMc).round(mc);
    }

    public static BigDecimal factorial(BigDecimal value, MathContext mc) {
        MathContext newMc = new MathContext(mc.getPrecision() + 3);
        return new BigDecimal(BigIntegerMath.factorial((int)Integer.parseInt(value.toString())).toString(), newMc).round(mc);
    }

    public static BigDecimal arcsin(BigDecimal value, MathContext mc) {
        if (value.abs().compareTo(BigDecimal.ONE) > 0) {
            throw new IllegalArgumentException("Arcsin requires values lesser than equal to 1");
        }
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimalFunctions.arcsin(value.negate(), mc).negate();
        }
        MathContext newMc = new MathContext(mc.getPrecision() + 3);
        if (value.compareTo(BigDecimal.ONE) == 0) {
            return PI.divide(BigDecimal.valueOf(2L), newMc).round(mc);
        }
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return NumericalMethodsFunctions.arcsinCompute(value, newMc).round(mc);
    }

    public static BigDecimal arccos(BigDecimal value, MathContext mc) {
        if (value.abs().compareTo(BigDecimal.ONE) > 0) {
            throw new IllegalArgumentException("Arccos requires values lesser than equal to 1");
        }
        MathContext newMc = new MathContext(mc.getPrecision() + 3);
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            return PI.subtract(BigDecimalFunctions.arccos(value.negate(), mc), mc);
        }
        if (value.compareTo(BigDecimal.ONE) == 0) {
            return BigDecimal.ZERO;
        }
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            return PI.divide(BigDecimal.valueOf(2L), newMc).round(mc);
        }
        return NumericalMethodsFunctions.arccosCompute(value, newMc).round(mc);
    }

    public static BigDecimal arctan(BigDecimal value, MathContext mc) {
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimalFunctions.arctan(value.negate(), mc).negate();
        }
        if (value.compareTo(BigDecimal.ONE) > 0) {
            return PI.divide(BigDecimal.valueOf(2L), mc).subtract(BigDecimalFunctions.arctan(BigDecimal.ONE.divide(value, mc), mc), mc);
        }
        MathContext newMc = new MathContext(mc.getPrecision() + 3);
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal rootThree = BigDecimalFunctions.sqrt(BigDecimal.valueOf(3L), newMc);
        if (value.compareTo(BigDecimal.valueOf(2L).subtract(rootThree, newMc)) > 0) {
            value = rootThree.multiply(value, newMc).subtract(BigDecimal.ONE, newMc).divide(rootThree.add(value, newMc), newMc);
            return NumericalMethodsFunctions.arctanTaylorSeries(value, newMc).add(PI.divide(BigDecimal.valueOf(6L), newMc), newMc).round(mc);
        }
        return NumericalMethodsFunctions.arctanTaylorSeries(value, newMc).round(mc);
    }
}

