/*
 * Decompiled with CFR 0.152.
 */
package com.kodeblox;

import com.kodeblox.BigDecimalFunctions;
import java.math.BigDecimal;
import java.math.MathContext;

public class NumericalMethodsFunctions {
    protected static BigDecimal expTaylorSeries(BigDecimal exponent, MathContext mc) {
        BigDecimal lastSum;
        BigDecimal currentSum = BigDecimal.ZERO;
        BigDecimal numerator = BigDecimal.ONE;
        BigDecimal denominator = BigDecimal.ONE;
        int i = 0;
        do {
            lastSum = currentSum;
            BigDecimal term = numerator.divide(denominator, mc);
            currentSum = currentSum.add(term, mc);
            numerator = numerator.multiply(exponent, mc);
            denominator = denominator.multiply(BigDecimal.valueOf(++i), mc);
        } while (lastSum.compareTo(currentSum) != 0);
        return currentSum;
    }

    protected static BigDecimal lnNewtonRaphson(BigDecimal value, MathContext mc) {
        BigDecimal lastTerm;
        BigDecimal denominator;
        BigDecimal exp;
        BigDecimal numerator;
        BigDecimal reductionTerm;
        BigDecimal y = value;
        do {
            lastTerm = y;
        } while ((y = y.subtract(reductionTerm = (numerator = (exp = BigDecimalFunctions.exp(y, mc)).subtract(value, mc)).divide(denominator = exp, mc), mc)).compareTo(lastTerm) != 0);
        return y;
    }

    protected static BigDecimal rootNewtonRaphson(BigDecimal base, long exponent, MathContext mc) {
        BigDecimal lastTerm;
        BigDecimal y = base;
        BigDecimal power = BigDecimal.valueOf(exponent);
        BigDecimal powerMinusOne = power.subtract(BigDecimal.ONE, mc);
        do {
            lastTerm = y;
            y = y.multiply(powerMinusOne, mc).add(base.divide(BigDecimalFunctions.pow(y, powerMinusOne.longValue(), mc), mc));
        } while ((y = y.divide(power, mc)).compareTo(lastTerm) != 0);
        return y;
    }

    protected static BigDecimal sinTaylorSeries(BigDecimal angle, MathContext mc) {
        BigDecimal lastSum;
        BigDecimal currentSum = BigDecimal.ZERO;
        BigDecimal numerator = angle;
        BigDecimal denominator = BigDecimal.ONE;
        int i = 1;
        do {
            lastSum = currentSum;
            BigDecimal term = numerator.divide(denominator, mc);
            currentSum = currentSum.add(term, mc);
            numerator = numerator.multiply(angle, mc).multiply(angle, mc).negate();
            denominator = denominator.multiply(BigDecimal.valueOf(i += 2), mc).multiply(BigDecimal.valueOf(i - 1), mc);
        } while (lastSum.compareTo(currentSum) != 0);
        return currentSum;
    }

    protected static BigDecimal sqrtNewtonRaphson(BigDecimal value, MathContext mc) {
        BigDecimal lastTerm;
        BigDecimal y = value;
        do {
            lastTerm = y;
        } while ((y = y.add(value.divide(y, mc), mc).divide(BigDecimal.valueOf(2L), mc)).compareTo(lastTerm) != 0);
        return y;
    }

    public static BigDecimal cosTaylorSeries(BigDecimal angle, MathContext mc) {
        BigDecimal lastSum;
        BigDecimal currentSum = BigDecimal.ZERO;
        BigDecimal numerator = BigDecimal.ONE;
        BigDecimal denominator = BigDecimal.ONE;
        int i = 0;
        do {
            lastSum = currentSum;
            BigDecimal term = numerator.divide(denominator, mc);
            currentSum = currentSum.add(term, mc);
            numerator = numerator.multiply(angle, mc).multiply(angle, mc).negate();
            denominator = denominator.multiply(BigDecimal.valueOf(i += 2), mc).multiply(BigDecimal.valueOf(i - 1), mc);
        } while (lastSum.compareTo(currentSum) != 0);
        return currentSum;
    }

    public static BigDecimal tanCompute(BigDecimal angle, MathContext mc) {
        return NumericalMethodsFunctions.sinTaylorSeries(angle, mc).divide(NumericalMethodsFunctions.cosTaylorSeries(angle, mc), mc);
    }

    public static BigDecimal arcsinCompute(BigDecimal value, MathContext mc) {
        return BigDecimalFunctions.arctan(value.divide(BigDecimalFunctions.sqrt(BigDecimal.ONE.subtract(value.multiply(value, mc), mc), mc), mc), mc);
    }

    public static BigDecimal arccosCompute(BigDecimal value, MathContext mc) {
        return BigDecimalFunctions.arctan(BigDecimalFunctions.sqrt(BigDecimal.ONE.subtract(value.multiply(value, mc), mc), mc).divide(value, mc), mc);
    }

    public static BigDecimal arctanTaylorSeries(BigDecimal value, MathContext mc) {
        BigDecimal lastSum;
        BigDecimal currentSum = BigDecimal.ZERO;
        BigDecimal numerator = value;
        BigDecimal denominator = BigDecimal.ONE;
        int i = 0;
        do {
            lastSum = currentSum;
            BigDecimal term = numerator.divide(denominator, mc);
            currentSum = currentSum.add(term, mc);
            numerator = numerator.multiply(value, mc).multiply(value, mc).negate();
            denominator = BigDecimal.valueOf(2 * ++i + 1);
        } while (lastSum.compareTo(currentSum) != 0);
        return currentSum;
    }
}

