/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.testutil;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class OutputBridge
implements Runnable,
Closeable {
    private final byte[] prefix;
    private final InputStream in;
    private final OutputStream out;
    private int numRead = 0;
    private boolean closed = false;
    private ByteArrayOutputStream bos;

    public OutputBridge(Process process, ProcessStream output) {
        this(process, output, (byte[])null);
    }

    public OutputBridge(Process process, ProcessStream output, String prefix) {
        this(process, output, prefix == null || prefix.isEmpty() ? null : prefix.getBytes(Charset.defaultCharset()));
    }

    private OutputBridge(Process process, ProcessStream output, byte[] prefix) {
        this.prefix = prefix;
        switch (output) {
            case STDOUT: {
                this.in = new BufferedInputStream(process.getInputStream());
                this.out = System.out;
                break;
            }
            case STDERR: {
                this.in = new BufferedInputStream(process.getErrorStream());
                this.out = System.err;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public final void run() {
        this.bos = new ByteArrayOutputStream();
        if (this.prefix != null) {
            try {
                this.bos.write(this.prefix);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            int x;
            while (!this.closed && (x = this.in.read()) != -1) {
                ++this.numRead;
                this.bos.write(x);
                if (x != 10) continue;
                this.flush();
            }
            this.flush();
            this.bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void flush() throws IOException {
        if (this.bos.size() == (this.prefix == null ? 0 : this.prefix.length)) {
            return;
        }
        this.bos.writeTo(this.out);
        this.bos.reset();
        if (this.prefix != null) {
            this.bos.write(this.prefix);
        }
    }

    public final boolean hasOutput() {
        return this.numBytesRead() > 0;
    }

    public final int numBytesRead() {
        return this.numRead;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum ProcessStream {
        STDOUT,
        STDERR;

    }
}

