/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.testutil;

import com.kohlschutter.testutil.SystemPropertyRequirement;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SystemPropertyExecutionCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        SystemPropertyRequirement requirement;
        String property = null;
        String value = null;
        String message = "";
        Optional element = context.getElement();
        if (element.isPresent() && (requirement = ((AnnotatedElement)element.get()).getAnnotation(SystemPropertyRequirement.class)) != null) {
            property = requirement.property();
            value = requirement.value();
            message = requirement.message();
        }
        if (property == null) {
            return ConditionEvaluationResult.enabled((String)"Unconditional execution");
        }
        String propVal = System.getProperty(property);
        if (value == null || value.isEmpty()) {
            if (propVal == null || propVal.isEmpty()) {
                return ConditionEvaluationResult.enabled((String)"Property not set, as expected");
            }
            return ConditionEvaluationResult.disabled((String)message);
        }
        if (value.equals(propVal)) {
            return ConditionEvaluationResult.enabled((String)"Property set to correct value, as expected");
        }
        return ConditionEvaluationResult.disabled((String)message);
    }
}

