/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.testutil;

import com.kohlschutter.testutil.AvailabilityRequirement;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AvailabilityExecutionCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        AvailabilityRequirement requirement;
        String[] requiredClasses = new String[]{};
        String message = "";
        Optional element = context.getElement();
        if (element.isPresent() && (requirement = ((AnnotatedElement)element.get()).getAnnotation(AvailabilityRequirement.class)) != null) {
            requiredClasses = requirement.classes();
            message = requirement.message();
        }
        if (requiredClasses.length == 0) {
            return ConditionEvaluationResult.enabled((String)"Unconditional execution");
        }
        ArrayList<String> unsupported = new ArrayList<String>();
        for (String requiredClass : requiredClasses) {
            try {
                Class.forName(requiredClass, false, null);
            }
            catch (Exception e) {
                unsupported.add(requiredClass);
            }
        }
        ConditionEvaluationResult result = unsupported.isEmpty() ? ConditionEvaluationResult.enabled((String)"All expected classes could be resolved") : (message.isEmpty() ? ConditionEvaluationResult.disabled((String)("Skipping test due to missing classes: " + unsupported)) : ConditionEvaluationResult.disabled((String)message));
        return result;
    }
}

