/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.testutil;

import com.kohlschutter.testutil.CommandAvailabilityRequirement;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CommandAvailabilityExecutionCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        CommandAvailabilityRequirement requirement;
        String[] commands = null;
        String message = "";
        Optional element = context.getElement();
        if (element.isPresent() && (requirement = ((AnnotatedElement)element.get()).getAnnotation(CommandAvailabilityRequirement.class)) != null) {
            commands = requirement.commands();
            message = requirement.message();
        }
        if (commands == null || commands.length == 0) {
            return ConditionEvaluationResult.enabled((String)"Unconditional execution");
        }
        for (String command : commands) {
            try {
                if (Runtime.getRuntime().exec(new String[]{"which", command}).waitFor() == 0) continue;
                return ConditionEvaluationResult.disabled((String)message);
            }
            catch (IOException | InterruptedException e) {
                return ConditionEvaluationResult.disabled((String)message);
            }
        }
        return ConditionEvaluationResult.enabled((String)"All commands are available");
    }
}

