/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.testutil;

import com.kohlschutter.util.ProcessUtil;
import com.kohlschutter.util.SystemPropertyUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ForkedVM {
    private static final Set<String> HAS_PARAMETER = new HashSet<String>(Arrays.asList("--add-opens", "-p", "-cp", "--module-path", "--upgrade-module-path", "-classpath", "--class-path", "--patch-module", "--add-reads", "--add-exports", "--add-opens", "--add-modules", "-d", "--describe-module", "--limit-modules", "-jar"));
    private static final boolean SUPPORTED = !SystemPropertyUtil.getBooleanSystemProperty((String)"com.kohlschutter.ForkedVM.enabled", (boolean)true) ? false : ProcessUtil.getJavaCommand() != null && ProcessUtil.getJavaCommandArguments() != null;
    private List<String> cmd;
    private final String overrideMainClass;
    private final String[] overrideArgs;
    private boolean haveJavaMainClass = false;
    private boolean haveArguments = false;
    private ProcessBuilder.Redirect redirectInput = ProcessBuilder.Redirect.PIPE;
    private ProcessBuilder.Redirect redirectOutput = ProcessBuilder.Redirect.PIPE;
    private ProcessBuilder.Redirect redirectError = ProcessBuilder.Redirect.PIPE;

    protected ForkedVM() {
        this((String)null, (String[])null);
    }

    public ForkedVM(Class<?> mainClass) {
        this(mainClass.getName(), new String[0]);
    }

    public ForkedVM(Class<?> mainClass, String ... args) {
        this(mainClass.getName(), args);
    }

    public ForkedVM(String mainClass) {
        this(mainClass, new String[0]);
    }

    public ForkedVM(String mainClass, String ... args) {
        this.overrideMainClass = mainClass;
        this.overrideArgs = args == null ? null : (String[])args.clone();
    }

    public Process fork() throws IOException, UnsupportedOperationException {
        this.cmd = new ArrayList<String>();
        this.parse();
        if (!this.haveJavaMainClass) {
            this.onJavaMainClass(null);
        }
        if (!this.haveArguments) {
            this.onArguments(Collections.emptyList());
        }
        ProcessBuilder pb = new ProcessBuilder(this.cmd);
        pb.redirectInput(this.redirectInput);
        pb.redirectOutput(this.redirectOutput);
        pb.redirectError(this.redirectError);
        Process p = pb.start();
        return p;
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    private void parse() throws IOException, UnsupportedOperationException {
        String arg;
        String command = ProcessUtil.getJavaCommand();
        if (command == null) {
            throw new UnsupportedOperationException("Could not get VM command");
        }
        String[] commandArgs = ProcessUtil.getJavaCommandArguments();
        if (commandArgs == null || commandArgs.length == 0) {
            throw new UnsupportedOperationException("Could not get VM command arguments");
        }
        this.onJavaExecutable(command);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(commandArgs));
        while (!args.isEmpty() && this.parseArg(args, arg = ForkedVM.unescapeJavaArg((String)args.remove(0)))) {
        }
    }

    private boolean parseArg(List<String> args, String arg) throws FileNotFoundException, IOException {
        if (HAS_PARAMETER.contains(arg)) {
            this.onJavaOption(arg, ForkedVM.unescapeJavaArg(args.remove(0)));
        } else {
            if (!arg.startsWith("-")) {
                if (arg.startsWith("@") && arg.length() > 1) {
                    this.addExtraArgsFromFile(args, new File(arg.substring(1)));
                    return true;
                }
                this.onJavaMainClass(arg);
                this.onArguments(args);
                return false;
            }
            if (arg.startsWith("-javaagent")) {
                if (!this.onJavaAgent(arg)) {
                    this.parseJacocoJavaAgent(arg);
                }
            } else if (arg.startsWith("-XX:StartFlightRecording=") || arg.startsWith("-XX:StartFlightRecording:")) {
                if (!this.onStartFlightRecording(arg)) {
                    this.parseStartFlightRecording(arg);
                }
            } else {
                this.onJavaOption(arg);
            }
        }
        return true;
    }

    private void addExtraArgsFromFile(List<String> args, File f) throws FileNotFoundException, IOException {
        ArrayList<String> extraArgs = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Charset.defaultCharset()));){
            String arg0;
            while ((arg0 = in.readLine()) != null) {
                extraArgs.add(arg0);
            }
        }
        args.addAll(0, extraArgs);
    }

    private File replacePath(String arg, Pattern patDestFile, String prefix, String suffix) {
        Matcher m = patDestFile.matcher(arg);
        if (m.find()) {
            File oldFile = new File(m.group(2));
            File newFile = new File(oldFile.getParentFile(), prefix + UUID.randomUUID() + suffix);
            StringBuilder sb = new StringBuilder();
            sb.append(m.group(1));
            sb.append(newFile.toString());
            sb.append(m.group(3));
            this.onJavaOption(sb.toString());
            return newFile;
        }
        System.err.println("[WARNING] (ForkedVM) Code coverage may be incomplete for code only called from the forked VM");
        this.onJavaOption(arg);
        return null;
    }

    private void parseJacocoJavaAgent(String arg) {
        File newFile;
        Pattern patDestFile = Pattern.compile("^(.+?[=,]destfile=)([^,=]+)(.*?)$");
        if (arg.contains("jacoco") && (newFile = this.replacePath(arg, patDestFile, "jacoco-forked-", ".exec")) != null) {
            System.err.println("[INFO] (ForkedVM) Writing code coverage for forked process to " + newFile);
        } else {
            System.err.println("[WARNING] (ForkedVM) Code coverage may be incomplete for code only called from the forked VM");
            this.onJavaOption(arg);
        }
    }

    private void parseStartFlightRecording(String arg) {
        Pattern patDestFile = Pattern.compile("^(.+?[=,]filename=)([^,=]+)(.*?)$");
        File newFile = this.replacePath(arg, patDestFile, "jfr-forked-", ".jfr");
        if (newFile != null) {
            System.err.println("[INFO] (ForkedVM) Writing flight recording data to " + newFile);
        } else {
            this.onJavaOption(arg);
        }
    }

    protected void onJavaExecutable(String executable) {
        this.cmd.add(executable);
    }

    protected void onJavaOption(String option) {
        this.cmd.add(option);
    }

    protected void onJavaOption(String option, String arg) {
        if ("-jar".equals(option)) {
            option = "-cp";
        }
        this.cmd.add(option);
        this.cmd.add(arg);
    }

    protected boolean onJavaAgent(String option) {
        return false;
    }

    protected boolean onStartFlightRecording(String option) {
        return false;
    }

    protected void onJavaMainClass(String arg) {
        this.haveJavaMainClass = true;
        if (this.overrideMainClass != null) {
            arg = this.overrideMainClass;
        }
        if (arg != null) {
            this.cmd.add(arg);
        }
    }

    protected void onArguments(List<String> args) {
        this.haveArguments = true;
        if (this.overrideArgs != null) {
            args = Arrays.asList(this.overrideArgs);
        }
        this.cmd.addAll(args);
    }

    private static String unescapeJavaArg(String arg) {
        if (arg.length() > 1 && arg.endsWith("\"")) {
            if (arg.startsWith("\"")) {
                arg = arg.substring(1, arg.length() - 1);
            } else if (arg.contains("=\"")) {
                arg = arg.replace("=\"", "=");
                arg = arg.substring(0, arg.length() - 1);
            }
        }
        return arg;
    }

    public void setRedirectInput(ProcessBuilder.Redirect redirect) {
        this.redirectInput = redirect == null ? ProcessBuilder.Redirect.PIPE : redirect;
    }

    public void setRedirectOutput(ProcessBuilder.Redirect redirect) {
        this.redirectOutput = redirect == null ? ProcessBuilder.Redirect.PIPE : redirect;
    }

    public void setRedirectError(ProcessBuilder.Redirect redirect) {
        this.redirectError = redirect == null ? ProcessBuilder.Redirect.PIPE : redirect;
    }
}

