/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.testutil;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assumptions;
import org.opentest4j.TestAbortedException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SoftAssertions
implements Supplier<String> {
    private final List<AssertionError> errors = new ArrayList<AssertionError>();
    private final Supplier<String> supplier = new Supplier<String>(){

        @Override
        public String get() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (AssertionError err : SoftAssertions.this.errors) {
                if (first) {
                    first = false;
                } else {
                    sb.append("; ");
                }
                sb.append(((Throwable)((Object)err)).getMessage());
                sb.append('\n');
            }
            return sb.toString();
        }
    };

    public void fail(String message) {
        this.fail(new AssertionError((Object)message));
    }

    public void fail(String message, Throwable t) {
        this.fail(new AssertionError(message, t));
    }

    public void fail(AssertionError error) {
        this.errors.add(error);
    }

    public boolean checkPass() {
        return this.errors.isEmpty();
    }

    public Supplier<String> conciseErrorMessageSupplier() {
        return this.supplier;
    }

    public <T extends Throwable> T addAssertionThrowablesAsSuppressed(T t) {
        for (AssertionError err : this.errors) {
            t.addSuppressed((Throwable)((Object)err));
        }
        return t;
    }

    @Override
    public String get() {
        return this.conciseErrorMessageSupplier().get();
    }

    public void assumePass() {
        try {
            Assumptions.assumeTrue((boolean)this.checkPass(), (Supplier)this);
        }
        catch (TestAbortedException e) {
            throw this.addAssertionThrowablesAsSuppressed(e);
        }
    }
}

