/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.util;

import com.kohlschutter.annotations.compiletime.ExcludeFromCodeCoverageGeneratedReport;
import com.kohlschutter.util.JavaReleaseShim;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class IOUtil {
    @ExcludeFromCodeCoverageGeneratedReport
    private IOUtil() {
        throw new IllegalStateException("No instances");
    }

    public static byte[] readAllBytes(InputStream in) throws IOException {
        return JavaReleaseShim.readAllBytes(in);
    }

    public static byte[] readAllBytesNaively(InputStream in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtil.transferAllBytesNaively(in, bos);
        return bos.toByteArray();
    }

    public static long transferAllBytes(InputStream in, OutputStream out) throws IOException {
        return JavaReleaseShim.transferAllBytes(in, out);
    }

    public static long transferAllBytesNaively(InputStream in, OutputStream out) throws IOException {
        int read;
        long total = 0L;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) != -1) {
            total += (long)read;
            out.write(buf, 0, read);
        }
        return total;
    }

    public static void delete(File f) throws IOException {
        if (!f.delete() && f.exists()) {
            throw new IOException("Could not delete file: " + String.valueOf(f));
        }
    }
}

