/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.util;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SystemPropertyUtil {
    private SystemPropertyUtil() {
        throw new IllegalStateException("No instances");
    }

    public static int getIntSystemProperty(String key, int defaultValue) {
        String v = System.getProperty(key, null);
        if (v == null || v.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            if ("true".equalsIgnoreCase(v)) {
                return 1;
            }
            if ("false".equalsIgnoreCase(v)) {
                return 0;
            }
            return Integer.parseInt(v);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal value for system property " + key + ": " + v, e);
        }
    }

    public static boolean getBooleanSystemProperty(String key, boolean defaultValue) {
        String v = System.getProperty(key, null);
        if (v == null || v.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            if ("1".equals(v)) {
                return true;
            }
            if ("yes".equalsIgnoreCase(v)) {
                return true;
            }
            if ("y".equalsIgnoreCase(v)) {
                return true;
            }
            if ("on".equalsIgnoreCase(v)) {
                return true;
            }
            return Boolean.parseBoolean(v);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal value for system property " + key + ": " + v, e);
        }
    }
}

