/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ConsolePrintStream
extends PrintStream {
    private static final byte[] NEWLINE_BYTES;
    private static final int NEWLINE = 10;
    private static final boolean NO_CONSOLE;
    private static final boolean CLEAR_LINE_FIRST;
    private final PrintStream out;
    private final ConsoleFilterOut cfo;
    private boolean closed = false;

    private ConsolePrintStream() throws UnsupportedEncodingException {
        this(new ConsoleFilterOut(System.out));
    }

    private ConsolePrintStream(ConsoleFilterOut cfo) throws UnsupportedEncodingException {
        super((OutputStream)cfo, false, Charset.defaultCharset().name());
        this.cfo = cfo;
        this.out = System.out;
        System.setOut(this);
    }

    public static ConsolePrintStream wrapSystemOut() {
        Class<System> clazz = System.class;
        synchronized (System.class) {
            PrintStream out = System.out;
            if (out instanceof ConsolePrintStream) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return (ConsolePrintStream)out;
            }
            try {
                // ** MonitorExit[var0] (shouldn't be in output)
                return new ConsolePrintStream();
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void markPosition() {
        this.cfo.markPosition();
    }

    public boolean hasNewlineSinceMark() {
        return this.cfo.hasNewlineSinceMark();
    }

    public boolean hasOutputSinceMark() {
        return this.cfo.hasOutputSinceMark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String s) {
        ConsoleFilterOut consoleFilterOut = this.cfo;
        synchronized (consoleFilterOut) {
            this.flush();
            this.cfo.lastUpdate = 0;
            if (this.cfo.lastByte != 10) {
                if (NO_CONSOLE || this.hasNewlineSinceMark()) {
                    this.println();
                    this.print(s);
                } else if (CLEAR_LINE_FIRST) {
                    this.clearLine();
                    this.print(s);
                } else {
                    int numBytesSinceNewline = this.cfo.numBytes - this.cfo.lastNewline;
                    int toClear = numBytesSinceNewline - s.length();
                    this.print('\r');
                    this.cfo.lastNewline = this.cfo.numBytes;
                    this.print(s);
                    this.clearToEndOfLine(toClear);
                }
            } else {
                this.print(s);
            }
            this.flush();
            this.markPosition();
            this.cfo.lastUpdate = this.cfo.numBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateln(String s) {
        ConsoleFilterOut consoleFilterOut = this.cfo;
        synchronized (consoleFilterOut) {
            this.update(s);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLine() {
        ConsoleFilterOut consoleFilterOut = this.cfo;
        synchronized (consoleFilterOut) {
            this.flush();
            int numBytesSinceNewline = this.cfo.numBytes - this.cfo.lastNewline;
            if (numBytesSinceNewline == 0) {
                return;
            }
            StringBuilder sb = new StringBuilder(numBytesSinceNewline * 3 + 1);
            for (int i = 0; i < numBytesSinceNewline; ++i) {
                sb.append("\b \b");
            }
            sb.append('\r');
            this.out.print(sb);
            this.out.flush();
            this.cfo.lastNewline = this.cfo.numBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearToEndOfLine(int toClear) {
        if (toClear <= 0) {
            return;
        }
        ConsoleFilterOut consoleFilterOut = this.cfo;
        synchronized (consoleFilterOut) {
            int i;
            StringBuilder sb = new StringBuilder(toClear * 2);
            for (i = 0; i < toClear; ++i) {
                sb.append(' ');
            }
            for (i = 0; i < toClear; ++i) {
                sb.append('\b');
            }
            this.out.print(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ConsoleFilterOut consoleFilterOut = this.cfo;
        synchronized (consoleFilterOut) {
            this.flush();
            if (this.closed) {
                return;
            }
            this.closed = true;
            System.setOut(this.out);
        }
    }

    public static boolean hasConsole() {
        return !NO_CONSOLE;
    }

    public static boolean isClearLineFirst() {
        return CLEAR_LINE_FIRST;
    }

    static {
        String serviceName;
        NEWLINE_BYTES = System.lineSeparator().getBytes(Charset.defaultCharset());
        String forceConsole = System.getProperty("com.kohlschutter.util.console", "");
        NO_CONSOLE = !forceConsole.isEmpty() ? Boolean.valueOf(forceConsole) == false : (System.console() != null ? "z/OS".equals(System.getProperty("os.name")) : (serviceName = System.getenv("XPC_SERVICE_NAME")) == null || !serviceName.endsWith(".eclipse"));
        boolean isWindows = "\\".equals(System.getProperty("file.separator", ""));
        String clf = System.getProperty("com.kohlschutter.util.console.clear-line-first", "");
        CLEAR_LINE_FIRST = !clf.isEmpty() ? Boolean.valueOf(clf) : isWindows;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class ConsoleFilterOut
    extends FilterOutputStream {
        private int numBytes = 0;
        private int lastNewline = 0;
        private int markedPosition = 0;
        private int lastUpdate = 0;
        private int lastByte = 0;

        ConsoleFilterOut(PrintStream out) {
            super(out);
        }

        @Override
        public synchronized void write(int b) throws IOException {
            boolean newline;
            boolean bl = newline = b == 10;
            if (!newline && this.lastUpdate == this.numBytes && this.numBytes > 0) {
                this.lastUpdate = 0;
                this.write(NEWLINE_BYTES);
            }
            super.write(b);
            this.lastByte = b;
            int count = ++this.numBytes;
            if (newline) {
                this.lastNewline = count;
            }
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return;
            }
            if (b[off] != 10 && this.lastUpdate == this.numBytes && this.numBytes > 0) {
                this.lastUpdate = 0;
                this.write(NEWLINE_BYTES);
            }
            super.write(b, off, len);
            this.lastByte = b[off + len - 1];
            int countPre = this.numBytes;
            this.numBytes += len;
            for (int i = len - 1; i >= off; --i) {
                if (b[i] != 10) continue;
                this.lastNewline = countPre + (i - off + 1);
            }
        }

        synchronized void markPosition() {
            this.markedPosition = this.numBytes;
        }

        synchronized boolean hasNewlineSinceMark() {
            return this.lastNewline > this.markedPosition;
        }

        synchronized boolean hasOutputSinceMark() {
            return this.numBytes > this.markedPosition;
        }
    }
}

