/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashByteByteMap}s.
 *
 * @see HashByteByteMap
 * @see HashByteByteMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashByteByteMapFactory
        extends ByteByteMapFactory<HashByteByteMapFactory>
        , ByteHashFactory<HashByteByteMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashByteByteMap newMutableMap();

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteByteMap newMutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3,
            @Nonnull Map<Byte, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3,
            @Nonnull Map<Byte, Byte> map4,
            @Nonnull Map<Byte, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteByteMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(
            @Nonnull Map<Byte, Byte> map);

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2);

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3);

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3,
            @Nonnull Map<Byte, Byte> map4);

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3,
            @Nonnull Map<Byte, Byte> map4,
            @Nonnull Map<Byte, Byte> map5);



    @Override
    @Nonnull
     HashByteByteMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(
            @Nonnull byte[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(
            @Nonnull Byte[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashByteByteMap newMutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashByteByteMap newMutableMapOf(byte k1, byte v1);

    @Override
    @Nonnull
     HashByteByteMap newMutableMapOf(byte k1, byte v1,
            byte k2, byte v2);

    @Override
    @Nonnull
     HashByteByteMap newMutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3);

    @Override
    @Nonnull
     HashByteByteMap newMutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4);

    @Override
    @Nonnull
     HashByteByteMap newMutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4, byte k5, byte v5);
    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap();

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3,
            @Nonnull Map<Byte, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3,
            @Nonnull Map<Byte, Byte> map4,
            @Nonnull Map<Byte, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ByteByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(
            @Nonnull Map<Byte, Byte> map);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3,
            @Nonnull Map<Byte, Byte> map4);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3,
            @Nonnull Map<Byte, Byte> map4,
            @Nonnull Map<Byte, Byte> map5);



    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ByteByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(
            @Nonnull byte[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(
            @Nonnull Byte[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashByteByteMap newUpdatableMapOf(byte k1, byte v1);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMapOf(byte k1, byte v1,
            byte k2, byte v2);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4);

    @Override
    @Nonnull
     HashByteByteMap newUpdatableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4, byte k5, byte v5);

    


    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3,
            @Nonnull Map<Byte, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3,
            @Nonnull Map<Byte, Byte> map4,
            @Nonnull Map<Byte, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(
            @Nonnull Map<Byte, Byte> map);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3,
            @Nonnull Map<Byte, Byte> map4);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(@Nonnull Map<Byte, Byte> map1,
            @Nonnull Map<Byte, Byte> map2,
            @Nonnull Map<Byte, Byte> map3,
            @Nonnull Map<Byte, Byte> map4,
            @Nonnull Map<Byte, Byte> map5);



    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ByteByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(
            @Nonnull byte[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(
            @Nonnull Byte[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMap(@Nonnull Iterable<Byte> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashByteByteMap newImmutableMapOf(byte k1, byte v1);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMapOf(byte k1, byte v1,
            byte k2, byte v2);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4);

    @Override
    @Nonnull
     HashByteByteMap newImmutableMapOf(byte k1, byte v1,
            byte k2, byte v2, byte k3, byte v3,
            byte k4, byte v4, byte k5, byte v5);
}
