/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashDoubleIntMap}s.
 *
 * @see HashDoubleIntMap
 * @see HashDoubleIntMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashDoubleIntMapFactory
        extends DoubleIntMapFactory<HashDoubleIntMapFactory>
        , HashContainerFactory<HashDoubleIntMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap();

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3,
            @Nonnull Map<Double, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3,
            @Nonnull Map<Double, Integer> map4,
            @Nonnull Map<Double, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(
            @Nonnull double[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(
            @Nonnull Map<Double, Integer> map);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3,
            @Nonnull Map<Double, Integer> map4);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3,
            @Nonnull Map<Double, Integer> map4,
            @Nonnull Map<Double, Integer> map5);



    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(
            @Nonnull double[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashDoubleIntMap newMutableMapOf(double k1, int v1);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMapOf(double k1, int v1,
            double k2, int v2);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4);

    @Override
    @Nonnull
     HashDoubleIntMap newMutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4, double k5, int v5);
    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap();

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3,
            @Nonnull Map<Double, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3,
            @Nonnull Map<Double, Integer> map4,
            @Nonnull Map<Double, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(
            @Nonnull Map<Double, Integer> map);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3,
            @Nonnull Map<Double, Integer> map4);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3,
            @Nonnull Map<Double, Integer> map4,
            @Nonnull Map<Double, Integer> map5);



    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMapOf(double k1, int v1);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMapOf(double k1, int v1,
            double k2, int v2);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4);

    @Override
    @Nonnull
     HashDoubleIntMap newUpdatableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4, double k5, int v5);

    


    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3,
            @Nonnull Map<Double, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3,
            @Nonnull Map<Double, Integer> map4,
            @Nonnull Map<Double, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(
            @Nonnull Map<Double, Integer> map);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3,
            @Nonnull Map<Double, Integer> map4);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(@Nonnull Map<Double, Integer> map1,
            @Nonnull Map<Double, Integer> map2,
            @Nonnull Map<Double, Integer> map3,
            @Nonnull Map<Double, Integer> map4,
            @Nonnull Map<Double, Integer> map5);



    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMapOf(double k1, int v1);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMapOf(double k1, int v1,
            double k2, int v2);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4);

    @Override
    @Nonnull
     HashDoubleIntMap newImmutableMapOf(double k1, int v1,
            double k2, int v2, double k3, int v3,
            double k4, int v4, double k5, int v5);
}
