/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashFloatIntMap}s.
 *
 * @see HashFloatIntMap
 * @see HashFloatIntMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashFloatIntMapFactory
        extends FloatIntMapFactory<HashFloatIntMapFactory>
        , HashContainerFactory<HashFloatIntMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashFloatIntMap newMutableMap();

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3,
            @Nonnull Map<Float, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3,
            @Nonnull Map<Float, Integer> map4,
            @Nonnull Map<Float, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(
            @Nonnull float[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(
            @Nonnull Map<Float, Integer> map);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3,
            @Nonnull Map<Float, Integer> map4);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3,
            @Nonnull Map<Float, Integer> map4,
            @Nonnull Map<Float, Integer> map5);



    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(
            @Nonnull float[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashFloatIntMap newMutableMapOf(float k1, int v1);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMapOf(float k1, int v1,
            float k2, int v2);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4);

    @Override
    @Nonnull
     HashFloatIntMap newMutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4, float k5, int v5);
    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap();

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3,
            @Nonnull Map<Float, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3,
            @Nonnull Map<Float, Integer> map4,
            @Nonnull Map<Float, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.FloatIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(
            @Nonnull Map<Float, Integer> map);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3,
            @Nonnull Map<Float, Integer> map4);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3,
            @Nonnull Map<Float, Integer> map4,
            @Nonnull Map<Float, Integer> map5);



    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.FloatIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMapOf(float k1, int v1);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMapOf(float k1, int v1,
            float k2, int v2);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4);

    @Override
    @Nonnull
     HashFloatIntMap newUpdatableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4, float k5, int v5);

    


    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3,
            @Nonnull Map<Float, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3,
            @Nonnull Map<Float, Integer> map4,
            @Nonnull Map<Float, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(
            @Nonnull Map<Float, Integer> map);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3,
            @Nonnull Map<Float, Integer> map4);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(@Nonnull Map<Float, Integer> map1,
            @Nonnull Map<Float, Integer> map2,
            @Nonnull Map<Float, Integer> map3,
            @Nonnull Map<Float, Integer> map4,
            @Nonnull Map<Float, Integer> map5);



    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashFloatIntMap newImmutableMapOf(float k1, int v1);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMapOf(float k1, int v1,
            float k2, int v2);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4);

    @Override
    @Nonnull
     HashFloatIntMap newImmutableMapOf(float k1, int v1,
            float k2, int v2, float k3, int v3,
            float k4, int v4, float k5, int v5);
}
