/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashFloatShortMap}s.
 *
 * @see HashFloatShortMap
 * @see HashFloatShortMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashFloatShortMapFactory
        extends FloatShortMapFactory<HashFloatShortMapFactory>
        , HashContainerFactory<HashFloatShortMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashFloatShortMap newMutableMap();

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3,
            @Nonnull Map<Float, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3,
            @Nonnull Map<Float, Short> map4,
            @Nonnull Map<Float, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(
            @Nonnull float[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(
            @Nonnull Map<Float, Short> map);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3,
            @Nonnull Map<Float, Short> map4);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3,
            @Nonnull Map<Float, Short> map4,
            @Nonnull Map<Float, Short> map5);



    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(
            @Nonnull float[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(
            @Nonnull Float[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashFloatShortMap newMutableMapOf(float k1, short v1);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMapOf(float k1, short v1,
            float k2, short v2);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4);

    @Override
    @Nonnull
     HashFloatShortMap newMutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4, float k5, short v5);
    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap();

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3,
            @Nonnull Map<Float, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3,
            @Nonnull Map<Float, Short> map4,
            @Nonnull Map<Float, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.FloatShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(
            @Nonnull Map<Float, Short> map);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3,
            @Nonnull Map<Float, Short> map4);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3,
            @Nonnull Map<Float, Short> map4,
            @Nonnull Map<Float, Short> map5);



    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.FloatShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(
            @Nonnull float[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMapOf(float k1, short v1);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMapOf(float k1, short v1,
            float k2, short v2);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4);

    @Override
    @Nonnull
     HashFloatShortMap newUpdatableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4, float k5, short v5);

    


    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3,
            @Nonnull Map<Float, Short> map4, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3,
            @Nonnull Map<Float, Short> map4,
            @Nonnull Map<Float, Short> map5, int expectedSize);



    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatShortConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull short[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Short[] values, int expectedSize);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Short> values, int expectedSize);

    

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(
            @Nonnull Map<Float, Short> map);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3,
            @Nonnull Map<Float, Short> map4);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(@Nonnull Map<Float, Short> map1,
            @Nonnull Map<Float, Short> map2,
            @Nonnull Map<Float, Short> map3,
            @Nonnull Map<Float, Short> map4,
            @Nonnull Map<Float, Short> map5);



    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatShortConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(
            @Nonnull float[] keys, @Nonnull short[] values);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(
            @Nonnull Float[] keys, @Nonnull Short[] values);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<Short> values);


    @Override
    @Nonnull
     HashFloatShortMap newImmutableMapOf(float k1, short v1);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMapOf(float k1, short v1,
            float k2, short v2);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4);

    @Override
    @Nonnull
     HashFloatShortMap newImmutableMapOf(float k1, short v1,
            float k2, short v2, float k3, short v3,
            float k4, short v4, float k5, short v5);
}
