/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashIntObjMap}s.
 *
 * @see HashIntObjMap
 * @see HashIntObjMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashIntObjMapFactory<V>
        extends IntObjMapFactory<V, HashIntObjMapFactory<V>>
        , IntHashFactory<HashIntObjMapFactory<V>>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap();

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3,
            @Nonnull Map<Integer, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3,
            @Nonnull Map<Integer, ? extends V2> map4,
            @Nonnull Map<Integer, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(@Nonnull
            Consumer<com.koloboke.function.IntObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(
            @Nonnull int[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(
            @Nonnull Integer[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(
            @Nonnull Map<Integer, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3,
            @Nonnull Map<Integer, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3,
            @Nonnull Map<Integer, ? extends V2> map4,
            @Nonnull Map<Integer, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(@Nonnull
            Consumer<com.koloboke.function.IntObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(
            @Nonnull int[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(
            @Nonnull Integer[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMapOf(int k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMapOf(int k1, V2 v1,
            int k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3,
            int k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newMutableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3,
            int k4, V2 v4, int k5, V2 v5);
    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap();

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3,
            @Nonnull Map<Integer, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3,
            @Nonnull Map<Integer, ? extends V2> map4,
            @Nonnull Map<Integer, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.IntObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(
            @Nonnull int[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(
            @Nonnull Map<Integer, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3,
            @Nonnull Map<Integer, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3,
            @Nonnull Map<Integer, ? extends V2> map4,
            @Nonnull Map<Integer, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.IntObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(
            @Nonnull int[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMapOf(int k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMapOf(int k1, V2 v1,
            int k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3,
            int k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newUpdatableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3,
            int k4, V2 v4, int k5, V2 v5);

    


    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3,
            @Nonnull Map<Integer, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3,
            @Nonnull Map<Integer, ? extends V2> map4,
            @Nonnull Map<Integer, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.IntObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(
            @Nonnull int[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(
            @Nonnull Map<Integer, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3,
            @Nonnull Map<Integer, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(@Nonnull Map<Integer, ? extends V2> map1,
            @Nonnull Map<Integer, ? extends V2> map2,
            @Nonnull Map<Integer, ? extends V2> map3,
            @Nonnull Map<Integer, ? extends V2> map4,
            @Nonnull Map<Integer, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.IntObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(
            @Nonnull int[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMapOf(int k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMapOf(int k1, V2 v1,
            int k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3,
            int k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashIntObjMap<V2> newImmutableMapOf(int k1, V2 v1,
            int k2, V2 v2, int k3, V2 v3,
            int k4, V2 v4, int k5, V2 v5);
}
