/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashLongByteMap}s.
 *
 * @see HashLongByteMap
 * @see HashLongByteMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashLongByteMapFactory
        extends LongByteMapFactory<HashLongByteMapFactory>
        , LongHashFactory<HashLongByteMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashLongByteMap newMutableMap();

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongByteMap newMutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3,
            @Nonnull Map<Long, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3,
            @Nonnull Map<Long, Byte> map4,
            @Nonnull Map<Long, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongByteMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.LongByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(
            @Nonnull long[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(
            @Nonnull Map<Long, Byte> map);

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2);

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3);

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3,
            @Nonnull Map<Long, Byte> map4);

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3,
            @Nonnull Map<Long, Byte> map4,
            @Nonnull Map<Long, Byte> map5);



    @Override
    @Nonnull
     HashLongByteMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.LongByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(
            @Nonnull long[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashLongByteMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashLongByteMap newMutableMapOf(long k1, byte v1);

    @Override
    @Nonnull
     HashLongByteMap newMutableMapOf(long k1, byte v1,
            long k2, byte v2);

    @Override
    @Nonnull
     HashLongByteMap newMutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3);

    @Override
    @Nonnull
     HashLongByteMap newMutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4);

    @Override
    @Nonnull
     HashLongByteMap newMutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4, long k5, byte v5);
    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap();

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3,
            @Nonnull Map<Long, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3,
            @Nonnull Map<Long, Byte> map4,
            @Nonnull Map<Long, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.LongByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(
            @Nonnull Map<Long, Byte> map);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3,
            @Nonnull Map<Long, Byte> map4);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3,
            @Nonnull Map<Long, Byte> map4,
            @Nonnull Map<Long, Byte> map5);



    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.LongByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashLongByteMap newUpdatableMapOf(long k1, byte v1);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMapOf(long k1, byte v1,
            long k2, byte v2);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4);

    @Override
    @Nonnull
     HashLongByteMap newUpdatableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4, long k5, byte v5);

    


    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3,
            @Nonnull Map<Long, Byte> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3,
            @Nonnull Map<Long, Byte> map4,
            @Nonnull Map<Long, Byte> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.LongByteConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Byte[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Byte> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(
            @Nonnull Map<Long, Byte> map);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3,
            @Nonnull Map<Long, Byte> map4);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(@Nonnull Map<Long, Byte> map1,
            @Nonnull Map<Long, Byte> map2,
            @Nonnull Map<Long, Byte> map3,
            @Nonnull Map<Long, Byte> map4,
            @Nonnull Map<Long, Byte> map5);



    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.LongByteConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull byte[] values);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Byte[] values);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Byte> values);


    @Override
    @Nonnull
     HashLongByteMap newImmutableMapOf(long k1, byte v1);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMapOf(long k1, byte v1,
            long k2, byte v2);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4);

    @Override
    @Nonnull
     HashLongByteMap newImmutableMapOf(long k1, byte v1,
            long k2, byte v2, long k3, byte v3,
            long k4, byte v4, long k5, byte v5);
}
