/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashObjCharMap}s.
 *
 * @see HashObjCharMap
 * @see HashObjCharMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashObjCharMapFactory<K>
        extends ObjCharMapFactory<K, HashObjCharMapFactory<K>>
        , ObjHashFactory<HashObjCharMapFactory<K>>
        {

    /**
     * {@inheritDoc} Defaults to {@link Equivalence#defaultEquality()}.
     */
    @Override
    @Nonnull Equivalence<K> getKeyEquivalence();

    

    

    

    

    

    
    

    
    

    /**
     * Returns a copy of this factory, with exception that it constructs maps with
     * {@linkplain HashObjCharMap#keyEquivalence() key equivalence} set to the given
     * {@code Equivalence}.
     *
     * <p>The Koloboke Compile's counterpart of this configuration is the {@link
     * CustomKeyEquivalence @CustomKeyEquivalence} annotation.
     *
     * @param keyEquivalence the new key equivalence
     * @return a copy of this factory, which constructs maps with the given {@code keyEquivalence}
     */
    @Nonnull
    HashObjCharMapFactory<K>
    withKeyEquivalence(@Nonnull Equivalence<? super K> keyEquivalence);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap();

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(int expectedSize);

    

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(
            @Nonnull Map<? extends K2, Character> map, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3,
            @Nonnull Map<? extends K2, Character> map4, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3,
            @Nonnull Map<? extends K2, Character> map4,
            @Nonnull Map<? extends K2, Character> map5, int expectedSize);



    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ObjCharConsumer<K2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(
            @Nonnull K2[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(
            @Nonnull K2[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(@Nonnull Iterable<? extends K2> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(
            @Nonnull Map<? extends K2, Character> map);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3,
            @Nonnull Map<? extends K2, Character> map4);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3,
            @Nonnull Map<? extends K2, Character> map4,
            @Nonnull Map<? extends K2, Character> map5);



    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ObjCharConsumer<K2>> entriesSupplier
            );

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(
            @Nonnull K2[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(
            @Nonnull K2[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMap(@Nonnull Iterable<? extends K2> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMapOf(K2 k1, char v1);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMapOf(K2 k1, char v1,
            K2 k2, char v2);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMapOf(K2 k1, char v1,
            K2 k2, char v2, K2 k3, char v3);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMapOf(K2 k1, char v1,
            K2 k2, char v2, K2 k3, char v3,
            K2 k4, char v4);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newMutableMapOf(K2 k1, char v1,
            K2 k2, char v2, K2 k3, char v3,
            K2 k4, char v4, K2 k5, char v5);
    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap();

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(int expectedSize);

    

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(
            @Nonnull Map<? extends K2, Character> map, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3,
            @Nonnull Map<? extends K2, Character> map4, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3,
            @Nonnull Map<? extends K2, Character> map4,
            @Nonnull Map<? extends K2, Character> map5, int expectedSize);



    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ObjCharConsumer<K2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(
            @Nonnull K2[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(
            @Nonnull K2[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(@Nonnull Iterable<? extends K2> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(
            @Nonnull Map<? extends K2, Character> map);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3,
            @Nonnull Map<? extends K2, Character> map4);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3,
            @Nonnull Map<? extends K2, Character> map4,
            @Nonnull Map<? extends K2, Character> map5);



    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ObjCharConsumer<K2>> entriesSupplier
            );

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(
            @Nonnull K2[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(
            @Nonnull K2[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMap(@Nonnull Iterable<? extends K2> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMapOf(K2 k1, char v1);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMapOf(K2 k1, char v1,
            K2 k2, char v2);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMapOf(K2 k1, char v1,
            K2 k2, char v2, K2 k3, char v3);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMapOf(K2 k1, char v1,
            K2 k2, char v2, K2 k3, char v3,
            K2 k4, char v4);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newUpdatableMapOf(K2 k1, char v1,
            K2 k2, char v2, K2 k3, char v3,
            K2 k4, char v4, K2 k5, char v5);

    

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(
            @Nonnull Map<? extends K2, Character> map, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3,
            @Nonnull Map<? extends K2, Character> map4, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3,
            @Nonnull Map<? extends K2, Character> map4,
            @Nonnull Map<? extends K2, Character> map5, int expectedSize);



    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ObjCharConsumer<K2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(
            @Nonnull K2[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(
            @Nonnull K2[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(@Nonnull Iterable<? extends K2> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(
            @Nonnull Map<? extends K2, Character> map);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3,
            @Nonnull Map<? extends K2, Character> map4);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(@Nonnull Map<? extends K2, Character> map1,
            @Nonnull Map<? extends K2, Character> map2,
            @Nonnull Map<? extends K2, Character> map3,
            @Nonnull Map<? extends K2, Character> map4,
            @Nonnull Map<? extends K2, Character> map5);



    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ObjCharConsumer<K2>> entriesSupplier
            );

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(
            @Nonnull K2[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(
            @Nonnull K2[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMap(@Nonnull Iterable<? extends K2> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMapOf(K2 k1, char v1);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMapOf(K2 k1, char v1,
            K2 k2, char v2);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMapOf(K2 k1, char v1,
            K2 k2, char v2, K2 k3, char v3);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMapOf(K2 k1, char v1,
            K2 k2, char v2, K2 k3, char v3,
            K2 k4, char v4);

    @Override
    @Nonnull
    <K2 extends K>
     HashObjCharMap<K2> newImmutableMapOf(K2 k1, char v1,
            K2 k2, char v2, K2 k3, char v3,
            K2 k4, char v4, K2 k5, char v5);
}
