/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashShortFloatMap}s.
 *
 * @see HashShortFloatMap
 * @see HashShortFloatMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashShortFloatMapFactory
        extends ShortFloatMapFactory<HashShortFloatMapFactory>
        , ShortHashFactory<HashShortFloatMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashShortFloatMap newMutableMap();

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3,
            @Nonnull Map<Short, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3,
            @Nonnull Map<Short, Float> map4,
            @Nonnull Map<Short, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ShortFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(
            @Nonnull short[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(
            @Nonnull Map<Short, Float> map);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3,
            @Nonnull Map<Short, Float> map4);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3,
            @Nonnull Map<Short, Float> map4,
            @Nonnull Map<Short, Float> map5);



    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.ShortFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(
            @Nonnull short[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(
            @Nonnull Short[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashShortFloatMap newMutableMapOf(short k1, float v1);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMapOf(short k1, float v1,
            short k2, float v2);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4);

    @Override
    @Nonnull
     HashShortFloatMap newMutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4, short k5, float v5);
    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap();

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3,
            @Nonnull Map<Short, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3,
            @Nonnull Map<Short, Float> map4,
            @Nonnull Map<Short, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ShortFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(
            @Nonnull Map<Short, Float> map);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3,
            @Nonnull Map<Short, Float> map4);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3,
            @Nonnull Map<Short, Float> map4,
            @Nonnull Map<Short, Float> map5);



    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.ShortFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(
            @Nonnull short[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(
            @Nonnull Short[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMapOf(short k1, float v1);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMapOf(short k1, float v1,
            short k2, float v2);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4);

    @Override
    @Nonnull
     HashShortFloatMap newUpdatableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4, short k5, float v5);

    


    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3,
            @Nonnull Map<Short, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3,
            @Nonnull Map<Short, Float> map4,
            @Nonnull Map<Short, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ShortFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(
            @Nonnull Map<Short, Float> map);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3,
            @Nonnull Map<Short, Float> map4);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(@Nonnull Map<Short, Float> map1,
            @Nonnull Map<Short, Float> map2,
            @Nonnull Map<Short, Float> map3,
            @Nonnull Map<Short, Float> map4,
            @Nonnull Map<Short, Float> map5);



    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.ShortFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(
            @Nonnull short[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(
            @Nonnull Short[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMap(@Nonnull Iterable<Short> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashShortFloatMap newImmutableMapOf(short k1, float v1);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMapOf(short k1, float v1,
            short k2, float v2);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4);

    @Override
    @Nonnull
     HashShortFloatMap newImmutableMapOf(short k1, float v1,
            short k2, float v2, short k3, float v3,
            short k4, float v4, short k5, float v5);
}
