/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.IntCollection;
import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalIntCollectionOps;
import com.koloboke.collect.set.IntSet;
import java.util.Collection;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;

public final class CommonIntCollectionOps {
    public static boolean containsAll(final IntCollection collection, Collection<?> another) {
        if (collection == another) {
            return true;
        }
        if (another instanceof IntCollection) {
            IntCollection c2 = (IntCollection)another;
            if (collection instanceof IntSet && c2 instanceof IntSet && collection.size() < another.size()) {
                return false;
            }
            if (c2 instanceof InternalIntCollectionOps) {
                return ((InternalIntCollectionOps)c2).allContainingIn(collection);
            }
            return c2.forEachWhile(new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return collection.contains(value);
                }
            });
        }
        for (Object o : another) {
            if (collection.contains(((Integer)o).intValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean addAll(IntCollection collection, Collection<? extends Integer> another) {
        if (collection == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = collection.sizeAsLong() + Containers.sizeAsLong(another);
        collection.ensureCapacity(maxPossibleSize);
        if (another instanceof IntCollection) {
            if (another instanceof InternalIntCollectionOps) {
                return ((InternalIntCollectionOps)((Object)another)).reverseAddAllTo(collection);
            }
            class AddAll
            implements IntConsumer {
                boolean collectionChanged = false;
                final /* synthetic */ IntCollection val$collection;

                AddAll(IntCollection intCollection) {
                    this.val$collection = intCollection;
                }

                @Override
                public void accept(int value) {
                    this.collectionChanged |= this.val$collection.add(value);
                }
            }
            AddAll addAll = new AddAll(collection);
            ((IntCollection)another).forEach((IntConsumer)addAll);
            return addAll.collectionChanged;
        }
        boolean collectionChanged = false;
        for (Integer n : another) {
            collectionChanged |= collection.add(n.intValue());
        }
        return collectionChanged;
    }

    private CommonIntCollectionOps() {
    }
}

