/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalObjByteMapOps;
import com.koloboke.collect.map.ObjByteMap;
import com.koloboke.function.ObjByteConsumer;
import com.koloboke.function.ObjBytePredicate;
import java.util.Map;

public final class CommonObjByteMapOps {
    public static boolean containsAllEntries(final InternalObjByteMapOps<?> map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ObjByteMap) {
            ObjByteMap m2 = (ObjByteMap)another;
            if (m2.keyEquivalence().equals((Object)map.keyEquivalence())) {
                if (map.size() < m2.size()) {
                    return false;
                }
                if (m2 instanceof InternalObjByteMapOps) {
                    return ((InternalObjByteMapOps)m2).allEntriesContainingIn(map);
                }
            }
            return m2.forEachWhile(new ObjBytePredicate(){

                public boolean test(Object a, byte b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(e.getKey(), (Byte)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static <K> void putAll(final InternalObjByteMapOps<K> map, Map<? extends K, ? extends Byte> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ObjByteMap) {
            if (another instanceof InternalObjByteMapOps) {
                ((InternalObjByteMapOps)another).reversePutAllTo(map);
            } else {
                ((ObjByteMap)another).forEach(new ObjByteConsumer<K>(){

                    public void accept(K key, byte value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<K, Byte> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonObjByteMapOps() {
    }
}

