/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalShortShortMapOps;
import com.koloboke.collect.map.ShortShortMap;
import com.koloboke.function.ShortShortConsumer;
import com.koloboke.function.ShortShortPredicate;
import java.util.Map;

public final class CommonShortShortMapOps {
    public static boolean containsAllEntries(final InternalShortShortMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof ShortShortMap) {
            ShortShortMap m2 = (ShortShortMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalShortShortMapOps) {
                return ((InternalShortShortMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new ShortShortPredicate(){

                public boolean test(short a, short b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Short)e.getKey(), (Short)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalShortShortMapOps map, Map<? extends Short, ? extends Short> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof ShortShortMap) {
            if (another instanceof InternalShortShortMapOps) {
                ((InternalShortShortMapOps)another).reversePutAllTo(map);
            } else {
                ((ShortShortMap)another).forEach(new ShortShortConsumer(){

                    public void accept(short key, short value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Short, ? extends Short> e : another.entrySet()) {
                map.justPut(e.getKey(), e.getValue());
            }
        }
    }

    private CommonShortShortMapOps() {
    }
}

