/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractObjValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.CommonObjObjMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.InternalObjObjMapOps;
import com.koloboke.collect.impl.hash.ImmutableQHashParallelKVObjObjMapSO;
import com.koloboke.collect.impl.hash.ObjHash;
import com.koloboke.collect.impl.hash.ParallelKVObjObjQHash;
import com.koloboke.collect.map.ObjObjCursor;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableQHashParallelKVObjObjMapGO<K, V>
extends ImmutableQHashParallelKVObjObjMapSO<K, V> {
    final void copy(ParallelKVObjObjQHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVObjObjQHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public Equivalence<V> valueEquivalence() {
        return Equivalence.defaultEquality();
    }

    public boolean containsEntry(Object key, Object value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.nullableValueEquals(this.table[index + 1], value);
        }
        return false;
    }

    public V get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.table[index + 1];
        }
        return null;
    }

    public V getOrDefault(Object key, V defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.table[index + 1];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == FREE) continue;
            action.accept(key, tab[i + 1]);
        }
    }

    public boolean forEachWhile(BiPredicate<? super K, ? super V> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == FREE || predicate.test(key, tab[i + 1])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ObjObjCursor<K, V> cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjObjMapOps.containsAllEntries((InternalObjObjMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalObjObjMapOps<?, ?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == FREE || m.containsEntry(key, tab[i + 1])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalObjObjMapOps<? super K, ? super V> m) {
        if (this.isEmpty()) {
            return;
        }
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == FREE) continue;
            m.justPut(key, tab[i + 1]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<K, V>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ObjCollection<V> values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == FREE) continue;
            hashCode += this.nullableKeyHashCode(key) ^ this.nullableValueHashCode(tab[i + 1]);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        Object[] tab = this.table;
        for (int i = tab.length - 2; i >= 0; i -= 2) {
            Object key = tab[i];
            if (key == FREE) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            Object val = tab[i + 1];
            sb.append(val != this ? val : "(this Map)");
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    public V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(K key, V value) {
        throw new UnsupportedOperationException();
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    V computeNullKey(BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    V computeIfAbsentNullKey(Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    V mergeNullKey(V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        CommonObjObjMapOps.putAll((InternalObjObjMapOps)this, m);
    }

    public V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    V removeNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(Object key) {
        throw new UnsupportedOperationException();
    }

    boolean justRemoveNullKey() {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    boolean removeEntryNullKey(Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(BiPredicate<? super K, ? super V> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ObjObjCursor<K, V> {
        final Object[] tab;
        int index;
        Object curKey;
        V curValue;

        NoRemovedMapCursor() {
            this.tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(BiConsumer<? super K, ? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, tab[i + 1]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey == ObjHash.FREE) {
                throw new IllegalStateException();
            }
            this.tab[this.index + 1] = value;
        }

        public boolean moveNext() {
            Object[] tab = this.tab;
            for (int i = this.index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = tab[i + 1];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ObjCursor<V> {
        final Object[] tab;
        int index;
        Object curKey;
        V curValue;

        NoRemovedValueCursor() {
            this.tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                if (tab[i] == ObjHash.FREE) continue;
                action.accept(tab[i + 1]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public V elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            Object[] tab = this.tab;
            for (int i = this.index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = tab[i + 1];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ObjIterator<V> {
        final Object[] tab;
        int nextIndex;
        V next;

        NoRemovedValueIterator() {
            this.tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                if (tab[nextI] == ObjHash.FREE) continue;
                this.next = tab[nextI + 1];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                if (tab[i] == ObjHash.FREE) continue;
                action.accept(tab[i + 1]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                Object[] tab = this.tab;
                Object prev = this.next;
                while ((nextI -= 2) >= 0) {
                    if (tab[nextI] == ObjHash.FREE) continue;
                    this.next = tab[nextI + 1];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, V>> {
        final Object[] tab;
        int index;
        Object curKey;
        V curValue;

        NoRemovedEntryCursor() {
            this.tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] tab = this.tab;
            int index = this.index;
            for (int i = index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, tab[i + 1])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, V> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            Object[] tab = this.tab;
            for (int i = this.index - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = tab[i + 1];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, V>> {
        final Object[] tab;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            int nextI = tab.length;
            while ((nextI -= 2) >= 0) {
                Object key = tab[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new ImmutableEntry(key, tab[nextI + 1]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, tab[i + 1])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, V> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                Object[] tab = this.tab;
                ImmutableEntry prev = this.next;
                while ((nextI -= 2) >= 0) {
                    Object key = tab[nextI];
                    if (key == ObjHash.FREE) continue;
                    this.next = new ImmutableEntry(key, tab[nextI + 1]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractObjValueView<V> {
        ValueView() {
        }

        public Equivalence<V> equivalence() {
            return ImmutableQHashParallelKVObjObjMapGO.this.valueEquivalence();
        }

        public int size() {
            return ImmutableQHashParallelKVObjObjMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashParallelKVObjObjMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableQHashParallelKVObjObjMapGO.this.containsValue(o);
        }

        public void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == ObjHash.FREE) continue;
                action.accept(tab[i + 1]);
            }
        }

        public boolean forEachWhile(Predicate<? super V> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == ObjHash.FREE || predicate.test(tab[i + 1])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == ObjHash.FREE || c.contains(tab[i + 1])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ObjCollection<? super V> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == ObjHash.FREE) continue;
                changed |= c.add(tab[i + 1]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == ObjHash.FREE) continue;
                changed |= s.remove(tab[i + 1]);
            }
            return changed;
        }

        @Nonnull
        public ObjIterator<V> iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public ObjCursor<V> cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == ObjHash.FREE) continue;
                result[resultIndex++] = tab[i + 1];
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                if (tab[i] == ObjHash.FREE) continue;
                a[resultIndex++] = tab[i + 1];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object val;
                if (tab[i] == ObjHash.FREE) continue;
                sb.append(' ').append((val = tab[i + 1]) != this ? val : "(this Collection)").append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return ImmutableQHashParallelKVObjObjMapGO.this.removeValue(o);
        }

        public void clear() {
            ImmutableQHashParallelKVObjObjMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super V> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ObjObjEntry {
        private K key;
        private V value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ObjObjEntry {
        private final K key;
        private final V value;

        ImmutableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    abstract class ObjObjEntry
    extends AbstractEntry<K, V> {
        ObjObjEntry() {
        }

        abstract K key();

        public final K getKey() {
            return this.key();
        }

        abstract V value();

        public final V getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                Object v2 = e2.getValue();
                return ImmutableQHashParallelKVObjObjMapGO.this.nullableKeyEquals(k2, this.key()) && ImmutableQHashParallelKVObjObjMapGO.this.nullableValueEquals(v2, this.value());
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return ImmutableQHashParallelKVObjObjMapGO.this.nullableKeyHashCode(this.key()) ^ ImmutableQHashParallelKVObjObjMapGO.this.nullableValueHashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, V>>
    implements HashObjSet<Map.Entry<K, V>>,
    InternalObjCollectionOps<Map.Entry<K, V>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<K, V>> equivalence() {
            return Equivalence.entryEquivalence(ImmutableQHashParallelKVObjObjMapGO.this.keyEquivalence(), ImmutableQHashParallelKVObjObjMapGO.this.valueEquivalence());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashParallelKVObjObjMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableQHashParallelKVObjObjMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableQHashParallelKVObjObjMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashParallelKVObjObjMapGO.this.containsEntry(e.getKey(), e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                result[resultIndex++] = new ImmutableEntry(key, tab[i + 1]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                a[resultIndex++] = new ImmutableEntry(key, tab[i + 1]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, tab[i + 1])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, V>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE || predicate.test((Map.Entry)((Object)new ImmutableEntry(key, tab[i + 1])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<K, V>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, V>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE || c.contains((Object)e.with(key, tab[i + 1]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                changed |= s.remove((Object)e.with(key, tab[i + 1]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                changed |= c.add((Object)new ImmutableEntry(key, tab[i + 1]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableQHashParallelKVObjObjMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            Object[] tab = ImmutableQHashParallelKVObjObjMapGO.this.table;
            for (int i = tab.length - 2; i >= 0; i -= 2) {
                Object key = tab[i];
                if (key == ObjHash.FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Collection)");
                sb.append('=');
                Object val = tab[i + 1];
                sb.append(val != this ? val : "(this Collection)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashParallelKVObjObjMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return ImmutableQHashParallelKVObjObjMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, V>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

