/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.IntCollection;
import com.koloboke.collect.IntCursor;
import com.koloboke.collect.IntIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractIntValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonIntIntMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalIntIntMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHashParallelKVIntIntMapSO;
import com.koloboke.collect.impl.hash.MutableParallelKVIntLHashGO;
import com.koloboke.collect.impl.hash.ParallelKVIntIntLHash;
import com.koloboke.collect.map.IntIntCursor;
import com.koloboke.collect.set.IntSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashIntSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.IntIntConsumer;
import com.koloboke.function.IntIntPredicate;
import com.koloboke.function.IntIntToIntFunction;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableLHashParallelKVIntIntMapGO
extends MutableLHashParallelKVIntIntMapSO {
    final void copy(ParallelKVIntIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVIntIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    public boolean containsEntry(int key, int value) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (int)(entry >>> 32) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    public Integer get(Object key) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)k) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (int)(entry >>> 32);
            } while (cur != free);
            return null;
        }
        return null;
    }

    public int get(int key) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (int)(entry >>> 32);
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    public Integer getOrDefault(Object key, Integer defaultValue) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)k) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == k) {
                return (int)(entry >>> 32);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (int)(entry >>> 32);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public int getOrDefault(int key, int defaultValue) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur == key) {
                return (int)(entry >>> 32);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (int)(entry >>> 32);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Integer, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            action.accept((Integer)key, (Integer)((int)(entry >>> 32)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(IntIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            action.accept(key, (int)(entry >>> 32));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(IntIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free || predicate.test(key, (int)(entry >>> 32))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public IntIntCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntIntMapOps.containsAllEntries((InternalIntIntMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalIntIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free || m.containsEntry(key, (int)(entry >>> 32))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalIntIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            m.justPut(key, (int)(entry >>> 32));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Integer, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            hashCode += key ^ (int)(entry >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((int)(entry >>> 32));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacityMask = newTab.length - 1;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            if (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)index << 3)) != free) {
                while (U.getInt(newTab, LONG_BASE + INT_KEY_OFFSET + ((long)(index = index - 1 & capacityMask) << 3)) != free) {
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Integer put(Integer key, Integer value) {
        int free;
        int k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVIntKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                this.postInsertHook();
                return null;
            } while (cur != k);
        }
        int prevValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return prevValue;
    }

    public int put(int key, int value) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != key) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return this.defaultValue();
            } while (cur != key);
        }
        int prevValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return prevValue;
    }

    public Integer putIfAbsent(Integer key, Integer value) {
        int free;
        int k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVIntKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        } while (cur != k);
        return (int)(entry >>> 32);
    }

    public int putIfAbsent(int key, int value) {
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (int)(entry >>> 32);
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        } while (cur != key);
        return (int)(entry >>> 32);
    }

    public void justPut(int key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
    }

    /*
     * Unable to fully structure code
     */
    public Integer compute(Integer key, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVIntKeyMixing.mix((int)k) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply((Integer)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = (long)k & 0xFFFFFFFFL | (long)newValue.intValue() << 32;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Integer)k, (Integer)((int)(entry >>> 32)))) != null) {
            MutableLHashParallelKVIntIntMapGO.U.putInt(tab, MutableLHashParallelKVIntIntMapGO.LONG_BASE + MutableLHashParallelKVIntIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public int compute(int key, IntIntToIntFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                newValue = remappingFunction.applyAsInt(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)newValue << 32;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsInt(key, (int)(entry >>> 32));
        MutableLHashParallelKVIntIntMapGO.U.putInt(tab, MutableLHashParallelKVIntIntMapGO.LONG_BASE + MutableLHashParallelKVIntIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    public Integer computeIfAbsent(Integer key, Function<? super Integer, ? extends Integer> mappingFunction) {
        Integer value;
        int k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVIntKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur != free) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (int)(entry >>> 32);
            } while (cur != free);
        }
        if ((value = mappingFunction.apply((Integer)k)) != null) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public int computeIfAbsent(int key, IntUnaryOperator mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return (int)(entry >>> 32);
        }
        if (cur != free) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (int)(entry >>> 32);
            } while (cur != free);
        }
        int value = mappingFunction.applyAsInt(key);
        this.incrementModCount();
        tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
        this.postInsertHook();
        return value;
    }

    public Integer computeIfPresent(Integer key, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        int k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (k != free) {
            Integer newValue;
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)k) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply((Integer)k, (Integer)((int)(entry >>> 32)))) != null) {
                U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public int computeIfPresent(int key, IntIntToIntFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            int newValue = remappingFunction.applyAsInt(key, (int)(entry >>> 32));
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    public Integer merge(Integer key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        block5: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVIntKeyMixing.mix((int)k) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl18
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Integer)((int)(entry >>> 32)), value)) != null) {
            MutableLHashParallelKVIntIntMapGO.U.putInt(tab, MutableLHashParallelKVIntIntMapGO.LONG_BASE + MutableLHashParallelKVIntIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public int merge(int key, int value, IntBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsInt((int)(entry >>> 32), value);
        MutableLHashParallelKVIntIntMapGO.U.putInt(tab, MutableLHashParallelKVIntIntMapGO.LONG_BASE + MutableLHashParallelKVIntIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public int addValue(int key, int value) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl13
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl13:
                // 2 sources

                newValue = this.defaultValue() + value;
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)newValue << 32;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = (int)(entry >>> 32) + value;
        MutableLHashParallelKVIntIntMapGO.U.putInt(tab, MutableLHashParallelKVIntIntMapGO.LONG_BASE + MutableLHashParallelKVIntIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public int addValue(int key, int addition, int initialValue) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl13
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl13:
                // 2 sources

                newValue = initialValue + addition;
                this.incrementModCount();
                tab[index] = (long)key & 0xFFFFFFFFL | (long)newValue << 32;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = (int)(entry >>> 32) + addition;
        MutableLHashParallelKVIntIntMapGO.U.putInt(tab, MutableLHashParallelKVIntIntMapGO.LONG_BASE + MutableLHashParallelKVIntIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Integer, ? extends Integer> m) {
        CommonIntIntMapOps.putAll((InternalIntIntMapOps)this, m);
    }

    public Integer replace(Integer key, Integer value) {
        int free;
        int k = key;
        if (k != (free = this.freeValue)) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)k) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            int oldValue = (int)(entry >>> 32);
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
            return oldValue;
        }
        return null;
    }

    public int replace(int key, int value) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            int oldValue = (int)(entry >>> 32);
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Integer key, Integer oldValue, Integer newValue) {
        return this.replace((int)key, (int)oldValue, (int)newValue);
    }

    public boolean replace(int key, int oldValue, int newValue) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((int)(entry >>> 32) == oldValue) {
                U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Integer, ? super Integer, ? extends Integer> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)i << 3), function.apply((Integer)key, (Integer)((int)(entry >>> 32))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(IntIntToIntFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key == free) continue;
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)i << 3), function.applyAsInt(key, (int)(entry >>> 32)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        long entry;
        int keyToShift;
        int indexToRemove;
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
            if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                tab[indexToRemove] = entry;
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
        this.postRemoveHook();
    }

    public Integer remove(Object key) {
        int free;
        int k = (Integer)key;
        if (k != (free = this.freeValue)) {
            int keyToShift;
            int indexToRemove;
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)k) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            int val = (int)(entry >>> 32);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(int key) {
        int free = this.freeValue;
        if (key != free) {
            int keyToShift;
            int indexToRemove;
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public int remove(int key) {
        int free = this.freeValue;
        if (key != free) {
            int keyToShift;
            int indexToRemove;
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            int val = (int)(entry >>> 32);
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, (Integer)value);
    }

    public boolean remove(int key, int value) {
        int free = this.freeValue;
        if (key != free) {
            long[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVIntKeyMixing.mix((int)key) & capacityMask;
            long entry = tab[index];
            int cur = (int)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((int)(entry >>> 32) == value) {
                int keyToShift;
                int indexToRemove;
                this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(IntIntPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || !filter.test(key, (int)(entry >>> 32))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Integer> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || !filter.test((Integer)key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(IntPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashIntSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashIntSet thisC, @Nonnull IntCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashIntSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof IntCollection) {
            return this.retainAll(thisC, (IntCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block13: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashIntSet thisC, @Nonnull IntCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        int delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block12: {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            tab[indexToRemove] = entry;
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                    this.postRemoveHook();
                } else {
                    U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved, int delayedRemoved) {
        int free = this.freeValue;
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            int keyToShift;
            int indexToRemove;
            long entry = tab[i];
            if ((int)entry != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if (keyToShift != delayedRemoved && (LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    tab[indexToRemove] = entry;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            U.putInt(tab, LONG_BASE + INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
            this.postRemoveHook();
        }
    }

    @Override
    public IntIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public IntCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements IntIntCursor {
        long[] tab;
        final int free;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVIntIntMapGO.this.table;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVIntIntMapGO.this.freeValue);
        }

        public void forEachForward(IntIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept(key, (int)(entry >>> 32));
            }
            if (index != this.index || mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(int value) {
            if (this.curKey == this.free) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashParallelKVIntIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), value);
            if (this.tab == MutableLHashParallelKVIntIntMapGO.this.table) return;
            UnsafeConstants.U.putInt(MutableLHashParallelKVIntIntMapGO.this.table, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            int free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVIntIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVIntIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVIntIntMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        long[] tab;
        final int free;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVIntIntMapGO.this.table;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVIntIntMapGO.this.freeValue);
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((int)(entry >>> 32));
            }
            if (index != this.index || mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            int free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVIntIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVIntIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVIntIntMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        long[] tab;
        final int free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        int next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVIntIntMapGO.this.table;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            this.capacityMask = tab.length - 1;
            int free = this.free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry == free) continue;
                this.next = (int)(entry >>> 32);
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            if (this.expectedModCount == MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    int free = this.free;
                    int prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        if ((int)entry == free) continue;
                        this.next = (int)(entry >>> 32);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((int)(entry >>> 32));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVIntIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVIntIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), this.free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = (int)(entry >>> 32);
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), this.free);
                MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVIntIntMapGO.this.justRemove(UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)index << 3)));
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Integer>> {
        long[] tab;
        final int free;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            int free;
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVIntIntMapGO.this.table;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableLHashParallelKVIntIntMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Integer, Integer>)((Object)new MutableEntry2(mc, i, key, (int)(entry >>> 32))));
            }
            if (index != this.index || mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Integer> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                int free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            int free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVIntIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVIntIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVIntIntMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, int key, int value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(int newValue) {
                if (NoRemovedEntryCursor.this.tab == MutableLHashParallelKVIntIntMapGO.this.table) {
                    UnsafeConstants.U.putInt(NoRemovedEntryCursor.this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)NoRemovedEntryCursor.this.index << 3), newValue);
                } else {
                    MutableLHashParallelKVIntIntMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Integer>> {
        long[] tab;
        final int free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableLHashParallelKVIntIntMapGO.this.table;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            this.capacityMask = tab.length - 1;
            int free = this.free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key == free) continue;
                this.next = new MutableEntry2(mc, nextI, key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Integer, Integer>)((Object)new MutableEntry2(mc, i, key, (int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex || mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Integer> next() {
            int mc = this.expectedModCount;
            if (mc == MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    long[] tab = this.tab;
                    int free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry2(mc, nextI, key, (int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVIntIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVIntIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), this.free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashParallelKVIntIntMapGO.this.modCount(), indexToShift, keyToShift, (int)(entry >>> 32));
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), this.free);
                MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVIntIntMapGO.this.justRemove(UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)index << 3)));
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, int key, int value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(int newValue) {
                if (NoRemovedEntryIterator.this.tab == MutableLHashParallelKVIntIntMapGO.this.table) {
                    UnsafeConstants.U.putInt(NoRemovedEntryIterator.this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)NoRemovedEntryIterator.this.index << 3), newValue);
                } else {
                    MutableLHashParallelKVIntIntMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        public int size() {
            return MutableLHashParallelKVIntIntMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashParallelKVIntIntMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableLHashParallelKVIntIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return MutableLHashParallelKVIntIntMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                action.accept((int)(entry >>> 32));
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || predicate.test((int)(entry >>> 32))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free || c.contains((int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= c.add((int)(entry >>> 32));
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                changed |= s.removeInt((int)(entry >>> 32));
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public IntCursor cursor() {
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry == free) continue;
                sb.append(' ').append((int)(entry >>> 32)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return MutableLHashParallelKVIntIntMapGO.this.removeValue(v);
        }

        public void clear() {
            MutableLHashParallelKVIntIntMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Integer> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || !filter.test((Integer)((int)(entry >>> 32)))) continue;
                    MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                        MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVIntIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(IntPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || !filter.test((int)(entry >>> 32))) continue;
                    MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                        MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVIntIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof IntCollection) {
                return this.removeAll((IntCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || !c.contains((int)(entry >>> 32))) continue;
                    MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                        MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVIntIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(IntCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || !c.contains((int)(entry >>> 32))) continue;
                    MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                        MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVIntIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof IntCollection) {
                return this.retainAll((IntCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block13: {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || c.contains((int)(entry >>> 32))) continue;
                    MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                        MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVIntIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(IntCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || c.contains((int)(entry >>> 32))) continue;
                    MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                        MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVIntIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends IntIntEntry {
        private int key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends IntIntEntry {
        final int modCount;
        private final int index;
        final int key;
        private int value;

        MutableEntry(int modCount, int index, int key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        public Integer setValue(Integer newValue) {
            int unwrappedNewValue;
            if (this.modCount != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            int oldValue = this.value;
            this.value = unwrappedNewValue = newValue.intValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(int newValue) {
            UnsafeConstants.U.putInt(MutableLHashParallelKVIntIntMapGO.this.table, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), newValue);
        }
    }

    abstract class IntIntEntry
    extends AbstractEntry<Integer, Integer> {
        IntIntEntry() {
        }

        abstract int key();

        public final Integer getKey() {
            return this.key();
        }

        abstract int value();

        public final Integer getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((int)this.key()) ^ Primitives.hashCode((int)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, Integer>>
    implements HashObjSet<Map.Entry<Integer, Integer>>,
    InternalObjCollectionOps<Map.Entry<Integer, Integer>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Integer, Integer>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashParallelKVIntIntMapGO.this.hashConfig();
        }

        public int size() {
            return MutableLHashParallelKVIntIntMapGO.this.size;
        }

        public double currentLoad() {
            return MutableLHashParallelKVIntIntMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashParallelKVIntIntMapGO.this.containsEntry((Integer)e.getKey(), (Integer)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Integer, Integer>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))));
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || predicate.test((Map.Entry<Integer, Integer>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Integer, Integer>> iterator() {
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, Integer>> cursor() {
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableLHashParallelKVIntIntMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((int)(entry >>> 32));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashParallelKVIntIntMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                int value = (Integer)e.getValue();
                return MutableLHashParallelKVIntIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, Integer>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block11: {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || !filter.test((Map.Entry<Integer, Integer>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))))) continue;
                    MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                        MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVIntIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block13: {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || !c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                    MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                        MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVIntIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashParallelKVIntIntMapGO.this.modCount();
            int free = MutableLHashParallelKVIntIntMapGO.this.freeValue;
            long[] tab = MutableLHashParallelKVIntIntMapGO.this.table;
            int capacityMask = tab.length - 1;
            int firstDelayedRemoved = -1;
            int delayedRemoved = 0;
            for (int i = tab.length - 1; i >= 0; --i) {
                block12: {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key == free || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                    MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                            if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    delayedRemoved = key;
                                    UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), key);
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                tab[indexToRemove] = entry;
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                        MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                    } else {
                        UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)i << 3), delayedRemoved);
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashParallelKVIntIntMapGO.this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
            }
            if (mc != MutableLHashParallelKVIntIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableLHashParallelKVIntIntMapGO.this.doClear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableParallelKVIntLHashGO.NoRemovedCursor {
        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashParallelKVIntIntMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int curKey = this.curKey;
            int free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVIntIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVIntIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), free);
                MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVIntIntMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableParallelKVIntLHashGO.NoRemovedIterator {
        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashParallelKVIntIntMapGO.this, mc);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashParallelKVIntIntMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            long[] tab = this.tab;
            if (tab == MutableLHashParallelKVIntIntMapGO.this.table) {
                long entry;
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashParallelKVIntIntMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (int)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVIntKeyMixing.mix((int)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), this.free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        tab[indexToRemove] = entry;
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)indexToRemove << 3), this.free);
                MutableLHashParallelKVIntIntMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashParallelKVIntIntMapGO.this.justRemove(UnsafeConstants.U.getInt(tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_KEY_OFFSET + ((long)index << 3)));
            }
        }
    }
}

