/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.ShortCollection;
import com.koloboke.collect.ShortCursor;
import com.koloboke.collect.ShortIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.AbstractShortValueView;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.CommonShortShortMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.InternalShortShortMapOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.ParallelKVShortShortLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashParallelKVShortShortMapSO;
import com.koloboke.collect.map.ShortShortCursor;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.ShortSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ShortBinaryOperator;
import com.koloboke.function.ShortConsumer;
import com.koloboke.function.ShortPredicate;
import com.koloboke.function.ShortShortConsumer;
import com.koloboke.function.ShortShortPredicate;
import com.koloboke.function.ShortShortToShortFunction;
import com.koloboke.function.ShortUnaryOperator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class UpdatableLHashParallelKVShortShortMapGO
extends UpdatableLHashParallelKVShortShortMapSO {
    final void copy(ParallelKVShortShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVShortShortLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    public boolean containsEntry(short key, short value) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (short)(entry >>> 16) == value;
            }
            if (cur == free) {
                return false;
            }
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16) == value;
            } while (cur != free);
            return false;
        }
        return false;
    }

    public Short get(Object key) {
        short free;
        short k = (Short)key;
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)k) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return null;
            }
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return null;
        }
        return null;
    }

    public short get(short key) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return this.defaultValue();
        }
        return this.defaultValue();
    }

    public Short getOrDefault(Object key, Short defaultValue) {
        short free;
        short k = (Short)key;
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)k) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public short getOrDefault(short key, short defaultValue) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
            return defaultValue;
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Short, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            action.accept((Short)key, (Short)((short)(entry >>> 16)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ShortShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            action.accept(key, (short)(entry >>> 16));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ShortShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free || predicate.test(key, (short)(entry >>> 16))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ShortShortCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonShortShortMapOps.containsAllEntries((InternalShortShortMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalShortShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free || m.containsEntry(key, (short)(entry >>> 16))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalShortShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            m.justPut(key, (short)(entry >>> 16));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Short, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            hashCode += key ^ (short)(entry >>> 16);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((short)(entry >>> 16));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newTab = this.table;
        int capacityMask = newTab.length - 1;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            if (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2)) != free) {
                while (U.getShort(newTab, INT_BASE + SHORT_KEY_OFFSET + ((long)(index = index - 1 & capacityMask) << 2)) != free) {
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Short put(Short key, Short value) {
        short free;
        short k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix((short)k) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value << 16;
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = k & 0xFFFF | value << 16;
                this.postInsertHook();
                return null;
            } while (cur != k);
        }
        short prevValue = (short)(entry >>> 16);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    public short put(short key, short value) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != key) {
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
                this.incrementModCount();
                tab[index] = key & 0xFFFF | value << 16;
                this.postInsertHook();
                return this.defaultValue();
            } while (cur != key);
        }
        short prevValue = (short)(entry >>> 16);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    public Short putIfAbsent(Short key, Short value) {
        short free;
        short k = key;
        if (k == (free = this.freeValue)) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix((short)k) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value << 16;
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return (short)(entry >>> 16);
        }
        do {
            if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value << 16;
            this.postInsertHook();
            return null;
        } while (cur != k);
        return (short)(entry >>> 16);
    }

    public short putIfAbsent(short key, short value) {
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (short)(entry >>> 16);
        }
        do {
            if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != free) continue;
            this.incrementModCount();
            tab[index] = key & 0xFFFF | value << 16;
            this.postInsertHook();
            return this.defaultValue();
        } while (cur != key);
        return (short)(entry >>> 16);
    }

    public void justPut(short key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putShort(this.table, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
    }

    /*
     * Unable to fully structure code
     */
    public Short compute(Short key, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVShortKeyMixing.mix((short)k) & capacityMask;
            entry = tab[index];
            cur = (short)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply((Short)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = k & 65535 | newValue << 16;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Short)k, (Short)((short)(entry >>> 16)))) != null) {
            UpdatableLHashParallelKVShortShortMapGO.U.putShort(tab, UpdatableLHashParallelKVShortShortMapGO.INT_BASE + UpdatableLHashParallelKVShortShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public short compute(short key, ShortShortToShortFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            entry = tab[index];
            cur = (short)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                newValue = remappingFunction.applyAsShort(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key & 65535 | newValue << 16;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsShort(key, (short)(entry >>> 16));
        UpdatableLHashParallelKVShortShortMapGO.U.putShort(tab, UpdatableLHashParallelKVShortShortMapGO.INT_BASE + UpdatableLHashParallelKVShortShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public Short computeIfAbsent(Short key, Function<? super Short, ? extends Short> mappingFunction) {
        Short value;
        short k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix((short)k) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == k) {
            return (short)(entry >>> 16);
        }
        if (cur != free) {
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
        }
        if ((value = mappingFunction.apply((Short)k)) != null) {
            this.incrementModCount();
            tab[index] = k & 0xFFFF | value << 16;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public short computeIfAbsent(short key, ShortUnaryOperator mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        int[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
        int entry = tab[index];
        short cur = (short)entry;
        if (cur == key) {
            return (short)(entry >>> 16);
        }
        if (cur != free) {
            do {
                if ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
                return (short)(entry >>> 16);
            } while (cur != free);
        }
        short value = mappingFunction.applyAsShort(key);
        this.incrementModCount();
        tab[index] = key & 0xFFFF | value << 16;
        this.postInsertHook();
        return value;
    }

    public Short computeIfPresent(Short key, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        short k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (k != free) {
            Short newValue;
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)k) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            if ((newValue = remappingFunction.apply((Short)k, (Short)((short)(entry >>> 16)))) != null) {
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public short computeIfPresent(short key, ShortShortToShortFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            short newValue = remappingFunction.applyAsShort(key, (short)(entry >>> 16));
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    public Short merge(Short key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        block5: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVShortKeyMixing.mix((short)k) & capacityMask;
            entry = tab[index];
            cur = (short)entry;
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl18
            while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                tab[index] = k & 65535 | value << 16;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Short)((short)(entry >>> 16)), value)) != null) {
            UpdatableLHashParallelKVShortShortMapGO.U.putShort(tab, UpdatableLHashParallelKVShortShortMapGO.INT_BASE + UpdatableLHashParallelKVShortShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public short merge(short key, short value, ShortBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            entry = tab[index];
            cur = (short)entry;
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                tab[index] = key & 65535 | value << 16;
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsShort((short)(entry >>> 16), value);
        UpdatableLHashParallelKVShortShortMapGO.U.putShort(tab, UpdatableLHashParallelKVShortShortMapGO.INT_BASE + UpdatableLHashParallelKVShortShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public short addValue(short key, short value) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            entry = tab[index];
            cur = (short)entry;
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl13
            while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl13:
                // 2 sources

                newValue = (short)(this.defaultValue() + value);
                this.incrementModCount();
                tab[index] = key & 65535 | newValue << 16;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = (short)((short)(entry >>> 16) + value);
        UpdatableLHashParallelKVShortShortMapGO.U.putShort(tab, UpdatableLHashParallelKVShortShortMapGO.INT_BASE + UpdatableLHashParallelKVShortShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public short addValue(short key, short addition, short initialValue) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            entry = tab[index];
            cur = (short)entry;
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl13
            while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                if (cur != free) continue;
lbl13:
                // 2 sources

                newValue = (short)(initialValue + addition);
                this.incrementModCount();
                tab[index] = key & 65535 | newValue << 16;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = (short)((short)(entry >>> 16) + addition);
        UpdatableLHashParallelKVShortShortMapGO.U.putShort(tab, UpdatableLHashParallelKVShortShortMapGO.INT_BASE + UpdatableLHashParallelKVShortShortMapGO.SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Short, ? extends Short> m) {
        CommonShortShortMapOps.putAll((InternalShortShortMapOps)this, m);
    }

    public Short replace(Short key, Short value) {
        short free;
        short k = key;
        if (k != (free = this.freeValue)) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)k) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != k) {
                    if (cur != free) continue;
                    return null;
                }
            }
            short oldValue = (short)(entry >>> 16);
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return null;
    }

    public short replace(short key, short value) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return this.defaultValue();
                }
            }
            short oldValue = (short)(entry >>> 16);
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Short key, Short oldValue, Short newValue) {
        return this.replace((short)key, (short)oldValue, (short)newValue);
    }

    public boolean replace(short key, short oldValue, short newValue) {
        short free = this.freeValue;
        if (key != free) {
            int[] tab = this.table;
            int capacityMask = tab.length - 1;
            int index = LHash.ParallelKVShortKeyMixing.mix((short)key) & capacityMask;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = (short)(entry = tab[index = index - 1 & capacityMask])) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            if ((short)(entry >>> 16) == oldValue) {
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Short, ? super Short, ? extends Short> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)i << 2), function.apply((Short)key, (Short)((short)(entry >>> 16))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ShortShortToShortFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        short free = this.freeValue;
        int[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            int entry = tab[i];
            short key = (short)entry;
            if (key == free) continue;
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)i << 2), function.applyAsShort(key, (short)(entry >>> 16)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Short remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(short key) {
        throw new UnsupportedOperationException();
    }

    public short remove(short key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Short)key, (Short)value);
    }

    public boolean remove(short key, short value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ShortShortPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ShortShortCursor {
        final int[] tab;
        final short free;
        int expectedModCount;
        int index;
        short curKey;
        short curValue;

        NoRemovedMapCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue);
        }

        public void forEachForward(ShortShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(key, (short)(entry >>> 16));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short key() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        final int[] tab;
        final short free;
        int expectedModCount;
        int index;
        short curKey;
        short curValue;

        NoRemovedValueCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue);
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        final int[] tab;
        final short free;
        int expectedModCount;
        int nextIndex;
        short next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            short free = this.free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                if ((short)entry == free) continue;
                this.next = (short)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            if (this.expectedModCount == UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    int[] tab = this.tab;
                    short free = this.free;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        if ((short)entry == free) continue;
                        this.next = (short)(entry >>> 16);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((Short)((short)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Short, Short>> {
        final int[] tab;
        final short free;
        int expectedModCount;
        int index;
        short curKey;
        short curValue;

        NoRemovedEntryCursor(int mc) {
            short free;
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Short, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Short, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Short, Short> elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                short free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Short, Short>> {
        final int[] tab;
        final short free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            short free = this.free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                short key = (short)entry;
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, (short)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Short, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Short, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Short, Short> next() {
            int mc = this.expectedModCount;
            if (mc == UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    int[] tab = this.tab;
                    short free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        short key = (short)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, (short)(entry >>> 16));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        public int size() {
            return UpdatableLHashParallelKVShortShortMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVShortShortMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return UpdatableLHashParallelKVShortShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return UpdatableLHashParallelKVShortShortMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((Short)((short)(entry >>> 16)));
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free || predicate.test((short)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free || c.contains((short)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                changed |= c.add((short)(entry >>> 16));
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                changed |= s.removeShort((short)(entry >>> 16));
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ShortCursor cursor() {
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                result[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                a[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                result[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                a[resultIndex++] = (short)(entry >>> 16);
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((short)entry == free) continue;
                sb.append(' ').append((short)(entry >>> 16)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return UpdatableLHashParallelKVShortShortMapGO.this.removeValue(v);
        }

        public void clear() {
            UpdatableLHashParallelKVShortShortMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Short> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(ShortPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ShortShortEntry {
        private short key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(short key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ShortShortEntry {
        final int modCount;
        private final int index;
        final short key;
        private short value;

        MutableEntry(int modCount, int index, short key, short value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }

        public Short setValue(Short newValue) {
            short unwrappedNewValue;
            if (this.modCount != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            short oldValue = this.value;
            this.value = unwrappedNewValue = newValue.shortValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(short newValue) {
            UnsafeConstants.U.putShort(UpdatableLHashParallelKVShortShortMapGO.this.table, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), newValue);
        }
    }

    abstract class ShortShortEntry
    extends AbstractEntry<Short, Short> {
        ShortShortEntry() {
        }

        abstract short key();

        public final Short getKey() {
            return this.key();
        }

        abstract short value();

        public final Short getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                short k2 = (Short)e2.getKey();
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((short)this.key()) ^ Primitives.hashCode((short)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Short, Short>>
    implements HashObjSet<Map.Entry<Short, Short>>,
    InternalObjCollectionOps<Map.Entry<Short, Short>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Short, Short>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableLHashParallelKVShortShortMapGO.this.hashConfig();
        }

        public int size() {
            return UpdatableLHashParallelKVShortShortMapGO.this.size;
        }

        public double currentLoad() {
            return UpdatableLHashParallelKVShortShortMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableLHashParallelKVShortShortMapGO.this.containsEntry((Short)e.getKey(), (Short)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (short)(entry >>> 16));
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (short)(entry >>> 16));
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Short, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Short, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))));
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Short, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || predicate.test((Map.Entry<Short, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Short, Short>> iterator() {
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Short, Short>> cursor() {
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free || c.contains((Object)e.with(key, (short)(entry >>> 16)))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (short)(entry >>> 16)));
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Short, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16)));
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return UpdatableLHashParallelKVShortShortMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVShortShortMapGO.this.modCount();
            short free = UpdatableLHashParallelKVShortShortMapGO.this.freeValue;
            int[] tab = UpdatableLHashParallelKVShortShortMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((short)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVShortShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVShortShortMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                short key = (Short)e.getKey();
                short value = (Short)e.getValue();
                return UpdatableLHashParallelKVShortShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Short, Short>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            UpdatableLHashParallelKVShortShortMapGO.this.doClear();
        }
    }
}

