/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.net.http.WebSocket;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kong.unirest.core.Cache;
import kong.unirest.core.Client;
import kong.unirest.core.HttpRequest;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.RawResponse;
import kong.unirest.core.SseHandler;
import kong.unirest.core.SseRequest;
import kong.unirest.core.Util;
import kong.unirest.core.WebSocketRequest;
import kong.unirest.core.WebSocketResponse;
import kong.unirest.core.java.Event;

class CacheManager {
    private final CacheWrapper wrapper = new CacheWrapper();
    private final CacheWrapper asyncWrapper = new CacheWrapper();
    private final Cache backingCache;
    private final Cache.KeyGenerator keyGen;
    private Client originalClient;

    public CacheManager() {
        this(100, 0L, HashKey::new);
    }

    public CacheManager(int depth, long ttl, Cache.KeyGenerator keyGenerator) {
        this(new CacheMap(depth, ttl), keyGenerator);
    }

    public CacheManager(Cache backing, Cache.KeyGenerator keyGenerator) {
        this.backingCache = backing;
        this.keyGen = keyGenerator != null ? keyGenerator : HashKey::new;
    }

    Client wrap(Client client) {
        this.originalClient = client;
        return this.wrapper;
    }

    Client wrapAsync(Client client) {
        this.originalClient = client;
        return this.asyncWrapper;
    }

    private <T> Cache.Key getHash(HttpRequest request, Boolean isAsync, Class<?> responseType) {
        return this.keyGen.apply(request, isAsync, responseType);
    }

    private static class CacheMap
    extends LinkedHashMap<Cache.Key, Object>
    implements Cache {
        private final int maxSize;
        private long ttl;

        CacheMap(int maxSize, long ttl) {
            this.maxSize = maxSize;
            this.ttl = ttl;
        }

        @Override
        public <T> HttpResponse<T> get(Cache.Key key, Supplier<HttpResponse<T>> fetcher) {
            this.clearOld();
            return (HttpResponse)super.computeIfAbsent(key, k -> fetcher.get());
        }

        @Override
        public <T> CompletableFuture getAsync(Cache.Key key, Supplier<CompletableFuture<HttpResponse<T>>> fetcher) {
            this.clearOld();
            return (CompletableFuture)super.computeIfAbsent(key, k -> fetcher.get());
        }

        private void clearOld() {
            if (this.ttl > 0L) {
                Instant now = Util.now();
                this.keySet().removeIf(k -> ChronoUnit.MILLIS.between(k.getTime(), now) > this.ttl);
            }
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Cache.Key, Object> eldest) {
            return this.size() > this.maxSize;
        }
    }

    private class CacheWrapper
    implements Client {
        private CacheWrapper() {
        }

        public Object getClient() {
            return CacheManager.this.originalClient.getClient();
        }

        @Override
        public <T> HttpResponse<T> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer, Class<?> responseType) {
            Cache.Key hash = CacheManager.this.getHash(request, false, responseType);
            return CacheManager.this.backingCache.get(hash, () -> CacheManager.this.originalClient.request(request, transformer, responseType));
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer, CompletableFuture<HttpResponse<T>> callback, Class<?> responseType) {
            Cache.Key key = CacheManager.this.getHash(request, true, responseType);
            return CacheManager.this.backingCache.getAsync(key, () -> CacheManager.this.originalClient.request(request, transformer, callback, responseType));
        }

        @Override
        public WebSocketResponse websocket(WebSocketRequest request, WebSocket.Listener listener) {
            return CacheManager.this.originalClient.websocket(request, listener);
        }

        @Override
        public CompletableFuture<Void> sse(SseRequest request, SseHandler handler) {
            return CacheManager.this.originalClient.sse(request, handler);
        }

        @Override
        public Stream<Event> sse(SseRequest request) {
            return Stream.empty();
        }
    }

    private static class HashKey
    implements Cache.Key {
        private final int hash;
        private final Instant time;

        HashKey(HttpRequest request, Boolean isAsync, Class<?> responseType) {
            this(Objects.hash(request.hashCode(), isAsync, responseType), request.getCreationTime());
        }

        HashKey(int hash, Instant time) {
            this.hash = hash;
            this.time = time;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashKey key = (HashKey)o;
            return this.hash == key.hash;
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        @Override
        public Instant getTime() {
            return this.time;
        }
    }
}

