/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.io.File;
import java.nio.file.CopyOption;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kong.unirest.BasicResponse;
import kong.unirest.ByteResponse;
import kong.unirest.Callback;
import kong.unirest.CallbackFuture;
import kong.unirest.Config;
import kong.unirest.Cookie;
import kong.unirest.Empty;
import kong.unirest.FileResponse;
import kong.unirest.GenericType;
import kong.unirest.Headers;
import kong.unirest.HttpMethod;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestSummary;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.JsonResponse;
import kong.unirest.ObjectMapper;
import kong.unirest.ObjectResponse;
import kong.unirest.PagedList;
import kong.unirest.Path;
import kong.unirest.ProgressMonitor;
import kong.unirest.Proxy;
import kong.unirest.RawResponse;
import kong.unirest.RequestSummary;
import kong.unirest.StringResponse;
import kong.unirest.UnirestException;
import kong.unirest.Util;

abstract class BaseRequest<R extends HttpRequest>
implements HttpRequest<R> {
    private Instant creation = Util.now();
    private Optional<ObjectMapper> objectMapper = Optional.empty();
    private String responseEncoding;
    protected Headers headers = new Headers();
    protected final Config config;
    protected HttpMethod method;
    protected Path url;
    private Integer socketTimeout;
    private Integer connectTimeout;
    private Proxy proxy;
    private ProgressMonitor downloadMonitor;

    BaseRequest(BaseRequest httpRequest) {
        this.config = httpRequest.config;
        this.method = httpRequest.method;
        this.url = httpRequest.url;
        this.headers.putAll(httpRequest.headers);
        this.socketTimeout = httpRequest.socketTimeout;
        this.connectTimeout = httpRequest.connectTimeout;
        this.proxy = httpRequest.proxy;
        this.objectMapper = httpRequest.objectMapper;
    }

    BaseRequest(Config config, HttpMethod method, String url) {
        this.config = config;
        this.method = method;
        this.url = new Path(url, config.getDefaultBaseUrl());
        this.headers.putAll(config.getDefaultHeaders());
    }

    @Override
    public R routeParam(String name, String value) {
        this.url.param(name, value);
        return (R)this;
    }

    @Override
    public R routeParam(Map<String, Object> params) {
        this.url.param(params);
        return (R)this;
    }

    @Override
    public R basicAuth(String username, String password) {
        this.headers.replace("Authorization", Util.toBasicAuthValue(username, password));
        return (R)this;
    }

    @Override
    public R accept(String value) {
        return this.header("Accept", value);
    }

    @Override
    public R responseEncoding(String encoding) {
        this.responseEncoding = encoding;
        return (R)this;
    }

    @Override
    public R header(String name, String value) {
        this.headers.add(name.trim(), value);
        return (R)this;
    }

    @Override
    public R headerReplace(String name, String value) {
        this.headers.replace(name, value);
        return (R)this;
    }

    @Override
    public R headers(Map<String, String> headerMap) {
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                this.header(entry.getKey(), entry.getValue());
            }
        }
        return (R)this;
    }

    @Override
    public R cookie(String name, String value) {
        this.headers.cookie(new Cookie(name, value));
        return (R)this;
    }

    @Override
    public R cookie(Cookie cookie) {
        this.headers.cookie(cookie);
        return (R)this;
    }

    @Override
    public R cookie(Collection<Cookie> cookies) {
        this.headers.cookie(cookies);
        return (R)this;
    }

    @Override
    public R queryString(String name, Collection<?> value) {
        this.url.queryString(name, value);
        return (R)this;
    }

    @Override
    public R queryString(String name, Object value) {
        this.url.queryString(name, value);
        return (R)this;
    }

    @Override
    public R queryString(Map<String, Object> parameters) {
        this.url.queryString(parameters);
        return (R)this;
    }

    @Override
    public R socketTimeout(int millies) {
        this.socketTimeout = millies;
        return (R)this;
    }

    @Override
    public R connectTimeout(int millies) {
        this.connectTimeout = millies;
        return (R)this;
    }

    @Override
    public R proxy(String host, int port) {
        this.proxy = new Proxy(host, port);
        return (R)this;
    }

    @Override
    public R withObjectMapper(ObjectMapper mapper) {
        Objects.requireNonNull(mapper, "ObjectMapper may not be null");
        this.objectMapper = Optional.of(mapper);
        return (R)this;
    }

    @Override
    public R downloadMonitor(ProgressMonitor monitor) {
        this.downloadMonitor = monitor;
        return (R)this;
    }

    @Override
    public HttpResponse asEmpty() {
        return this.config.getClient().request(this, BasicResponse::new, Empty.class);
    }

    @Override
    public CompletableFuture<HttpResponse<Empty>> asEmptyAsync() {
        return this.config.getAsyncClient().request(this, BasicResponse::new, new CompletableFuture(), Empty.class);
    }

    @Override
    public CompletableFuture<HttpResponse<Empty>> asEmptyAsync(Callback<Empty> callback) {
        return this.config.getAsyncClient().request(this, BasicResponse::new, CallbackFuture.wrap(callback), Empty.class);
    }

    @Override
    public HttpResponse<String> asString() throws UnirestException {
        return this.config.getClient().request(this, r -> new StringResponse((RawResponse)r, this.responseEncoding), String.class);
    }

    @Override
    public CompletableFuture<HttpResponse<String>> asStringAsync() {
        return this.config.getAsyncClient().request(this, r -> new StringResponse((RawResponse)r, this.responseEncoding), new CompletableFuture(), String.class);
    }

    @Override
    public CompletableFuture<HttpResponse<String>> asStringAsync(Callback<String> callback) {
        return this.config.getAsyncClient().request(this, r -> new StringResponse((RawResponse)r, this.responseEncoding), CallbackFuture.wrap(callback), String.class);
    }

    @Override
    public HttpResponse<byte[]> asBytes() {
        return this.config.getClient().request(this, ByteResponse::new, byte[].class);
    }

    @Override
    public CompletableFuture<HttpResponse<byte[]>> asBytesAsync() {
        return this.config.getAsyncClient().request(this, ByteResponse::new, new CompletableFuture(), byte[].class);
    }

    @Override
    public CompletableFuture<HttpResponse<byte[]>> asBytesAsync(Callback<byte[]> callback) {
        return this.config.getAsyncClient().request(this, ByteResponse::new, CallbackFuture.wrap(callback), byte[].class);
    }

    @Override
    public HttpResponse<JsonNode> asJson() throws UnirestException {
        return this.config.getClient().request(this, JsonResponse::new, JsonNode.class);
    }

    @Override
    public CompletableFuture<HttpResponse<JsonNode>> asJsonAsync() {
        return this.config.getAsyncClient().request(this, JsonResponse::new, new CompletableFuture(), JsonNode.class);
    }

    @Override
    public CompletableFuture<HttpResponse<JsonNode>> asJsonAsync(Callback<JsonNode> callback) {
        return this.config.getAsyncClient().request(this, JsonResponse::new, CallbackFuture.wrap(callback), JsonNode.class);
    }

    @Override
    public <T> HttpResponse<T> asObject(Class<? extends T> responseClass) throws UnirestException {
        return this.config.getClient().request(this, r -> new ObjectResponse(this.getObjectMapper(), (RawResponse)r, responseClass), responseClass);
    }

    @Override
    public <T> HttpResponse<T> asObject(GenericType<T> genericType) throws UnirestException {
        return this.config.getClient().request(this, r -> new ObjectResponse(this.getObjectMapper(), (RawResponse)r, genericType), genericType.getTypeClass());
    }

    @Override
    public <T> HttpResponse<T> asObject(Function<RawResponse, T> function) {
        return this.config.getClient().request(this, this.funcResponse(function), Object.class);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(Function<RawResponse, T> function) {
        return this.config.getAsyncClient().request(this, this.funcResponse(function), new CompletableFuture(), JsonNode.class);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(Class<? extends T> responseClass) {
        return this.config.getAsyncClient().request(this, r -> new ObjectResponse(this.getObjectMapper(), (RawResponse)r, responseClass), new CompletableFuture(), responseClass);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(Class<? extends T> responseClass, Callback<T> callback) {
        return this.config.getAsyncClient().request(this, r -> new ObjectResponse(this.getObjectMapper(), (RawResponse)r, responseClass), CallbackFuture.wrap(callback), responseClass);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(GenericType<T> genericType) {
        return this.config.getAsyncClient().request(this, r -> new ObjectResponse(this.getObjectMapper(), (RawResponse)r, genericType), new CompletableFuture(), genericType.getTypeClass());
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> asObjectAsync(GenericType<T> genericType, Callback<T> callback) {
        return this.config.getAsyncClient().request(this, r -> new ObjectResponse(this.getObjectMapper(), (RawResponse)r, genericType), CallbackFuture.wrap(callback), genericType.getTypeClass());
    }

    private <T> Function<RawResponse, HttpResponse<T>> funcResponse(Function<RawResponse, T> function) {
        return r -> new BasicResponse((RawResponse)r, function.apply((RawResponse)r));
    }

    @Override
    public void thenConsume(Consumer<RawResponse> consumer) {
        this.config.getClient().request(this, this.getConsumer(consumer), Object.class);
    }

    @Override
    public void thenConsumeAsync(Consumer<RawResponse> consumer) {
        this.config.getAsyncClient().request(this, this.getConsumer(consumer), new CompletableFuture(), Object.class);
    }

    @Override
    public HttpResponse<File> asFile(String path, CopyOption ... copyOptions) {
        return this.config.getClient().request(this, r -> new FileResponse((RawResponse)r, path, this.downloadMonitor, copyOptions), File.class);
    }

    @Override
    public CompletableFuture<HttpResponse<File>> asFileAsync(String path, CopyOption ... copyOptions) {
        return this.config.getAsyncClient().request(this, r -> new FileResponse((RawResponse)r, path, this.downloadMonitor, copyOptions), new CompletableFuture(), File.class);
    }

    @Override
    public CompletableFuture<HttpResponse<File>> asFileAsync(String path, Callback<File> callback, CopyOption ... copyOptions) {
        return this.config.getAsyncClient().request(this, r -> new FileResponse((RawResponse)r, path, this.downloadMonitor, copyOptions), CallbackFuture.wrap(callback), File.class);
    }

    @Override
    public <T> PagedList<T> asPaged(Function<HttpRequest, HttpResponse> mappingFunction, Function<HttpResponse<T>, String> linkExtractor) {
        HttpResponse next;
        PagedList all = new PagedList();
        String nextLink = this.getUrl();
        do {
            this.url = new Path(nextLink, this.config.getDefaultBaseUrl());
            next = mappingFunction.apply(this);
            all.add(next);
        } while (!Util.isNullOrEmpty(nextLink = linkExtractor.apply(next)));
        return all;
    }

    private Function<RawResponse, HttpResponse<Object>> getConsumer(Consumer<RawResponse> consumer) {
        return r -> {
            consumer.accept((RawResponse)r);
            return null;
        };
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.method;
    }

    @Override
    public String getUrl() {
        return this.escape(this.url.toString());
    }

    private String escape(String string) {
        return string.replaceAll(" ", "%20").replaceAll("\t", "%09");
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper.orElseGet(this.config::getObjectMapper);
    }

    @Override
    public int getSocketTimeout() {
        return this.valueOr(this.socketTimeout, this.config::getSocketTimeout);
    }

    @Override
    public int getConnectTimeout() {
        return this.valueOr(this.connectTimeout, this.config::getConnectionTimeout);
    }

    @Override
    public Proxy getProxy() {
        return this.valueOr(this.proxy, this.config::getProxy);
    }

    @Override
    public HttpRequestSummary toSummary() {
        return new RequestSummary(this);
    }

    @Override
    public Instant getCreationTime() {
        return this.creation;
    }

    private <T> T valueOr(T x, Supplier<T> o) {
        if (x != null) {
            return x;
        }
        return o.get();
    }

    Path getPath() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseRequest that = (BaseRequest)o;
        return Objects.equals(this.headers, that.headers) && Objects.equals(this.method, that.method) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.method, this.url);
    }
}

