/*
 * Decompiled with CFR 0.152.
 */
package unirest.shaded.org.apache.http.impl;

import java.util.Locale;
import unirest.shaded.org.apache.http.HttpResponse;
import unirest.shaded.org.apache.http.HttpResponseFactory;
import unirest.shaded.org.apache.http.ProtocolVersion;
import unirest.shaded.org.apache.http.ReasonPhraseCatalog;
import unirest.shaded.org.apache.http.StatusLine;
import unirest.shaded.org.apache.http.annotation.Contract;
import unirest.shaded.org.apache.http.annotation.ThreadingBehavior;
import unirest.shaded.org.apache.http.impl.EnglishReasonPhraseCatalog;
import unirest.shaded.org.apache.http.message.BasicHttpResponse;
import unirest.shaded.org.apache.http.message.BasicStatusLine;
import unirest.shaded.org.apache.http.protocol.HttpContext;
import unirest.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

