/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.net.http.WebSocket;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import kong.unirest.Config;
import kong.unirest.Cookie;
import kong.unirest.Headers;
import kong.unirest.HttpMethod;
import kong.unirest.ObjectMapper;
import kong.unirest.Path;
import kong.unirest.Util;
import kong.unirest.WebSocketRequest;
import kong.unirest.WebSocketResponse;

public class WebSocketRequestImpl
implements WebSocketRequest {
    private Instant creation = Util.now();
    private Optional<ObjectMapper> objectMapper = Optional.empty();
    private String responseEncoding;
    protected Headers headers = new Headers();
    protected final Config config;
    protected HttpMethod method;
    protected Path url;
    private Integer connectTimeout;

    public WebSocketRequestImpl(Config config, String url) {
        this.config = config;
        this.url = new Path(url, config.getDefaultBaseUrl());
        this.headers.putAll(config.getDefaultHeaders());
    }

    @Override
    public WebSocketRequest routeParam(String name, String value) {
        this.url.param(name, value);
        return this;
    }

    @Override
    public WebSocketRequest routeParam(Map<String, Object> params) {
        this.url.param(params);
        return this;
    }

    @Override
    public WebSocketRequest basicAuth(String username, String password) {
        this.headers.setBasicAuth(username, password);
        return this;
    }

    @Override
    public WebSocketRequest accept(String value) {
        this.headers.accepts(value);
        return this;
    }

    @Override
    public WebSocketRequest responseEncoding(String encoding) {
        this.responseEncoding = encoding;
        return this;
    }

    @Override
    public WebSocketRequest header(String name, String value) {
        this.headers.add(name, value);
        return this;
    }

    @Override
    public WebSocketRequest headerReplace(String name, String value) {
        this.headers.replace(name, value);
        return this;
    }

    @Override
    public WebSocketRequest headers(Map<String, String> headerMap) {
        this.headers.add(headerMap);
        return this;
    }

    @Override
    public WebSocketRequest cookie(String name, String value) {
        this.headers.cookie(new Cookie(name, value));
        return this;
    }

    @Override
    public WebSocketRequest cookie(Cookie cookie) {
        this.headers.cookie(cookie);
        return this;
    }

    @Override
    public WebSocketRequest cookie(Collection<Cookie> cookies) {
        this.headers.cookie(cookies);
        return this;
    }

    @Override
    public WebSocketRequest queryString(String name, Object value) {
        this.url.queryString(name, value);
        return this;
    }

    @Override
    public WebSocketRequest queryString(String name, Collection<?> value) {
        this.url.queryString(name, value);
        return this;
    }

    @Override
    public WebSocketRequest queryString(Map<String, Object> parameters) {
        this.url.queryString(parameters);
        return this;
    }

    @Override
    public WebSocketResponse connect(WebSocket.Listener listener) {
        return this.config.getClient().websocket(this, listener);
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public String getUrl() {
        return this.url.toString();
    }
}

