/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import kong.unirest.core.Assert;
import kong.unirest.core.Config;
import kong.unirest.core.Expectation;
import kong.unirest.core.Headers;
import kong.unirest.core.HttpMethod;
import kong.unirest.core.HttpRequest;
import kong.unirest.core.Invocation;
import kong.unirest.core.Path;
import kong.unirest.core.RawResponse;
import kong.unirest.core.UnirestAssertion;

class Routes
implements Assert {
    private final String path;
    private final HttpMethod method;
    private final List<Invocation> invokes = new ArrayList<Invocation>();

    Routes(HttpRequest request) {
        Path p = new Path(request.getUrl());
        this.method = request.getHttpMethod();
        this.path = p.baseUrl();
        this.invokes.add(new Invocation(this, request));
    }

    public Routes(HttpMethod method, Path p) {
        this.method = method;
        this.path = p.baseUrl();
    }

    Expectation newExpectation() {
        Invocation inv = new Invocation(this);
        this.invokes.add(inv);
        return inv;
    }

    boolean matches(HttpRequest request) {
        Path p = new Path(request.getUrl());
        return this.method.equals(request.getHttpMethod()) && this.path == null || this.path.equalsIgnoreCase(p.baseUrl());
    }

    RawResponse exchange(HttpRequest request, Config config) {
        return this.getBestMatch(request).map(invocation -> invocation.getResponse(config, request)).orElseGet(() -> {
            Invocation i = new Invocation(this);
            i.log(request);
            this.invokes.add(i);
            return i.getResponse(config, request);
        });
    }

    boolean matches(HttpMethod httpMethod, Path url) {
        return this.method.equals(httpMethod) && this.path.equals(url.baseUrl());
    }

    private Optional<Invocation> getBestMatch(HttpRequest request) {
        Optional<Invocation> i = this.getBestMatch(request, true);
        if (i.isPresent()) {
            return i;
        }
        return this.getBestMatch(request, false);
    }

    private Optional<Invocation> getBestMatch(HttpRequest request, boolean expected) {
        TreeMap map = new TreeMap();
        this.invokes.stream().forEach(i -> {
            Integer score = i.scoreMatch(request);
            if (score >= 0) {
                map.put(score, i);
            }
        });
        if (map.size() == 0) {
            return Optional.empty();
        }
        Invocation value = (Invocation)map.get(Collections.max(map.keySet()));
        value.log(request);
        return Optional.of(value);
    }

    @Override
    public void assertHeader(String key, String value) {
        if (this.invokes.stream().noneMatch(i -> i.hasExpectedHeader(key, value))) {
            throw new UnirestAssertion("No invocation found with header [%s: %s]\nFound:\n%s", key, value, this.allHeaders());
        }
    }

    private Headers allHeaders() {
        return this.invokes.stream().flatMap(i -> i.getRequests().stream()).map(HttpRequest::getHeaders).reduce((l, r) -> {
            l.putAll(r);
            return l;
        }).orElseGet(Headers::new);
    }

    @Override
    public void assertInvokedTimes(int i) {
        Integer sum = this.sumInvokes();
        if (sum != i) {
            throw new UnirestAssertion("Incorrect number of invocations. Expected %s got %s\n%s %s", i, sum, this.method, this.path);
        }
    }

    private Integer sumInvokes() {
        return this.invokes.stream().map(Invocation::requestSize).reduce(0, Integer::sum);
    }

    @Override
    public void verifyAll() {
        this.invokes.forEach(Invocation::verify);
    }

    HttpMethod getMethod() {
        return this.method;
    }

    String getPath() {
        return this.path;
    }
}

