/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import kong.unirest.GenericType;
import kong.unirest.ObjectMapper;
import kong.unirest.UnirestException;

public class GsonObjectMapper
implements ObjectMapper {
    public static final String ISO_8601 = "yyyy-MM-dd'T'HH:mm'Z'";
    private Gson gson;

    public GsonObjectMapper() {
    }

    public GsonObjectMapper(Gson gson) {
        this.gson = gson;
    }

    public <T> T readValue(String value, Class<T> valueType) {
        return (T)this.getGson().fromJson(value, valueType);
    }

    public <T> T readValue(String value, GenericType<T> genericType) {
        return (T)this.getGson().fromJson(value, genericType.getType());
    }

    public String writeValue(Object value) {
        return this.getGson().toJson(value);
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().setDateFormat(ISO_8601).disableHtmlEscaping().registerTypeHierarchyAdapter(Calendar.class, (Object)new CalendarSerializer()).registerTypeHierarchyAdapter(ZonedDateTime.class, (Object)new ZonedDateAdapter()).registerTypeAdapter(Date.class, (Object)new DateAdapter()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();
        }
        return this.gson;
    }

    private static class LocalDateAdapter
    extends DateTimeAdapter<LocalDate> {
        private LocalDateAdapter() {
        }

        @Override
        LocalDate from(Long millies) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(millies), ZoneId.systemDefault()).toLocalDate();
        }

        @Override
        LocalDate from(TemporalAccessor dt) {
            return LocalDate.from(dt);
        }
    }

    private static class LocalDateTimeAdapter
    extends DateTimeAdapter<LocalDateTime> {
        private LocalDateTimeAdapter() {
        }

        @Override
        LocalDateTime from(Long millies) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(millies), ZoneId.systemDefault());
        }

        @Override
        LocalDateTime from(TemporalAccessor dt) {
            if (dt.isSupported(ChronoField.HOUR_OF_DAY)) {
                return LocalDateTime.from(dt);
            }
            return LocalDate.from(dt).atStartOfDay();
        }
    }

    private static class ZonedDateAdapter
    extends DateTimeAdapter<ZonedDateTime> {
        private ZonedDateAdapter() {
        }

        @Override
        ZonedDateTime from(Long millies) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millies), ZoneId.systemDefault());
        }

        @Override
        ZonedDateTime from(TemporalAccessor dt) {
            if (dt.isSupported(ChronoField.HOUR_OF_DAY)) {
                return ZonedDateTime.from(dt);
            }
            return LocalDateTime.from(dt).atZone(ZoneId.systemDefault());
        }
    }

    private static class DateAdapter
    extends DateTimeAdapter<Date> {
        private DateAdapter() {
        }

        @Override
        Date from(Long millies) {
            return new Date(millies);
        }

        @Override
        Date from(TemporalAccessor dt) {
            return Date.from(this.toInstant(dt));
        }

        private Instant toInstant(TemporalAccessor dt) {
            if (dt.isSupported(ChronoField.HOUR_OF_DAY)) {
                return LocalDateTime.from(dt).atZone(ZoneId.systemDefault()).toInstant();
            }
            return LocalDate.from(dt).atStartOfDay(ZoneId.systemDefault()).toInstant();
        }

        @Override
        public JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(FORMATTER.format(ZonedDateTime.from(date.toInstant().atZone(ZoneId.systemDefault()))));
        }
    }

    private static class CalendarSerializer
    extends DateTimeAdapter<Calendar> {
        private CalendarSerializer() {
        }

        @Override
        public JsonElement serialize(Calendar calendar, Type type, JsonSerializationContext jsonSerializationContext) {
            GregorianCalendar gCal = (GregorianCalendar)calendar;
            String dateAsString = FORMATTER.format(gCal.toZonedDateTime());
            return jsonSerializationContext.serialize((Object)dateAsString);
        }

        @Override
        Calendar from(Long millies) {
            return GregorianCalendar.from(ZonedDateTime.ofInstant(Instant.ofEpochMilli(millies), ZoneId.systemDefault()));
        }

        @Override
        Calendar from(TemporalAccessor dt) {
            return GregorianCalendar.from(this.toZonedInstance(dt));
        }

        private ZonedDateTime toZonedInstance(TemporalAccessor dt) {
            if (dt.isSupported(ChronoField.HOUR_OF_DAY)) {
                return ZonedDateTime.from(dt);
            }
            return LocalDate.from(dt).atStartOfDay(ZoneId.systemDefault());
        }
    }

    private static abstract class DateTimeAdapter<T>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        static final List<DateTimeFormatter> FORMATS = Arrays.asList(DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_LOCAL_DATE_TIME);

        private DateTimeAdapter() {
        }

        abstract T from(Long var1);

        abstract T from(TemporalAccessor var1);

        public T deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonPrimitive()) {
                JsonPrimitive prim = jsonElement.getAsJsonPrimitive();
                if (prim.isNumber()) {
                    return this.from(prim.getAsLong());
                }
                if (prim.isString()) {
                    String asString = prim.getAsString();
                    for (DateTimeFormatter format : FORMATS) {
                        try {
                            TemporalAccessor dt = format.parse(asString);
                            return this.from(dt);
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            } else if (jsonElement.isJsonNull()) {
                return null;
            }
            throw new UnirestException(String.format("Could Not Parse as %s: %s", type.getTypeName(), jsonElement.getAsString()));
        }

        public JsonElement serialize(T dateObj, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(dateObj.toString());
        }
    }
}

