/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kong.unirest.core.ObjectMapper;
import kong.unirest.core.json.JSONElement;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JsonEngine;
import kong.unirest.gson.GsonArray;
import kong.unirest.gson.GsonNull;
import kong.unirest.gson.GsonObject;
import kong.unirest.gson.GsonObjectMapper;
import kong.unirest.gson.GsonPrimitive;

public class GsonEngine
implements JsonEngine {
    private static final TypeAdapter<Object> ADAPTER = new JavaTypeAdapter();
    private Gson gson;
    private Gson pretty;

    public GsonEngine() {
        GsonBuilder builder = new GsonBuilder().disableHtmlEscaping().serializeNulls().registerTypeAdapter(Map.class, ADAPTER).registerTypeAdapter(List.class, ADAPTER);
        this.gson = builder.create();
        this.pretty = builder.setPrettyPrinting().create();
    }

    static JsonEngine.Element toElement(JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject) {
            return new GsonObject((JsonObject)jsonElement);
        }
        if (jsonElement instanceof JsonArray) {
            return new GsonArray((JsonArray)jsonElement);
        }
        if (jsonElement instanceof JsonPrimitive) {
            return new GsonPrimitive((JsonPrimitive)jsonElement);
        }
        return new GsonNull();
    }

    public void toJson(JsonEngine.Element obj, Writer sw) {
        this.gson.toJson((JsonElement)obj.getEngineElement(), (Appendable)sw);
    }

    public void toPrettyJson(JsonEngine.Element obj, Writer sw) {
        this.pretty.toJson((JsonElement)obj.getEngineElement(), (Appendable)sw);
    }

    public String toPrettyJson(JsonEngine.Element obj) {
        if (obj instanceof JsonEngine.Element) {
            return this.pretty.toJson((JsonElement)obj.getEngineElement());
        }
        return this.pretty.toJson((Object)obj);
    }

    public String toJson(JsonEngine.Element obj) {
        if (obj instanceof JsonEngine.Element) {
            return this.gson.toJson((JsonElement)obj.getEngineElement());
        }
        return this.gson.toJson((Object)obj);
    }

    public JsonEngine.Element toJsonTree(Object obj) {
        return GsonEngine.toElement(this.gson.toJsonTree(obj));
    }

    public JsonEngine.Object newEngineObject() {
        return new GsonObject();
    }

    public JsonEngine.Object newEngineObject(String string) {
        try {
            JsonObject element = (JsonObject)this.gson.fromJson(string, JsonObject.class);
            return new GsonObject(element);
        }
        catch (JsonSyntaxException e) {
            throw new JSONException("Invalid JSON");
        }
    }

    public JsonEngine.Array newEngineArray() {
        return new GsonArray();
    }

    public <T> T fromJson(JsonEngine.Element obj, Class<T> mapClass) {
        return (T)this.gson.fromJson((JsonElement)obj.getEngineElement(), mapClass);
    }

    public JsonEngine.Array newJsonArray(String jsonString) {
        try {
            return new GsonArray((JsonArray)this.gson.fromJson(jsonString, JsonArray.class));
        }
        catch (JsonSyntaxException e) {
            throw new JSONException("Invalid JSON");
        }
    }

    public JsonEngine.Array newJsonArray(Collection<?> collection) {
        GsonArray a = new GsonArray();
        for (Object o : collection) {
            this.add(a, o);
        }
        return a;
    }

    private void add(GsonArray a, Object o) {
        if (o instanceof Number) {
            a.add((Number)o);
        } else if (o instanceof String) {
            a.add((String)o);
        } else if (o instanceof Boolean) {
            a.add((Boolean)o);
        } else if (o instanceof JSONElement) {
            a.add(((JSONElement)o).getElement());
        } else if (o instanceof JsonEngine.Element) {
            a.add((JsonEngine.Element)o);
        } else {
            JsonElement tree = this.gson.toJsonTree(o);
            a.add(GsonEngine.toElement(tree));
        }
    }

    public <T extends Enum> JsonEngine.Primitive newJsonPrimitive(T enumValue) {
        if (enumValue == null) {
            return new GsonNull();
        }
        return new GsonPrimitive(new JsonPrimitive(enumValue.name()));
    }

    public JsonEngine.Primitive newJsonPrimitive(String string) {
        if (string == null) {
            return new GsonNull();
        }
        return new GsonPrimitive(new JsonPrimitive(string));
    }

    public JsonEngine.Primitive newJsonPrimitive(Number number) {
        if (number == null) {
            return new GsonNull();
        }
        return new GsonPrimitive(new JsonPrimitive(number));
    }

    public JsonEngine.Primitive newJsonPrimitive(Boolean bool) {
        if (bool == null) {
            return new GsonNull();
        }
        return new GsonPrimitive(new JsonPrimitive(bool));
    }

    public ObjectMapper getObjectMapper() {
        return new GsonObjectMapper();
    }

    public String quote(Object s) {
        return this.gson.toJson(s);
    }

    static class JavaTypeAdapter
    extends TypeAdapter<Object> {
        private final TypeAdapter<Object> delegate = new Gson().getAdapter(Object.class);

        JavaTypeAdapter() {
        }

        public void write(JsonWriter out, Object value) throws IOException {
            this.delegate.write(out, value);
        }

        public Object read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            switch (token) {
                case BEGIN_ARRAY: {
                    ArrayList<Object> list = new ArrayList<Object>();
                    in.beginArray();
                    while (in.hasNext()) {
                        list.add(this.read(in));
                    }
                    in.endArray();
                    return list;
                }
                case BEGIN_OBJECT: {
                    LinkedTreeMap map = new LinkedTreeMap();
                    in.beginObject();
                    while (in.hasNext()) {
                        map.put(in.nextName(), this.read(in));
                    }
                    in.endObject();
                    return map;
                }
                case STRING: {
                    return in.nextString();
                }
                case NUMBER: {
                    String n = in.nextString();
                    if (n.indexOf(46) != -1) {
                        return Double.parseDouble(n);
                    }
                    long l = Long.parseLong(n);
                    if (l < Integer.MAX_VALUE) {
                        return (int)l;
                    }
                    return l;
                }
                case BOOLEAN: {
                    return in.nextBoolean();
                }
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            throw new IllegalStateException();
        }
    }
}

