/*
 * Decompiled with CFR 0.152.
 */
package com.konloch.httprequest;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HTTPRequest {
    public URL url;
    private int timeout = 30000;
    private String cookie;
    private String referer;
    private String postData;
    private String userAgent = "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:25.0) Gecko/20100101 Firefox/25.0";
    private Proxy proxy;
    private boolean setFollowRedirects = true;
    private BufferedReader reader;
    private DataOutputStream writer;
    private HttpURLConnection connection;
    private Set<Map.Entry<String, List<String>>> lastConnectionHeaders;
    private int lastStatusCode;

    public HTTPRequest(String url) throws MalformedURLException {
        this(new URL(url));
    }

    public HTTPRequest(URL url) {
        this.url = url;
    }

    public HTTPRequest setReferer(String referer) {
        this.referer = referer;
        return this;
    }

    public HTTPRequest setCookie(String cookie) {
        this.cookie = cookie;
        return this;
    }

    public HTTPRequest setPostData(String postData) {
        this.postData = postData;
        return this;
    }

    public HTTPRequest setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public HTTPRequest setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public HTTPRequest setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public HTTPRequest setFollowRedirects(boolean setFollowRedirects) {
        this.setFollowRedirects = setFollowRedirects;
        return this;
    }

    public Set<Map.Entry<String, List<String>>> getLastConnectionHeaders() {
        return this.lastConnectionHeaders;
    }

    public int getLastStatusCode() {
        return this.lastStatusCode;
    }

    public String readSingle() throws IOException {
        return this.read(1).get(0);
    }

    public String readString() throws IOException {
        return String.join((CharSequence)File.separator, this.read());
    }

    public String[] readArray() throws IOException {
        return this.readArray(-1);
    }

    public String[] readArray(int linesToRead) throws IOException {
        ArrayList<String> lines = this.read(linesToRead);
        return lines.toArray(new String[lines.size()]);
    }

    public ArrayList<String> read() throws IOException {
        return this.read(-1);
    }

    public ArrayList<String> read(int linesToRead) throws IOException {
        ArrayList<String> lines;
        try {
            String s;
            this.setup();
            lines = new ArrayList<String>();
            int counter = 0;
            while ((s = this.reader.readLine()) != null) {
                lines.add(s);
                if (linesToRead <= 0 || counter++ < linesToRead) continue;
            }
            this.lastConnectionHeaders = this.connection.getHeaderFields().entrySet();
            this.lastStatusCode = this.connection.getResponseCode();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.cleanup();
        }
        return lines;
    }

    public byte[] readBytes() throws IOException {
        ByteArrayOutputStream buffer;
        try {
            int read;
            this.setup();
            buffer = new ByteArrayOutputStream();
            while ((read = this.reader.read()) != -1) {
                buffer.write((byte)read);
            }
            this.lastConnectionHeaders = this.connection.getHeaderFields().entrySet();
            this.lastStatusCode = this.connection.getResponseCode();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.cleanup();
        }
        return buffer.toByteArray();
    }

    private void setup() throws IOException {
        this.connection = this.proxy != null ? (HttpURLConnection)this.url.openConnection(this.proxy) : (HttpURLConnection)this.url.openConnection();
        if (this.cookie != null) {
            this.connection.setRequestProperty("Cookie", this.cookie);
        }
        if (this.referer != null) {
            this.connection.addRequestProperty("Referer", this.referer);
        }
        this.connection.setRequestProperty("User-Agent", this.userAgent);
        this.connection.setReadTimeout(this.timeout);
        this.connection.setConnectTimeout(this.timeout);
        this.connection.setUseCaches(false);
        HttpURLConnection.setFollowRedirects(this.setFollowRedirects);
        if (this.postData != null) {
            this.connection.setRequestMethod("POST");
            this.connection.setDoOutput(true);
            this.connection.setDoInput(true);
            this.writer = new DataOutputStream(this.connection.getOutputStream());
            this.writer.writeBytes(this.postData);
            this.writer.flush();
        }
        this.reader = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
    }

    private void cleanup() {
        try {
            this.reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.reader = null;
        this.writer = null;
        this.connection = null;
    }

    public static void main(String[] args) {
        throw new RuntimeException("Incorrect usage - for information on how to use this correctly visit https://konloch.com/HTTPRequest/");
    }
}

