/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.kotcrab.vis.ui.Focusable;

public class FocusManager {
    private static Focusable focusedWidget;

    public static void switchFocus(Stage stage, Focusable widget) {
        if (focusedWidget == widget) {
            return;
        }
        if (focusedWidget != null) {
            focusedWidget.focusLost();
        }
        focusedWidget = null;
        if (stage != null) {
            stage.setKeyboardFocus(null);
        }
        focusedWidget = widget;
        focusedWidget.focusGained();
    }

    public static void resetFocus(Stage stage) {
        if (focusedWidget != null) {
            focusedWidget.focusLost();
        }
        if (stage != null) {
            stage.setKeyboardFocus(null);
        }
        focusedWidget = null;
    }

    public static void resetFocus(Stage stage, Actor caller) {
        if (focusedWidget != null) {
            focusedWidget.focusLost();
        }
        if (stage != null && stage.getKeyboardFocus() == caller) {
            stage.setKeyboardFocus(null);
        }
        focusedWidget = null;
    }

    public static Focusable getFocusedWidget() {
        return focusedWidget;
    }
}

