/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.building;

import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.IntArray;
import com.kotcrab.vis.ui.building.TableBuilder;
import com.kotcrab.vis.ui.building.utilities.Padding;

public class CenteredTableBuilder
extends TableBuilder {
    public CenteredTableBuilder() {
    }

    public CenteredTableBuilder(Padding defaultWidgetPadding) {
        super(defaultWidgetPadding);
    }

    public CenteredTableBuilder(int estimatedWidgetsAmount, int estimatedRowsAmount) {
        super(estimatedWidgetsAmount, estimatedRowsAmount);
    }

    public CenteredTableBuilder(int estimatedWidgetsAmount, int estimatedRowsAmount, Padding defaultWidgetPadding) {
        super(estimatedWidgetsAmount, estimatedRowsAmount, defaultWidgetPadding);
    }

    @Override
    protected void fillTable(Table table) {
        IntArray rowSizes = this.getRowSizes();
        int widgetsInRow = CenteredTableBuilder.getLowestCommonMultiple(rowSizes);
        int widgetIndex = 0;
        for (int rowIndex = 0; rowIndex < rowSizes.size; ++rowIndex) {
            int rowSize = rowSizes.get(rowIndex);
            int currentWidgetColspan = widgetsInRow / rowSize;
            boolean isFirst = this.shouldExpand(rowSize);
            int totalWidgetsBeforeRowEnd = widgetIndex + rowSize;
            while (widgetIndex < totalWidgetsBeforeRowEnd) {
                Cell cell = this.getWidget(widgetIndex).buildCell(table, this.getDefaultWidgetPadding()).colspan(currentWidgetColspan);
                if (isFirst) {
                    isFirst = false;
                    cell.expandX().right();
                } else if (this.isLast(widgetIndex, rowSize, totalWidgetsBeforeRowEnd)) {
                    cell.expandX().left();
                }
                ++widgetIndex;
            }
            table.row();
        }
    }

    private boolean shouldExpand(int rowSize) {
        return rowSize != 1;
    }

    private boolean isLast(int widgetIndex, int rowSize, int totalWidgetsInRow) {
        return this.shouldExpand(rowSize) && widgetIndex == totalWidgetsInRow - 1;
    }
}

