/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.building;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.kotcrab.vis.ui.building.utilities.CellWidget;
import com.kotcrab.vis.ui.building.utilities.Padding;
import com.kotcrab.vis.ui.building.utilities.layouts.ActorLayout;
import com.kotcrab.vis.ui.building.utilities.layouts.TableLayout;

public abstract class TableBuilder {
    private static final int DEFAULT_WIDGETS_AMOUNT = 10;
    private static final int DEFAULT_ROWS_AMOUNT = 3;
    private final Array<CellWidget<? extends Actor>> widgets;
    private final IntArray rowSizes;
    private int currentRowSize;
    private final Padding widgetPadding;
    private Padding tablePadding;

    public TableBuilder() {
        this(10, 3, Padding.PAD_0);
    }

    public TableBuilder(Padding defaultWidgetPadding) {
        this(10, 3, defaultWidgetPadding);
    }

    public TableBuilder(int estimatedWidgetsAmount, int estimatedRowsAmount) {
        this(estimatedWidgetsAmount, estimatedRowsAmount, Padding.PAD_0);
    }

    public TableBuilder(int estimatedWidgetsAmount, int estimatedRowsAmount, Padding defaultWidgetPadding) {
        this.widgets = new Array(estimatedWidgetsAmount);
        this.rowSizes = new IntArray(estimatedRowsAmount);
        this.widgetPadding = defaultWidgetPadding;
    }

    public static int getGreatestCommonDenominator(int valueA, int valueB) {
        return valueB == 0 ? valueA : TableBuilder.getGreatestCommonDenominator(valueB, valueA % valueB);
    }

    public static int getLowestCommonMultiple(int valueA, int valueB) {
        return valueA * (valueB / TableBuilder.getGreatestCommonDenominator(valueA, valueB));
    }

    public static int getLowestCommonMultiple(IntArray values) {
        int lowestCommonMultiple = values.first();
        for (int index = 1; index < values.size; ++index) {
            lowestCommonMultiple = TableBuilder.getLowestCommonMultiple(lowestCommonMultiple, values.get(index));
        }
        return lowestCommonMultiple;
    }

    public TableBuilder setTablePadding(Padding tablePadding) {
        this.tablePadding = tablePadding;
        return this;
    }

    protected Padding getDefaultWidgetPadding() {
        return this.widgetPadding;
    }

    public TableBuilder append(Actor widget) {
        return this.append((CellWidget<? extends Actor>)CellWidget.of(widget).padding(this.widgetPadding).wrap());
    }

    public TableBuilder append(CellWidget<? extends Actor> widget) {
        this.widgets.add(widget);
        ++this.currentRowSize;
        return this;
    }

    public TableBuilder append(Actor ... widgets) {
        return this.append((ActorLayout)TableLayout.HORIZONTAL, widgets);
    }

    public TableBuilder append(CellWidget<?> ... widgets) {
        return this.append((ActorLayout)TableLayout.HORIZONTAL, widgets);
    }

    public TableBuilder append(ActorLayout layout, Actor ... widgets) {
        return this.append(layout.convertToActor(widgets));
    }

    public TableBuilder append(ActorLayout layout, CellWidget<?> ... widgets) {
        return this.append(layout.convertToActor(widgets));
    }

    public TableBuilder append(CellWidget.CellWidgetBuilder<Actor> mergedCellSettings, Actor ... widgets) {
        return this.append((ActorLayout)TableLayout.HORIZONTAL, mergedCellSettings, widgets);
    }

    public TableBuilder append(CellWidget.CellWidgetBuilder<Actor> mergedCellSettings, CellWidget<?> ... widgets) {
        return this.append((ActorLayout)TableLayout.HORIZONTAL, mergedCellSettings, widgets);
    }

    public TableBuilder append(ActorLayout layout, CellWidget.CellWidgetBuilder<Actor> mergedCellSettings, Actor ... widgets) {
        return this.append((CellWidget<? extends Actor>)mergedCellSettings.widget(layout.convertToActor(widgets)).wrap());
    }

    public TableBuilder append(ActorLayout layout, CellWidget.CellWidgetBuilder<Actor> mergedCellSettings, CellWidget<?> ... widgets) {
        return this.append((CellWidget<? extends Actor>)mergedCellSettings.widget(layout.convertToActor(widgets)).wrap());
    }

    public TableBuilder append() {
        return this.append((CellWidget<? extends Actor>)CellWidget.EMPTY);
    }

    public TableBuilder row() {
        if (this.currentRowSize != 0) {
            this.rowSizes.add(this.currentRowSize);
            this.currentRowSize = 0;
        }
        return this;
    }

    public Table build() {
        return this.build(new Table());
    }

    public <T extends Table> T build(T table) {
        this.prepareNewTable(table);
        if (this.widgets.size == 0) {
            return table;
        }
        this.fillTable(table);
        return this.prepareBuiltTable(table);
    }

    private Table prepareNewTable(Table table) {
        this.validateRowSize();
        if (this.tablePadding != null) {
            return this.tablePadding.applyPadding(table);
        }
        return table;
    }

    protected abstract void fillTable(Table var1);

    private <T extends Table> T prepareBuiltTable(T table) {
        table.pack();
        return table;
    }

    private void validateRowSize() {
        if (this.currentRowSize != 0) {
            this.row();
        }
    }

    protected IntArray getRowSizes() {
        return this.rowSizes;
    }

    protected CellWidget<? extends Actor> getWidget(int index) {
        return (CellWidget)this.widgets.get(index);
    }

    protected Array<CellWidget<? extends Actor>> getWidgets() {
        return this.widgets;
    }
}

