/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.layout;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.utils.SnapshotArray;
import com.kotcrab.vis.ui.layout.FloatingGroup;
import com.kotcrab.vis.ui.layout.GridGroup;
import com.kotcrab.vis.ui.layout.HorizontalFlowGroup;
import com.kotcrab.vis.ui.layout.VerticalFlowGroup;
import com.kotcrab.vis.ui.widget.Draggable;

public class DragPane
extends Container<WidgetGroup> {
    private Draggable draggable;
    private DragPaneListener listener;

    public DragPane() {
        this(false);
    }

    public DragPane(boolean vertical) {
        this((WidgetGroup)(vertical ? new VerticalGroup() : new HorizontalGroup()));
    }

    public DragPane(WidgetGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null.");
        }
        super.setActor((Actor)group);
        this.setTouchable(Touchable.enabled);
    }

    public boolean isVertical() {
        return this.getActor() instanceof VerticalGroup;
    }

    public boolean isHorizontal() {
        return this.getActor() instanceof HorizontalGroup;
    }

    public boolean isGrid() {
        return this.getActor() instanceof GridGroup;
    }

    public boolean isVerticalFlow() {
        return this.getActor() instanceof VerticalFlowGroup;
    }

    public boolean isHorizontalFlow() {
        return this.getActor() instanceof HorizontalFlowGroup;
    }

    public boolean isFloating() {
        return this.getActor() instanceof FloatingGroup;
    }

    public SnapshotArray<Actor> getChildren() {
        return ((WidgetGroup)this.getActor()).getChildren();
    }

    public WidgetGroup getGroup() {
        return (WidgetGroup)this.getActor();
    }

    public void setGroup(WidgetGroup group) {
        this.setActor(group);
    }

    public void setActor(WidgetGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null.");
        }
        Group previousGroup = (Group)this.getActor();
        super.setActor((Actor)group);
        this.attachListener();
        for (Actor child : previousGroup.getChildren()) {
            group.addActor(child);
        }
    }

    public HorizontalGroup getHorizontalGroup() {
        return (HorizontalGroup)this.getActor();
    }

    public VerticalGroup getVerticalGroup() {
        return (VerticalGroup)this.getActor();
    }

    public GridGroup getGridGroup() {
        return (GridGroup)this.getActor();
    }

    public HorizontalFlowGroup getHorizontalFlowGroup() {
        return (HorizontalFlowGroup)this.getActor();
    }

    public VerticalFlowGroup getVerticalFlowGroup() {
        return (VerticalFlowGroup)this.getActor();
    }

    public FloatingGroup getFloatingGroup() {
        return (FloatingGroup)this.getActor();
    }

    public Draggable getDraggable() {
        return this.draggable;
    }

    public void setDraggable(Draggable draggable) {
        this.removeListener();
        this.draggable = draggable;
        this.attachListener();
    }

    public void setBounds(float x, float y, float width, float height) {
        super.setBounds(x, y, width, height);
        ((WidgetGroup)this.getActor()).setWidth(width);
        ((WidgetGroup)this.getActor()).setHeight(height);
    }

    public void setWidth(float width) {
        super.setWidth(width);
        ((WidgetGroup)this.getActor()).setWidth(width);
    }

    public void setHeight(float height) {
        super.setHeight(height);
        ((WidgetGroup)this.getActor()).setHeight(height);
    }

    private void removeListener() {
        if (this.draggable == null) {
            return;
        }
        for (Actor actor : this.getChildren()) {
            actor.removeListener((EventListener)this.draggable);
        }
    }

    private void attachListener() {
        if (this.draggable == null) {
            return;
        }
        for (Actor actor : this.getChildren()) {
            this.draggable.attachTo(actor);
        }
    }

    public boolean contains(Actor actor) {
        return actor.getParent() == this.getActor();
    }

    public boolean removeActor(Actor actor) {
        return this.removeActor(actor, true);
    }

    public boolean removeActor(Actor actor, boolean unfocus) {
        if (((WidgetGroup)this.getActor()).getChildren().contains((Object)actor, true)) {
            Stage stage = actor.getStage();
            ((WidgetGroup)this.getActor()).removeActor(actor, false);
            if (unfocus && stage != null) {
                stage.unfocus(actor);
            }
            return true;
        }
        return false;
    }

    public void clear() {
        ((WidgetGroup)this.getActor()).clear();
    }

    public void addActor(Actor actor) {
        ((WidgetGroup)this.getActor()).addActor(actor);
        this.doOnAdd(actor);
    }

    public void addActorAfter(Actor actorAfter, Actor actor) {
        ((WidgetGroup)this.getActor()).addActorAfter(actorAfter, actor);
        this.doOnAdd(actor);
    }

    public void addActorAt(int index, Actor actor) {
        ((WidgetGroup)this.getActor()).addActorAt(index, actor);
        this.doOnAdd(actor);
    }

    public void addActorBefore(Actor actorBefore, Actor actor) {
        ((WidgetGroup)this.getActor()).addActorBefore(actorBefore, actor);
        this.doOnAdd(actor);
    }

    protected void doOnAdd(Actor actor) {
        if (this.draggable != null) {
            this.draggable.attachTo(actor);
        }
    }

    public <T extends Actor> T findActor(String name) {
        return (T)((WidgetGroup)this.getActor()).findActor(name);
    }

    public void invalidate() {
        super.invalidate();
        ((WidgetGroup)this.getActor()).invalidate();
    }

    public void validate() {
        super.validate();
        ((WidgetGroup)this.getActor()).validate();
    }

    public void setListener(DragPaneListener listener) {
        this.listener = listener;
    }

    protected boolean accept(Actor actor) {
        return this.listener == null || this.listener.accept(this, actor);
    }

    public static interface DragPaneListener {
        public static final boolean ACCEPT = true;
        public static final boolean REFUSE = false;

        public boolean accept(DragPane var1, Actor var2);

        public static class LimitChildren
        implements DragPaneListener {
            private final int max;

            public LimitChildren(int max) {
                this.max = max;
            }

            @Override
            public boolean accept(DragPane dragPane, Actor actor) {
                return dragPane.contains(actor) || dragPane.getChildren().size < this.max;
            }
        }

        public static class AcceptOwnChildren
        implements DragPaneListener {
            @Override
            public boolean accept(DragPane dragPane, Actor actor) {
                return dragPane.contains(actor);
            }
        }
    }

    public static class DefaultDragListener
    implements Draggable.DragListener {
        protected static final Vector2 DRAG_POSITION = new Vector2();
        private Policy policy;

        public DefaultDragListener() {
            this(DefaultPolicy.ALLOW_REMOVAL);
        }

        public DefaultDragListener(Policy policy) {
            this.setPolicy(policy);
        }

        public void setPolicy(Policy policy) {
            if (policy == null) {
                throw new IllegalArgumentException("Policy cannot be null.");
            }
            this.policy = policy;
        }

        @Override
        public boolean onStart(Draggable draggable, Actor actor, float stageX, float stageY) {
            return true;
        }

        @Override
        public void onDrag(Draggable draggable, Actor actor, float stageX, float stageY) {
        }

        @Override
        public boolean onEnd(Draggable draggable, Actor actor, float stageX, float stageY) {
            if (actor == null || actor.getStage() == null) {
                return false;
            }
            Actor overActor = actor.getStage().hit(stageX, stageY, true);
            if (overActor == null || overActor == actor) {
                return false;
            }
            if (overActor.isAscendantOf(actor)) {
                DragPane dragPane = this.getDragPane(actor);
                if (dragPane != null && dragPane.isFloating()) {
                    DRAG_POSITION.set(stageX, stageY);
                    return this.addToFloatingGroup(draggable, actor, dragPane);
                }
                return false;
            }
            DRAG_POSITION.set(stageX, stageY);
            if (overActor instanceof DragPane) {
                return this.addDirectlyToPane(draggable, actor, (DragPane)overActor);
            }
            DragPane dragPane = this.getDragPane(overActor);
            if (this.accept(actor, dragPane)) {
                return this.addActor(draggable, actor, overActor, dragPane);
            }
            return false;
        }

        protected boolean addDirectlyToPane(Draggable draggable, Actor actor, DragPane dragPane) {
            if (this.accept(actor, dragPane)) {
                if (dragPane.isFloating()) {
                    return this.addToFloatingGroup(draggable, actor, dragPane);
                }
                dragPane.addActor(actor);
                return true;
            }
            return false;
        }

        protected boolean accept(Actor actor, DragPane dragPane) {
            return dragPane != null && dragPane.accept(actor) && this.policy.accept(dragPane, actor);
        }

        protected boolean addActor(Draggable draggable, Actor actor, Actor overActor, DragPane dragPane) {
            Actor directPaneChild = this.getActorInDragPane(overActor, dragPane);
            directPaneChild.stageToLocalCoordinates(DRAG_POSITION);
            if (dragPane.isVertical() || dragPane.isVerticalFlow()) {
                return this.addToVerticalGroup(actor, dragPane, directPaneChild);
            }
            if (dragPane.isHorizontal() || dragPane.isHorizontalFlow()) {
                return this.addToHorizontalGroup(actor, dragPane, directPaneChild);
            }
            if (dragPane.isFloating()) {
                return this.addToFloatingGroup(draggable, actor, dragPane);
            }
            return this.addToOtherGroup(actor, dragPane, directPaneChild);
        }

        protected boolean addToHorizontalGroup(Actor actor, DragPane dragPane, Actor directPaneChild) {
            SnapshotArray<Actor> children = dragPane.getChildren();
            int indexOfDraggedActor = children.indexOf((Object)actor, true);
            actor.remove();
            if (indexOfDraggedActor >= 0) {
                int indexOfDirectChild = children.indexOf((Object)directPaneChild, true);
                if (indexOfDirectChild > indexOfDraggedActor) {
                    dragPane.addActorAfter(directPaneChild, actor);
                } else {
                    dragPane.addActorBefore(directPaneChild, actor);
                }
            } else if (DefaultDragListener.DRAG_POSITION.x > directPaneChild.getWidth() / 2.0f) {
                dragPane.addActorAfter(directPaneChild, actor);
            } else {
                dragPane.addActorBefore(directPaneChild, actor);
            }
            return true;
        }

        protected boolean addToVerticalGroup(Actor actor, DragPane dragPane, Actor directPaneChild) {
            SnapshotArray<Actor> children = dragPane.getChildren();
            int indexOfDraggedActor = children.indexOf((Object)actor, true);
            actor.remove();
            if (indexOfDraggedActor >= 0) {
                int indexOfDirectChild = children.indexOf((Object)directPaneChild, true);
                if (indexOfDirectChild > indexOfDraggedActor) {
                    dragPane.addActorAfter(directPaneChild, actor);
                } else {
                    dragPane.addActorBefore(directPaneChild, actor);
                }
            } else if (DefaultDragListener.DRAG_POSITION.y < directPaneChild.getHeight() / 2.0f) {
                dragPane.addActorAfter(directPaneChild, actor);
            } else {
                dragPane.addActorBefore(directPaneChild, actor);
            }
            return true;
        }

        protected boolean addToFloatingGroup(Draggable draggable, Actor actor, DragPane dragPane) {
            float y;
            FloatingGroup group = dragPane.getFloatingGroup();
            dragPane.stageToLocalCoordinates(DRAG_POSITION);
            float x = DefaultDragListener.DRAG_POSITION.x + draggable.getOffsetX();
            if (x < 0.0f || x + actor.getWidth() > dragPane.getWidth()) {
                if (draggable.isKeptWithinParent()) {
                    x = x < 0.0f ? 0.0f : dragPane.getWidth() - actor.getWidth() - 1.0f;
                } else {
                    return false;
                }
            }
            if ((y = DefaultDragListener.DRAG_POSITION.y + draggable.getOffsetY()) < 0.0f || y + actor.getHeight() > dragPane.getHeight()) {
                if (draggable.isKeptWithinParent()) {
                    y = y < 0.0f ? 0.0f : dragPane.getHeight() - actor.getHeight() - 1.0f;
                } else {
                    return false;
                }
            }
            actor.remove();
            actor.setPosition(x, y);
            group.addActor(actor);
            return true;
        }

        protected boolean addToOtherGroup(Actor actor, DragPane dragPane, Actor directPaneChild) {
            SnapshotArray<Actor> children = dragPane.getChildren();
            int indexOfDirectChild = children.indexOf((Object)directPaneChild, true);
            int indexOfDraggedActor = children.indexOf((Object)actor, true);
            actor.remove();
            if (indexOfDraggedActor >= 0) {
                if (indexOfDraggedActor > indexOfDirectChild) {
                    dragPane.addActorBefore(directPaneChild, actor);
                } else {
                    dragPane.addActorAfter(directPaneChild, actor);
                }
            } else if (indexOfDirectChild == children.size - 1) {
                if (DefaultDragListener.DRAG_POSITION.y < directPaneChild.getHeight() / 2.0f || DefaultDragListener.DRAG_POSITION.x > directPaneChild.getWidth() / 2.0f) {
                    dragPane.addActor(actor);
                } else {
                    dragPane.addActorBefore(directPaneChild, actor);
                }
            } else if (indexOfDirectChild == 0) {
                if (DefaultDragListener.DRAG_POSITION.y < directPaneChild.getHeight() / 2.0f || DefaultDragListener.DRAG_POSITION.x > directPaneChild.getWidth() / 2.0f) {
                    dragPane.addActorAfter(directPaneChild, actor);
                } else {
                    dragPane.addActorBefore(directPaneChild, actor);
                }
            } else {
                dragPane.addActorBefore(directPaneChild, actor);
            }
            return true;
        }

        protected Actor getActorInDragPane(Actor actor, DragPane dragPane) {
            while (actor != dragPane && actor != null) {
                if (dragPane.contains(actor)) {
                    return actor;
                }
                actor = actor.getParent();
            }
            return null;
        }

        protected DragPane getDragPane(Actor fromActor) {
            while (fromActor != null) {
                if (fromActor instanceof DragPane) {
                    return (DragPane)fromActor;
                }
                fromActor = fromActor.getParent();
            }
            return null;
        }

        public static enum DefaultPolicy implements Policy
        {
            ALLOW_REMOVAL{

                @Override
                public boolean accept(DragPane dragPane, Actor actor) {
                    return true;
                }
            }
            ,
            KEEP_CHILDREN{

                @Override
                public boolean accept(DragPane dragPane, Actor actor) {
                    return dragPane.contains(actor);
                }
            };

        }

        public static interface Policy {
            public boolean accept(DragPane var1, Actor var2);
        }
    }
}

