/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util.async;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import com.kotcrab.vis.ui.util.async.AsyncTaskListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AsyncTask {
    private String threadName;
    private Status status = Status.PENDING;
    private Array<AsyncTaskListener> listeners = new Array();

    public AsyncTask(String threadName) {
        this.threadName = threadName;
    }

    public void execute() {
        if (this.status == Status.RUNNING) {
            throw new IllegalStateException("Task is already running.");
        }
        if (this.status == Status.FINISHED) {
            throw new IllegalStateException("Task has been already executed and can't be reused.");
        }
        this.status = Status.RUNNING;
        new Thread(new Runnable(){

            @Override
            public void run() {
                AsyncTask.this.executeInBackground();
            }
        }, this.threadName).start();
    }

    private void executeInBackground() {
        try {
            this.doInBackground();
        }
        catch (Exception e) {
            this.failed(e);
        }
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                for (AsyncTaskListener listener : AsyncTask.this.listeners) {
                    listener.finished();
                }
                AsyncTask.this.status = Status.FINISHED;
            }
        });
    }

    protected abstract void doInBackground() throws Exception;

    protected void failed(String message) {
        this.failed(message, new IllegalStateException(message));
    }

    protected void failed(Exception exception) {
        this.failed(exception.getMessage(), exception);
    }

    protected void failed(final String message, final Exception exception) {
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                for (AsyncTaskListener listener : AsyncTask.this.listeners) {
                    listener.failed(message, exception);
                }
            }
        });
    }

    protected void setProgressPercent(final int progressPercent) {
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                for (AsyncTaskListener listener : AsyncTask.this.listeners) {
                    listener.progressChanged(progressPercent);
                }
            }
        });
    }

    protected void setMessage(final String message) {
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                for (AsyncTaskListener listener : AsyncTask.this.listeners) {
                    listener.messageChanged(message);
                }
            }
        });
    }

    protected void executeOnGdx(final Runnable runnable) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference exceptionAt = new AtomicReference();
        Gdx.app.postRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    exceptionAt.set(e);
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            latch.await();
            Exception e = (Exception)exceptionAt.get();
            if (e != null) {
                this.failed(e);
            }
        }
        catch (InterruptedException e) {
            this.failed(e);
        }
    }

    public void addListener(AsyncTaskListener listener) {
        this.listeners.add((Object)listener);
    }

    public boolean removeListener(AsyncTaskListener listener) {
        return this.listeners.removeValue((Object)listener, true);
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Status getStatus() {
        return this.status;
    }

    static enum Status {
        PENDING,
        RUNNING,
        FINISHED;

    }
}

