/*
 * Decompiled with CFR 0.152.
 */
package com.kotcrab.vis.ui.util.async;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.kotcrab.vis.ui.Locales;
import com.kotcrab.vis.ui.util.TableUtils;
import com.kotcrab.vis.ui.util.async.AsyncTask;
import com.kotcrab.vis.ui.util.async.AsyncTaskListener;
import com.kotcrab.vis.ui.util.dialog.Dialogs;
import com.kotcrab.vis.ui.widget.VisLabel;
import com.kotcrab.vis.ui.widget.VisProgressBar;
import com.kotcrab.vis.ui.widget.VisWindow;

public class AsyncTaskProgressDialog
extends VisWindow {
    private AsyncTask task;

    public AsyncTaskProgressDialog(String title, AsyncTask task) {
        super(title);
        this.task = task;
        this.setModal(true);
        TableUtils.setSpacingDefaults((Table)this);
        final VisLabel statusLabel = new VisLabel(Locales.CommonText.PLEASE_WAIT.get());
        final VisProgressBar progressBar = new VisProgressBar(0.0f, 100.0f, 1.0f, false);
        this.defaults().padLeft(6.0f).padRight(6.0f);
        this.add((Actor)statusLabel).padTop(6.0f).left().row();
        this.add((Actor)progressBar).width(300.0f).padTop(6.0f).padBottom(6.0f);
        task.addListener(new AsyncTaskListener(){

            @Override
            public void progressChanged(int newProgressPercent) {
                progressBar.setValue(newProgressPercent);
            }

            @Override
            public void messageChanged(String message) {
                statusLabel.setText(message);
            }

            @Override
            public void finished() {
                AsyncTaskProgressDialog.this.fadeOut();
            }

            @Override
            public void failed(String message, Exception exception) {
                Dialogs.showErrorDialog(AsyncTaskProgressDialog.this.getStage(), exception.getMessage() == null ? Locales.CommonText.UNKNOWN_ERROR_OCCURRED.get() : exception.getMessage(), exception);
            }
        });
        this.pack();
        this.centerWindow();
        task.execute();
    }

    public AsyncTask getTask() {
        return this.task;
    }

    public void addListener(AsyncTaskListener listener) {
        this.task.addListener(listener);
    }

    public AsyncTask.Status getStatus() {
        return this.task.getStatus();
    }
}

